/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model;

import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.IFMMQQueryInput;
import com.ibm.etools.fm.core.model.MessageQueue;
import com.ibm.etools.fm.core.model.MessageQueueManager;
import com.ibm.etools.fm.core.socket.func.MQQL;
import com.ibm.etools.fm.core.socket.func.MQQLParser;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.pdtools.common.component.core.model.PDPlatformObject;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.registery.EListener;
import com.ibm.pdtools.common.component.jhost.registery.EntityEvent;
import com.ibm.pdtools.common.component.jhost.registery.EntityEventDispatcher;
import com.ibm.pdtools.common.component.jhost.registery.IEntityEventDispatcher;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

public class MessageQueueQuery
extends PDPlatformObject
implements IEntityEventDispatcher<MessageQueueQuery>,
IFMMQQueryInput {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String MULTI_CHAR_WILDCARD = "*";
    public static final Object PROPERTY_QUERY = new Object();
    public static final Object PROPERTY_LOADED_MESSAGE_QUEUES = new Object();
    private static final Pattern VALID_QUERY = Pattern.compile("[A-Za-z0-9_%/.*]{1,48}");
    private MessageQueueManager mqm;
    private String query;
    private List<MessageQueue> messageQueues;
    private Pattern matchMQPattern = null;
    private final EntityEventDispatcher<MessageQueueQuery> eventDispatcher = new EntityEventDispatcher((Object)this);

    public static boolean isValidQuery(IPDHost host, String query) {
        Objects.requireNonNull(query, "Please provide a non-null query.");
        String nameCheck = null;
        try {
            nameCheck = new String(query.getBytes(host.getCodePage()), host.getCommunicationCodePage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return VALID_QUERY.matcher(nameCheck).matches();
    }

    public static MessageQueueQuery createForManager(MessageQueueManager manager) {
        return new MessageQueueQuery(manager, MULTI_CHAR_WILDCARD);
    }

    public static Pattern convertToRegexp(String query) {
        String matchString = StringUtils.escapeRegex((String)query);
        matchString = matchString.replaceAll(StringUtils.escapeRegex((String)"\\*"), ".*");
        matchString = matchString.replaceAll("%", ".");
        return Pattern.compile(matchString, 66);
    }

    public static MessageQueueQuery create(MessageQueueManager mqm, String query) {
        return new MessageQueueQuery(mqm, query);
    }

    public MessageQueueQuery(MessageQueueManager mqm, String query) {
        Objects.requireNonNull(mqm, "Please provide a non-null mqm.");
        if (!MessageQueueQuery.isValidQuery(mqm.getSystem(), query)) {
            throw new IllegalArgumentException(query);
        }
        this.mqm = mqm;
        this.query = query;
        this.setLoadFinishedListener(mqm.getLoadFinishedListener());
    }

    public MessageQueueQuery clone() {
        MessageQueueQuery copy = MessageQueueQuery.create(this.mqm, this.query);
        if (this.messageQueues != null) {
            copy.setMessageQueues(new ArrayList<MessageQueue>(this.messageQueues));
        }
        return copy;
    }

    public boolean equals(Object obj) {
        return obj instanceof MessageQueueQuery && ((MessageQueueQuery)obj).mqm.equals(this.mqm) && ((MessageQueueQuery)obj).query.equals(this.query);
    }

    public int hashCode() {
        return this.mqm.hashCode() * this.query.hashCode();
    }

    public String toString() {
        return this.getLabel();
    }

    public String getLabel() {
        return "MQ:" + this.mqm.getName() + ":" + this.getQuery();
    }

    public IPDHost getSystem() {
        return this.mqm.getSystem();
    }

    public void setSystem(IPDHost system) {
        this.mqm.setSystem(system);
    }

    public List<MessageQueue> getMessageQueues() {
        return this.messageQueues;
    }

    protected void setMessageQueues(List<MessageQueue> messageQueues) {
        this.messageQueues = messageQueues;
        this.eventDispatcher.fireChangedEvent(PROPERTY_LOADED_MESSAGE_QUEUES);
    }

    public Result<List<MessageQueue>> loadMessageQueues(IHowIsGoing monitor, boolean loadProperties) throws InterruptedException {
        MQQL mqql = new MQQL();
        mqql.setMqmgr(this.getMQManager().getName());
        mqql.setQName(this.getQuery());
        mqql.setProps(loadProperties);
        Result result = UtilityFunctionRunner.executeAndParse(this.getSystem(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.getSystem()), mqql, new MQQLParser(this.getSystem()), monitor);
        this.setMessageQueues((List)result.getOutput());
        return result;
    }

    public void setQuery(String mqQuery) {
        this.query = Objects.requireNonNull(mqQuery, "Must provide a non-null mqQuery").toUpperCase();
        this.eventDispatcher.fireChangedEvent(PROPERTY_QUERY);
    }

    public String getQuery() {
        return this.query;
    }

    public MessageQueueManager getMQManager() {
        return this.mqm;
    }

    public boolean matches(MessageQueue mq) {
        Objects.requireNonNull(mq, "Must provide a non-null mq");
        if (!mq.getManager().equals(this.getMQManager())) {
            return false;
        }
        if (this.matchMQPattern == null) {
            this.matchMQPattern = MessageQueueQuery.convertToRegexp(this.query);
        }
        return this.matchMQPattern.matcher(mq.getName()).matches();
    }

    public void addListener(EListener<EntityEvent<MessageQueueQuery>> listener) {
        this.eventDispatcher.addListener(listener);
    }

    public void removeListener(EListener<EntityEvent<MessageQueueQuery>> listener) {
        this.eventDispatcher.removeListener(listener);
    }

    public String getPDImageName() {
        return "mq_query";
    }

    public String getPDLabel() {
        return this.getQuery();
    }

    public String getPDPluginId() {
        return "com.ibm.etools.fm.ui";
    }

    @Override
    public MessageQueueManager getManager() {
        return this.getMQManager();
    }

    @Override
    public String getInitialQuery() {
        return this.getQuery();
    }
}

