/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model;

import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.MessageQueueManager;
import com.ibm.etools.fm.core.socket.func.MQL;
import com.ibm.etools.fm.core.socket.func.MQLParser;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.pdtools.common.component.core.model.PDPlatformObject;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.registery.EListener;
import com.ibm.pdtools.common.component.jhost.registery.EntityEvent;
import com.ibm.pdtools.common.component.jhost.registery.EntityEventDispatcher;
import com.ibm.pdtools.common.component.jhost.registery.IEntityEventDispatcher;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class MessageQueueManagerQuery
extends PDPlatformObject
implements IEntityEventDispatcher<MessageQueueManagerQuery> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final Object PROPERTY_LOADED_MESSAGE_QUEUES_MANAGERS = new Object();
    private IPDHost host;
    private List<MessageQueueManager> messageQueueManagers;
    private final EntityEventDispatcher<MessageQueueManagerQuery> eventDispatcher = new EntityEventDispatcher((Object)this);
    private Object remoteListener = null;

    public MessageQueueManagerQuery(IPDHost host) {
        this.host = Objects.requireNonNull(host, "Must provide a non-null host");
    }

    public MessageQueueManagerQuery clone() {
        MessageQueueManagerQuery copy = new MessageQueueManagerQuery(this.host);
        if (this.messageQueueManagers != null) {
            copy.setMessageQueueManagers(new ArrayList<MessageQueueManager>(this.messageQueueManagers));
        }
        return copy;
    }

    public boolean equals(Object obj) {
        return obj instanceof MessageQueueManagerQuery && this.host.equals(((MessageQueueManagerQuery)((Object)obj)).host);
    }

    public int hashCode() {
        return this.host.hashCode();
    }

    public String toString() {
        return this.getLabel();
    }

    public String getLabel() {
        return "MQ:*";
    }

    public IPDHost getSystem() {
        return this.host;
    }

    public List<MessageQueueManager> getMessageQueueManagers() {
        return this.messageQueueManagers;
    }

    private void setMessageQueueManagers(List<MessageQueueManager> messageQueueManagers) {
        this.messageQueueManagers = messageQueueManagers;
        this.eventDispatcher.fireChangedEvent(PROPERTY_LOADED_MESSAGE_QUEUES_MANAGERS);
    }

    public Result<List<MessageQueueManager>> loadMessageQueueManagers(IHowIsGoing monitor, boolean loadProperties) throws InterruptedException {
        MQL mql = new MQL();
        mql.setProps(loadProperties);
        Result result = UtilityFunctionRunner.executeAndParse(this.host, (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.host), mql, new MQLParser(this.getSystem()), monitor);
        this.setMessageQueueManagers((List)result.getOutput());
        return result;
    }

    public Object getLoadFinishedListener() {
        return this.remoteListener;
    }

    public void setLoadFinishedListener(Object listener) {
        this.remoteListener = listener;
    }

    public void addListener(EListener<EntityEvent<MessageQueueManagerQuery>> listener) {
        this.eventDispatcher.addListener(listener);
    }

    public void removeListener(EListener<EntityEvent<MessageQueueManagerQuery>> listener) {
        this.eventDispatcher.removeListener(listener);
    }

    public String getPDPluginId() {
        return "com.ibm.etools.fm.ui";
    }

    public String getPDImageName() {
        return "mqm_browse";
    }

    public String getPDLabel() {
        return this.getLabel();
    }
}

