/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model;

import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.IFMMQQueryInput;
import com.ibm.etools.fm.core.model.data.MessageQueueManagerProperties;
import com.ibm.etools.fm.core.socket.func.MQL;
import com.ibm.etools.fm.core.socket.func.MQLParser;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.IRefreshable;
import com.ibm.pdtools.common.component.core.model.PDPlatformObject;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.ISystemsLabelDecorator;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Pattern;

public class MessageQueueManager
extends PDPlatformObject
implements IRefreshable,
ISystemsLabelDecorator,
IFMMQQueryInput {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String MQM_PREFIX = "MQ:";
    public static final String PATTERN_FMZ_VALID_NAME = "[A-Za-z\\d\\_\\%\\/\\.]{3,4}";
    private static final Pattern validFMZName = Pattern.compile("[A-Za-z\\d\\_\\%\\/\\.]{3,4}");
    public static final String PATTERN_FMD_VALID_NAME = "[A-Za-z\\d\\_\\%\\/\\.]{1,48}";
    private static final Pattern validFMDName = Pattern.compile("[A-Za-z\\d\\_\\%\\/\\.]{1,48}");
    private final String name;
    private int connectionCode;
    private String connectionReason;
    private final Properties resourceProperties = new Properties();
    private MessageQueueManagerProperties properties;
    private boolean confirmedExists = false;
    private static final PDLogger logger = PDLogger.get(MessageQueueManager.class);

    public static boolean isValidName(IPDHost host, String name) {
        Objects.requireNonNull(name, "Please specify a non-null name.");
        String nameCheck = null;
        try {
            nameCheck = new String(name.getBytes(host.getCodePage()), host.getCommunicationCodePage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (host.getHostType() == null || host.getHostType() != HostType.ZOS) {
            return validFMDName.matcher(nameCheck).matches();
        }
        return validFMZName.matcher(nameCheck).matches();
    }

    public static MessageQueueManager create(IPDHost system, String name) {
        return new MessageQueueManager(system, name);
    }

    public static MessageQueueManager create(String name, int connectionCode, String connectionReason, IPDHost system) {
        return new MessageQueueManager(name, connectionCode, connectionReason, system);
    }

    protected MessageQueueManager(String name, int connectionCode, String connectionReason, IPDHost system) {
        Objects.requireNonNull(system, "Must provide a non-null system");
        if (!MessageQueueManager.isValidName(system, name)) {
            throw new IllegalArgumentException(name);
        }
        this.name = name.toUpperCase();
        this.connectionCode = connectionCode;
        this.connectionReason = Objects.requireNonNull(connectionReason, "Must provide a non-null connectionReason");
        this.setSystem(system);
    }

    protected MessageQueueManager(IPDHost system, String name) {
        Objects.requireNonNull(system, "Please specify a non-null system.");
        if (!MessageQueueManager.isValidName(system, name)) {
            throw new IllegalArgumentException(name);
        }
        this.name = name.toUpperCase();
        this.connectionCode = 0;
        this.connectionReason = "";
        this.setSystem(system);
    }

    public MessageQueueManager clone() {
        MessageQueueManager copy = MessageQueueManager.create(this.name, this.connectionCode, this.connectionReason, this.getSystem());
        if (this.properties != null) {
            copy.properties = this.properties;
        }
        for (Object key : this.resourceProperties.keySet()) {
            copy.setPersistentProperty(key.toString(), this.resourceProperties.get(key).toString());
        }
        return copy;
    }

    public String getName() {
        return this.name;
    }

    public int getConnectionCode() {
        return this.connectionCode;
    }

    public void setConnectionCode(int connectionCode) {
        this.connectionCode = connectionCode;
    }

    public String getConnectionReason() {
        return this.connectionReason;
    }

    public void setConnectionReason(String connectionReason) {
        this.connectionReason = connectionReason;
    }

    public boolean equals(Object obj) {
        return obj instanceof MessageQueueManager && ((MessageQueueManager)obj).name.equals(this.name) && ((MessageQueueManager)obj).getSystem().equals(this.getSystem());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.getName();
    }

    public void setProperties(MessageQueueManagerProperties properties) {
        this.properties = properties;
    }

    public MessageQueueManagerProperties getProperties() {
        return this.properties;
    }

    public String getFormattedName() {
        return MQM_PREFIX + this.getName();
    }

    public String getPersistentProperty(String key) {
        return this.resourceProperties.getProperty(key);
    }

    public void setPersistentProperty(String key, String value) {
        this.resourceProperties.setProperty(key, value);
    }

    public void setConfirmedExists(boolean confirmedExists) {
        this.confirmedExists = confirmedExists;
    }

    public boolean getConfirmedExists() {
        return this.confirmedExists;
    }

    public Result<?> refreshSelf(IHowIsGoing monitor) throws InterruptedException {
        return this.doRefresh(monitor, true);
    }

    public Result<?> refreshExistence(IHowIsGoing monitor) throws InterruptedException {
        return this.doRefresh(monitor, false);
    }

    public synchronized Result<?> doRefresh(IHowIsGoing monitor, boolean doFullRefresh) throws InterruptedException {
        MQL mql = new MQL();
        mql.setProps(doFullRefresh);
        Result result = UtilityFunctionRunner.executeAndParse(this.getSystem(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.getSystem()), mql, new MQLParser(this.getSystem()), monitor);
        List managers = (List)result.getOutput();
        MessageQueueManager updateFrom = null;
        if (managers == null) {
            logger.trace(new Object[]{"Error refreshingSelf for MQM: ", this.getFormattedName()});
        } else {
            for (MessageQueueManager mqm : managers) {
                if (this.getName().equals(mqm.getName())) continue;
                updateFrom = mqm;
            }
        }
        this.updateFrom(updateFrom);
        return result;
    }

    public void updateFrom(MessageQueueManager updateFrom) {
        if (updateFrom == null) {
            this.setConfirmedExists(false);
            this.setProperties(null);
        } else {
            this.setConfirmedExists(true);
            this.setProperties(updateFrom.getProperties());
        }
    }

    public String getPDImageName() {
        return "mqm";
    }

    public String getPDLabel() {
        return this.getName();
    }

    public String getPDPluginId() {
        return "com.ibm.etools.fm.ui";
    }

    public boolean checkDecorateImageStatic() {
        return this.getConnectionCode() > 0;
    }

    public Object getNewImage(Object anImage) {
        return anImage;
    }

    public String copyName() {
        return this.getFormattedName();
    }

    @Override
    public MessageQueueManager getManager() {
        return this;
    }

    @Override
    public String getInitialQuery() {
        return "*";
    }
}

