/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model;

import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.IFMMQQueryInput;
import com.ibm.etools.fm.core.model.MessageQueueManager;
import com.ibm.etools.fm.core.model.data.MessageQueueProperties;
import com.ibm.etools.fm.core.socket.func.MQQL;
import com.ibm.etools.fm.core.socket.func.MQQLParser;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.IRefreshable;
import com.ibm.pdtools.common.component.core.model.PDPlatformObject;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Pattern;

public class MessageQueue
extends PDPlatformObject
implements IRefreshable,
IFMMQQueryInput {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String MQ_PREFIX = ":";
    private static final String QUEUE_NAME_PATTERN = "[A-Za-z0-9_%/.]{1,48}";
    private static final Pattern QUEUE_VALID_NAME = Pattern.compile("[A-Za-z0-9_%/.]{1,48}");
    private static final Pattern PARSEABLE_REGEXP = Pattern.compile("MQ:[A-Za-z\\d\\_\\%\\/\\.]{1,48}:[A-Za-z0-9_%/.]{1,48}", 2);
    private final String name;
    private final MessageQueueManager manager;
    protected MessageQueueProperties properties;
    private boolean confirmedExists = false;
    private final Properties resourceProperties = new Properties();
    private static final PDLogger logger = PDLogger.get(MessageQueue.class);

    public static boolean isParseable(String name, String codepage) {
        Objects.requireNonNull(name, "Please specify a non-null name.");
        String nameCheck = null;
        try {
            nameCheck = new String(name.getBytes(codepage), HostType.ZOS.getCommunicationEncoding());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return PARSEABLE_REGEXP.matcher(nameCheck).matches();
    }

    public static MessageQueue parse(IPDHost system, String fullyQualifiedName) {
        if (system == null) {
            throw new IllegalArgumentException("System cannot be null");
        }
        if (!MessageQueue.isParseable(fullyQualifiedName, system.getCodePage())) {
            return null;
        }
        String str = fullyQualifiedName.substring("MQ:".length());
        String ssid = str.substring(0, str.indexOf(MQ_PREFIX));
        String queueName = str.substring(ssid.length() + 1);
        MessageQueueManager manager = MessageQueueManager.create(system, ssid);
        return MessageQueue.create(manager, queueName);
    }

    public static MessageQueue create(MessageQueueManager manager, String queueName) {
        return new MessageQueue(manager, queueName);
    }

    public static boolean isValidName(String name, String codepage) {
        Objects.requireNonNull(name, "Please specify a non-null name.");
        String nameCheck = null;
        try {
            nameCheck = new String(name.getBytes(codepage), HostType.ZOS.getCommunicationEncoding());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return QUEUE_VALID_NAME.matcher(nameCheck).matches();
    }

    public MessageQueue(MessageQueueManager manager, String name) {
        this.manager = Objects.requireNonNull(manager, "Please specify a non-null manager.");
        this.name = Objects.requireNonNull(name, "Must provide a non-null name");
    }

    public MessageQueue clone() {
        MessageQueue copy = MessageQueue.create(this.manager, this.name);
        copy.confirmedExists = this.confirmedExists;
        copy.properties = this.properties;
        for (Object key : this.resourceProperties.keySet()) {
            copy.setPersistentProperty(key.toString(), this.resourceProperties.get(key).toString());
        }
        return copy;
    }

    @Override
    public MessageQueueManager getManager() {
        return this.manager;
    }

    public String getName() {
        return this.name;
    }

    public MessageQueueProperties getProperties() {
        return this.properties;
    }

    public void setProperties(MessageQueueProperties properties) {
        this.properties = properties;
    }

    public void setConfirmedExists(boolean confirmedExists) {
        this.confirmedExists = confirmedExists;
    }

    public boolean getConfirmedExists() {
        return this.confirmedExists;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MessageQueue) {
            MessageQueue other = (MessageQueue)obj;
            return other.name.equals(this.name) && other.manager.equals(this.manager);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() * this.manager.hashCode();
    }

    public IPDHost getSystem() {
        return this.manager.getSystem();
    }

    public String toString() {
        return this.getName();
    }

    public String getFormattedName() {
        return "MQ:" + this.manager.getName() + MQ_PREFIX + this.name;
    }

    public String getPersistentProperty(String key) {
        return this.resourceProperties.getProperty(key);
    }

    public void setPersistentProperty(String key, String value) {
        this.resourceProperties.setProperty(key, value);
    }

    public Result<?> refreshSelf(IHowIsGoing monitor) throws InterruptedException {
        return this.doRefresh(monitor, true);
    }

    public Result<?> refreshExistence(IHowIsGoing monitor) throws InterruptedException {
        return this.doRefresh(monitor, false);
    }

    public synchronized Result<?> doRefresh(IHowIsGoing monitor, boolean doFullRefresh) throws InterruptedException {
        this.properties = null;
        MQQL mqql = new MQQL();
        mqql.setMqmgr(this.getManager().getName());
        mqql.setQName(this.getName());
        mqql.setProps(doFullRefresh);
        Result refreshResult = UtilityFunctionRunner.executeAndParse(this.getSystem(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.getSystem()), mqql, new MQQLParser(this.getSystem()), monitor);
        List list = (List)refreshResult.getOutput();
        MessageQueue updateFrom = null;
        if (list == null) {
            logger.error((Object)("Error refreshing self for " + this.getFormattedName()));
        } else if (list.isEmpty()) {
            logger.trace(new Object[]{"No matching queues for ", this.getFormattedName()});
        } else {
            int i = 0;
            while (i < list.size()) {
                MessageQueue messageQueue = (MessageQueue)list.get(i);
                if (messageQueue.getName().equals(this.getName())) {
                    updateFrom = messageQueue;
                    break;
                }
                ++i;
            }
        }
        this.updateFrom(updateFrom);
        return refreshResult;
    }

    public void updateFrom(MessageQueue updateFrom) {
        if (updateFrom == null) {
            this.setConfirmedExists(false);
            this.setProperties(null);
        } else {
            this.setConfirmedExists(true);
            this.setProperties(updateFrom.getProperties());
        }
    }

    public String getPDImageName() {
        return "mq";
    }

    public String getPDLabel() {
        return this.getName();
    }

    public String getPDPluginId() {
        return "com.ibm.etools.fm.ui";
    }

    public String copyName() {
        return this.getFormattedName();
    }

    @Override
    public String getInitialQuery() {
        return this.getName();
    }
}

