/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.HostVersion;
import com.ibm.etools.fm.core.model.Volume;
import com.ibm.etools.fm.core.model.data.MemberProperties;
import com.ibm.etools.fm.core.socket.func.DSFD;
import com.ibm.etools.fm.core.socket.func.DSFL;
import com.ibm.etools.fm.core.socket.func.DSFLParser;
import com.ibm.etools.fm.core.socket.func.DSFM;
import com.ibm.etools.fm.core.socket.func.DSFMParser;
import com.ibm.etools.fm.core.socket.func.DSFRM;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.etools.fm.jhost.core.version.FMFeature;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.PDPlatformObject;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.core.model.data.ImmutableProperties;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.jhost.version.PDFeature;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Pattern;

public class Member
extends PDPlatformObject
implements Comparable<Member>,
DataSetOrMember {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String MEMBER_START = "(";
    public static final String MEMBER_END = ")";
    public static final String PATTERN_VALID_NAME = "[-!#$\ufffd&_=+{}a-zA-Z0-9@]{1,8}";
    private static final Pattern validRegexp = Pattern.compile("\\A[-!#$\ufffd&_=+{}a-zA-Z0-9@]{1,8}\\Z");
    private DataSet dataSet;
    private String name;
    private boolean confirmedExists = false;
    private final Properties resourceProperties = new Properties();
    private MemberProperties properties;
    private TemplateInfo templateInfo;
    private static final PDLogger logger = PDLogger.get(Member.class);

    public static boolean isParseable(String fullName, boolean memberRequired, String codepage) {
        Objects.requireNonNull(fullName, "Please specify a non-null fullName.");
        fullName = fullName.toUpperCase();
        int openBracket = fullName.indexOf(MEMBER_START);
        String dataSetName = null;
        String memberName = null;
        if (openBracket != -1) {
            dataSetName = fullName.substring(0, openBracket);
            if (openBracket + 1 > fullName.length()) {
                return false;
            }
            int closeBracket = fullName.indexOf(MEMBER_END);
            if (closeBracket != fullName.length() - 1) {
                return false;
            }
            memberName = fullName.substring(openBracket + 1, closeBracket);
        } else {
            dataSetName = fullName;
        }
        boolean isValid = false;
        if (codepage == null) {
            return false;
        }
        isValid = DataSet.isValidName(dataSetName, codepage.toUpperCase());
        if (memberName != null) {
            return isValid && Member.isValidName(memberName.toUpperCase(), codepage);
        }
        return isValid && !memberRequired;
    }

    public static DataSetOrMember parse(IPDHost system, String path) {
        return Member.parse(null, system, path);
    }

    public static DataSetOrMember parse(IPDHost system, String dsn, String member) {
        Objects.requireNonNull(dsn, "Must specify a non-null dsn.");
        return Member.parse(null, system, dsn + MEMBER_START + member + MEMBER_END);
    }

    public static DataSetOrMember parse(Volume volume, String dsn) {
        if (volume == null) {
            throw new IllegalArgumentException("Must specify a non-null volume.");
        }
        return Member.parse(volume, volume.getSystem(), dsn);
    }

    protected static DataSetOrMember parse(Volume volume, IPDHost system, String dsn) {
        Objects.requireNonNull(dsn, "Must specify a non-null dsn.");
        if (system == null && volume == null) {
            throw new NullPointerException();
        }
        if (system != null ? !Member.isParseable(dsn, false, system.getCodePage()) : !Member.isParseable(dsn, false, HostType.ZOS.getDefaultEncoding())) {
            throw new IllegalArgumentException(dsn);
        }
        int openBracket = dsn.indexOf(MEMBER_START);
        if (openBracket != -1) {
            String newDataSetName = dsn.substring(0, openBracket);
            String newMemberName = dsn.substring(openBracket + 1, dsn.indexOf(MEMBER_END));
            DataSet dataSet = volume == null ? DataSet.create(system, newDataSetName) : DataSet.create(volume, newDataSetName);
            return Member.create(dataSet, newMemberName);
        }
        DataSet dataSet = volume == null ? DataSet.create(system, dsn) : DataSet.create(volume, dsn);
        return dataSet;
    }

    public static Member create(DataSet dataSet, String name) {
        return new Member(dataSet, name, true);
    }

    public static Member createNonStandard(DataSet dataSet, String name) {
        return new Member(dataSet, name, false);
    }

    public static boolean isValidName(String memberName, String codepage) {
        Objects.requireNonNull(memberName, "Please specify a non-null memberName.");
        if (memberName.isEmpty() || memberName.length() > 8) {
            return false;
        }
        String nameCheck = memberName;
        if (codepage != HostType.ZOS.getCommunicationEncoding()) {
            try {
                nameCheck = new String(memberName.getBytes(codepage), HostType.ZOS.getCommunicationEncoding());
            }
            catch (UnsupportedEncodingException e) {
                return false;
            }
        }
        return validRegexp.matcher(nameCheck).matches();
    }

    protected Member(DataSet dataSet, String name, boolean standardize) {
        Objects.requireNonNull(dataSet, "Please specify non-null dataset");
        Objects.requireNonNull(name, "Please specify non-null name.");
        if (standardize && !Member.isValidName(name = name.toUpperCase(), dataSet.getSystem().getCodePage())) {
            throw new IllegalArgumentException("name='" + (name == null ? "null" : name) + "'");
        }
        this.dataSet = dataSet;
        this.name = name;
    }

    public Member clone() {
        Member copy = Member.create(this.dataSet, this.name);
        copy.confirmedExists = this.confirmedExists;
        for (Object key : this.resourceProperties.keySet()) {
            copy.setPersistentProperty(key.toString(), this.resourceProperties.get(key).toString());
        }
        return copy;
    }

    public void setDataSet(DataSet dataSet) {
        this.dataSet = Objects.requireNonNull(dataSet, "Must provide a non-null dataSet");
    }

    @Override
    public DataSet asDataSet() {
        return this.dataSet;
    }

    @Override
    public Member asMember() {
        return this;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getFormattedName() {
        return this.dataSet.getName() + MEMBER_START + this.name + MEMBER_END;
    }

    public IPDHost getSystem() {
        return this.dataSet.getSystem();
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Member) {
            Member otherMember = (Member)obj;
            return otherMember.dataSet.equals(this.dataSet) && otherMember.name.equals(this.name);
        }
        return false;
    }

    @Override
    public boolean equalsWithVolumes(Object obj) {
        return obj instanceof Member && this.name.equals(((Member)obj).name) && this.dataSet.equalsWithVolumes(((Member)obj).asDataSet());
    }

    public int hashCode() {
        return this.dataSet.hashCode() * this.name.hashCode();
    }

    @Override
    public int compareTo(Member o) {
        int dataSetCompare = this.dataSet.compareTo(o.dataSet);
        if (dataSetCompare == 0) {
            return this.name.compareTo(o.name);
        }
        return dataSetCompare;
    }

    public void setConfirmedExists(boolean confirmedExists) {
        this.confirmedExists = confirmedExists;
    }

    public boolean getConfirmedExists() {
        return this.confirmedExists;
    }

    public String getPersistentProperty(String key) {
        Objects.requireNonNull(key, "Can not get value of a null key.");
        return this.resourceProperties.getProperty(key);
    }

    public void setPersistentProperty(String key, String value) {
        this.resourceProperties.setProperty(key, value);
    }

    @Override
    public boolean isValidNewName(String newName, String codepage) {
        return Member.isValidName(newName, codepage);
    }

    @Override
    public void renameTo(String newName, String codepage) {
        Objects.requireNonNull(newName, "Must provide a non-null newName");
        if (!this.isValidNewName(newName, codepage)) {
            throw new IllegalArgumentException("newName is not a valid member name '" + (String)(newName == null ? "null" : newName + "'"));
        }
        this.setName(newName);
        this.setConfirmedExists(false);
    }

    @Override
    public Result<StringBuffer> deleteOnHost(IHowIsGoing monitor) throws InterruptedException {
        DSFD dsfd = new DSFD();
        dsfd.setDsnIn(this.getFormattedName());
        Result<StringBuffer> result = UtilityFunctionRunner.execute(this.getSystem(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.getSystem()), dsfd, monitor);
        this.setConfirmedExists(!result.isSuccessfulWithoutWarnings());
        return result;
    }

    public Result<?> refreshExistence(IHowIsGoing monitor) throws InterruptedException {
        return this.refreshSelf(monitor);
    }

    public synchronized Result<?> refreshSelf(IHowIsGoing monitor) throws InterruptedException {
        DSFL dsfl = new DSFL();
        dsfl.setDSN(this.dataSet.getName());
        dsfl.setMember(this.getName());
        if (this.dataSet.getVolume() != null) {
            dsfl.setVolume(this.dataSet.getVolume().getVolserID());
        }
        Result result = UtilityFunctionRunner.executeAndParse(this.getSystem(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.getSystem()), dsfl, new DSFLParser(this.getSystem(), true), monitor);
        List dataSets = (List)result.getOutput();
        DataSet updateFromDataSet = null;
        if (dataSets == null || dataSets.isEmpty()) {
            logger.trace(new Object[]{"member's parent data set does not exist: ", dataSets});
        } else {
            if (dataSets.size() > 1) {
                logger.error(new Object[]{"multiple data sets returned for data set query for: ", this.dataSet.getName()});
                result.add(MessageFormat.format(Messages.CommMember_MULTIPLE_DATA_SETS_WITH_SAME_NAME, this.dataSet.getName()));
                return result;
            }
            updateFromDataSet = (DataSet)dataSets.get(0);
        }
        this.dataSet.updateFrom(updateFromDataSet);
        Member updateFromMember = null;
        if (updateFromDataSet != null) {
            for (Member loadedMember : updateFromDataSet.getMembers()) {
                if (!loadedMember.equals(this)) continue;
                updateFromMember = loadedMember;
            }
        }
        if (updateFromMember != null) {
            this.setProperties(updateFromMember.properties);
            this.setConfirmedExists(true);
        } else {
            this.setProperties(null);
            this.setConfirmedExists(false);
        }
        return result;
    }

    @Override
    public Result<StringBuffer> renameOnHost(String newName, IHowIsGoing monitor) throws InterruptedException {
        Objects.requireNonNull(newName, "Must provide a non-null newName.");
        Objects.requireNonNull(monitor, "Must provide a non-null monitor.");
        if (newName.isEmpty()) {
            throw new IllegalArgumentException("newName is empty.");
        }
        newName = newName.toUpperCase();
        DSFRM dsfrm = new DSFRM();
        dsfrm.setDsnIn(this.asDataSet().getName());
        dsfrm.setDsnMemIn(this.getName());
        dsfrm.setDsnMemOt(newName);
        Result<StringBuffer> result = UtilityFunctionRunner.execute(this.getSystem(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.getSystem()), dsfrm, monitor);
        if (result.isSuccessfulWithoutWarnings()) {
            this.setConfirmedExists(true);
            this.setName(newName);
        }
        return result;
    }

    public void setProperties(MemberProperties memberProperties) {
        this.properties = memberProperties;
    }

    public ImmutableProperties getProperties() {
        return this.properties;
    }

    public synchronized void setTemplateInfo(TemplateInfo templateInfo) {
        this.templateInfo = templateInfo;
    }

    public TemplateInfo getTemplateInfo() {
        return this.templateInfo;
    }

    public synchronized Result<?> loadTemplateInfo(IHowIsGoing monitor) throws InterruptedException {
        Result result;
        List members;
        if (!this.getSystem().supports((PDFeature)FMFeature.MEMBER_TEMPLATE_LIST)) {
            return new Result(4);
        }
        DSFM dsfm = new DSFM(this.dataSet.getSystem());
        List<String> dsns = Collections.singletonList(this.dataSet.getName());
        dsfm.setDsnList(dsns);
        dsfm.setMember(this.getName());
        dsfm.setTypes(Arrays.asList(TemplateInfo.DsfmTemplateType.values()));
        HostVersion.getInstance().setHost(this.dataSet.getSystem());
        int hostVersion = HostVersion.getInstance().getVersion();
        int MAX_HOST_VER = 140114;
        if (hostVersion >= MAX_HOST_VER) {
            dsfm.setXMLVER();
        }
        if ((members = (List)(result = UtilityFunctionRunner.executeAndParse(this.getSystem(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.getSystem()), dsfm, new DSFMParser(this.getSystem(), dsns), monitor)).getOutput()) == null || members.isEmpty()) {
            logger.trace(new Object[]{"No template info available for member: ", this.getFormattedName()});
            this.templateInfo = new TemplateInfo(null, false, null, null, null, null, false, false);
        } else if (members.size() > 1) {
            logger.error(new Object[]{"Multiple members returned for template info query for: ", this.dataSet.getName()});
            result.add(MessageFormat.format("Multiple members found for ", this.getFormattedName()));
            result.setRC(8);
        } else {
            this.templateInfo = ((Member)members.get(0)).getTemplateInfo();
            this.setConfirmedExists(true);
            this.dataSet.setConfirmedExists(true);
        }
        return result;
    }

    public String getPDImageName() {
        if (this.getTemplateInfo() != null && this.getTemplateInfo().getType() != null) {
            if (this.getTemplateInfo().isLocked()) {
                return "mem_template_lock";
            }
            return "member_template";
        }
        if (this.getProperties() != null && this.getProperties().getPropertyValue("AC") != null && this.getProperties().getPropertyValue("AM") != null && this.getProperties().getPropertyValue("RM") != null) {
            return "member_load_module";
        }
        return "member";
    }

    public String getPDLabel() {
        return this.getName();
    }

    public String getPDPluginId() {
        return "com.ibm.etools.fm.ui";
    }

    public String copyName() {
        return this.getFormattedName();
    }

    public static class TemplateInfo {
        private final DsfmTemplateType type;
        private final boolean isXmlTemplate;
        private final String description;
        private final String owner;
        private final String object;
        private final String ssid;
        private boolean locked;
        private boolean leadingZero;

        public TemplateInfo(DsfmTemplateType type, boolean isXmlTemplate, String description, String owner, String object, String ssid, boolean locked, boolean leadingZero) {
            this.type = type;
            this.isXmlTemplate = isXmlTemplate;
            this.description = description;
            this.owner = owner;
            this.object = object;
            this.ssid = ssid;
            this.locked = locked;
            this.leadingZero = leadingZero;
        }

        public String toString() {
            return "[TemplateInfo: " + this.type.name() + "...]";
        }

        public DsfmTemplateType getType() {
            return this.type;
        }

        public boolean isXmlTemplate() {
            return this.isXmlTemplate;
        }

        public String getDescription() {
            return this.description;
        }

        public String getDb2Owner() {
            return this.owner;
        }

        public String getDb2Object() {
            return this.object;
        }

        public String getDb2Ssid() {
            return this.ssid;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public boolean isLeadingZero() {
            return this.leadingZero;
        }

        public void setLockStatus(boolean lockValue) {
            this.locked = lockValue;
        }

        public void setLeadingZero(boolean leadingZero) {
            this.leadingZero = leadingZero;
        }

        public static enum DsfmTemplateType {
            BASE(Messages.Member_BASE_TEMP),
            IMS(Messages.Member_IMS_TEMP),
            VIEW(Messages.Member_IMS_VIEW),
            CRIT(Messages.Member_IMS_CRIT_SET),
            IMSX(Messages.Member_IMS_EXTRACT_TEMP),
            DB2(Messages.Member_DB2_TEMP),
            DYN(Messages.Member_DYN_TEMP);

            private final String localizedName;

            private DsfmTemplateType(String localizedName) {
                this.localizedName = localizedName;
            }

            public String getLocalizedName() {
                return this.localizedName;
            }
        }
    }
}

