/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model;

import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.etools.fm.core.socket.func.VER;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class HostVersion {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2021, 2022. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static HostVersion hostVersion = null;
    private IPDHost host;
    private int version = 0;

    private HostVersion() {
    }

    public static HostVersion getInstance() {
        if (hostVersion == null) {
            hostVersion = new HostVersion();
        }
        return hostVersion;
    }

    public int getVersion() {
        if (this.version != 0) {
            return this.version;
        }
        int vrm = 0;
        try {
            VER ver = new VER();
            IHowIsGoing monitor = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)new NullProgressMonitor());
            Result<StringBuffer> result = UtilityFunctionRunner.execute(this.host, (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.host), ver, monitor);
            if (result == null || result.getOutput() == null) {
                result = UtilityFunctionRunner.execute(this.host, (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.host), ver, monitor);
            }
            if (result != null && result.getOutput() != null) {
                String s = ((StringBuffer)result.getOutput()).toString();
                Pattern vrmPattern = Pattern.compile("FMNBA001.+?(\\d{1,2}).+?(\\d{1,2}).+?(\\d{1,2})");
                Matcher matcher = vrmPattern.matcher(s);
                if (matcher.find() && matcher.groupCount() > 2) {
                    vrm = Integer.parseInt(matcher.group(1)) * 10000 + Integer.parseInt(matcher.group(2)) * 100 + Integer.parseInt(matcher.group(3));
                }
            }
        }
        catch (IllegalArgumentException | InterruptedException exception) {
            // empty catch block
        }
        this.version = vrm;
        return this.version;
    }

    public HostVersion setHost(IPDHost host) {
        if (this.host != null && !this.host.getConnectionName().equals(host.getConnectionName())) {
            this.version = 0;
        }
        this.host = host;
        return this;
    }
}

