/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model;

import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.core.model.db2.Db2EditorOptions;
import com.ibm.etools.fm.core.model.db2.Db2SystemOptions;
import com.ibm.etools.fm.core.model.ims.ImsDd;
import com.ibm.etools.fm.core.model.ims.ImsSubsystem;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.etools.fm.core.socket.func.VER;
import com.ibm.etools.fm.core.socket.io.CommonConnectionFM;
import com.ibm.etools.fm.core.socket.io.ConnPoolManagerFM;
import com.ibm.etools.fm.core.socket.io.ZosConnectionFM;
import com.ibm.etools.fm.jhost.core.model.FMHostJhost;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunction;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.comms.PDContext;
import com.ibm.pdtools.common.component.jhost.core.model.IHostSystem;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.registery.EListener;
import com.ibm.pdtools.common.component.jhost.registery.EntityEvent;
import com.ibm.pdtools.common.component.jhost.registery.EntityRegistryMap;
import com.ibm.pdtools.common.component.jhost.registery.EventCollector;
import com.ibm.pdtools.common.component.jhost.registery.IEntityEventDispatcher;
import com.ibm.pdtools.common.component.jhost.socket.io.CommonConnectionJhost;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class FMHost
extends FMHostJhost {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(FMHost.class);
    protected Map<String, Db2SystemOptions> db2SystemOptionsList = new HashMap<String, Db2SystemOptions>();
    protected Map<String, Db2EditorOptions> db2EditorOptionsList = new HashMap<String, Db2EditorOptions>();
    private EntityRegistryMap<ImsSubsystem, ImsSubsystemConfig> imsSubsystemConfigs;
    private final EventCollector<EntityEvent<ImsSubsystemConfig>> imsSubsystemConfigEventCollector;
    private Map<String, Map<String, List<ImsDd>>> imsSsidToDatabaseToDataSetDds = new HashMap<String, Map<String, List<ImsDd>>>();
    private static final Class<?>[] zosTemplateTypes = new Class[]{DataSet.class, Member.class};
    private static final Class<?>[] linuxTemplateTypes = new Class[]{UssFile.class};
    private static Pattern vrmPattern = Pattern.compile("FMNBA001.+?(\\d{1,2}).+?(\\d{1,2}).+?(\\d{1,2})");

    public static Class<?>[] getPermittedTemplateResourceType(IPDHost aHost) {
        Objects.requireNonNull(aHost, "Must provide a non-null aHost.");
        if (aHost.getHostType() == HostType.ZOS) {
            return Arrays.copyOf(zosTemplateTypes, zosTemplateTypes.length);
        }
        return Arrays.copyOf(linuxTemplateTypes, linuxTemplateTypes.length);
    }

    public FMHost() {
        this.imsSubsystemConfigs = new EntityRegistryMap();
        this.imsSubsystemConfigEventCollector = new EventCollector();
        this.imsSubsystemConfigEventCollector.setCollapsingEvents(true);
        this.imsSubsystemConfigEventCollector.connectTo(this.imsSubsystemConfigs);
    }

    public void updateFrom(IHostSystem aHost) {
        super.updateFrom(aHost);
        FMHost host = (FMHost)aHost;
        HashMap<String, Db2SystemOptions> copiedDb2SystemOptionsList = new HashMap<String, Db2SystemOptions>();
        for (Map.Entry<String, Db2SystemOptions> entry : host.db2SystemOptionsList.entrySet()) {
            copiedDb2SystemOptionsList.put(entry.getKey(), entry.getValue().clone());
        }
        this.db2SystemOptionsList = copiedDb2SystemOptionsList;
        HashMap<String, Db2EditorOptions> copiedDb2EditorOptionsList = new HashMap<String, Db2EditorOptions>();
        for (Map.Entry<String, Db2EditorOptions> entry : host.db2EditorOptionsList.entrySet()) {
            copiedDb2EditorOptionsList.put(entry.getKey(), entry.getValue().clone());
        }
        this.db2EditorOptionsList = copiedDb2EditorOptionsList;
        this.imsSubsystemConfigEventCollector.disconnectFrom(this.imsSubsystemConfigs);
        this.imsSubsystemConfigs = host.imsSubsystemConfigs.clone();
        this.imsSubsystemConfigEventCollector.connectTo(this.imsSubsystemConfigs);
        this.imsSsidToDatabaseToDataSetDds = FMHost.copyOfDdSettings(host.imsSsidToDatabaseToDataSetDds);
    }

    public Collection<String> getDB2EditorOptionsSSIDs() {
        return this.db2EditorOptionsList.keySet();
    }

    public Collection<String> getDB2SystemOptionsSSIDs() {
        return this.db2SystemOptionsList.keySet();
    }

    public Db2EditorOptions getDb2EditorOptions(String ssid) {
        Db2EditorOptions opts = this.db2EditorOptionsList.get(ssid);
        if (opts == null) {
            opts = new Db2EditorOptions();
            this.db2EditorOptionsList.put(ssid, opts);
        }
        return opts;
    }

    public void putDb2EditorOptions(String ssid, Db2EditorOptions options) {
        if (ssid == null || options == null) {
            return;
        }
        this.db2EditorOptionsList.put(ssid, options);
    }

    public Db2SystemOptions getDb2SystemOptions(String ssid) {
        Db2SystemOptions opts = this.db2SystemOptionsList.get(ssid);
        if (opts == null) {
            opts = new Db2SystemOptions();
            this.db2SystemOptionsList.put(ssid, opts);
        }
        return opts;
    }

    public void putDb2SystemOptions(String ssid, Db2SystemOptions options) {
        if (ssid == null || options == null) {
            return;
        }
        this.db2SystemOptionsList.put(ssid, options);
    }

    public ImsSubsystemConfig getImsCanonicalConfig(ImsSubsystem subsystem) {
        ImsSubsystemConfig config = (ImsSubsystemConfig)this.imsSubsystemConfigs.get((Object)subsystem);
        if (config == null) {
            logger.warn((Object)("No IMS subsystem config has been saved for " + subsystem.getSubsystemID() + "; returning null config!"));
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveImsCanonicalConfig(ImsSubsystemConfig newConfig) {
        ImsSubsystem subsystem = newConfig.getSubsystem();
        Object object = this.imsSubsystemConfigs.getMonitor();
        synchronized (object) {
            this.imsSubsystemConfigEventCollector.blockEvents();
            ImsSubsystemConfig existingConfig = (ImsSubsystemConfig)this.imsSubsystemConfigs.get((Object)subsystem);
            if (!newConfig.isCustom() && existingConfig != null && existingConfig.isCustom()) {
                return;
            }
            this.imsSubsystemConfigs.put((Object)subsystem, (IEntityEventDispatcher)newConfig);
        }
        this.imsSubsystemConfigEventCollector.unblockEventsAndFireCollectedEvents();
    }

    public Collection<ImsSubsystemConfig> getImsConfigs() {
        return this.imsSubsystemConfigs.values();
    }

    public void addSubsystemConfigChangeListener(EListener<EntityEvent<ImsSubsystemConfig>> listener) {
        this.imsSubsystemConfigEventCollector.addListener(listener);
    }

    public void removeSubsystemConfigChangeListener(EListener<EntityEvent<ImsSubsystemConfig>> listener) {
        this.imsSubsystemConfigEventCollector.removeListener(listener);
    }

    public void setImsDatabaseDataSetDds(ImsSubsystem subsystem, String dbName, List<ImsDd> dds) {
        Objects.requireNonNull(subsystem, "Must provide a non-null subsystem");
        Objects.requireNonNull(dbName, "Must provide a non-null dbName");
        Objects.requireNonNull(dds, "Must provide a non-null dds");
        if (!FMHost.getSystem((IPDHost)subsystem.getSystem()).equals((Object)this)) {
            throw new IllegalArgumentException(subsystem.getSystem().toString());
        }
        ArrayList<ImsDd> copiedDds = new ArrayList<ImsDd>(dds.size());
        for (ImsDd imsDd : dds) {
            copiedDds.add(new ImsDd(imsDd));
        }
        String ssid = subsystem.getSubsystemID();
        Map<String, List<ImsDd>> ssidToDbNames = this.imsSsidToDatabaseToDataSetDds.get(ssid);
        if (ssidToDbNames == null) {
            ssidToDbNames = new HashMap<String, List<ImsDd>>();
            this.imsSsidToDatabaseToDataSetDds.put(ssid, ssidToDbNames);
        }
        ssidToDbNames.put(dbName, copiedDds);
    }

    public List<ImsDd> getImsDatabaseDataSetDds(ImsSubsystem subsystem, String dbName) {
        Objects.requireNonNull(subsystem, "Must provide a non-null subsystem");
        Objects.requireNonNull(dbName, "Must provide a non-null dbName");
        if (!FMHost.getSystem((IPDHost)subsystem.getSystem()).equals((Object)this)) {
            throw new IllegalArgumentException(subsystem.getSystem().toString());
        }
        Map<String, List<ImsDd>> ssidToDbNames = this.imsSsidToDatabaseToDataSetDds.get(subsystem.getSubsystemID());
        if (ssidToDbNames == null) {
            return null;
        }
        List<ImsDd> dds = ssidToDbNames.get(dbName);
        if (dds == null) {
            return null;
        }
        ArrayList<ImsDd> copiedDds = new ArrayList<ImsDd>();
        for (ImsDd imsDd : dds) {
            copiedDds.add(new ImsDd(imsDd));
        }
        return copiedDds;
    }

    public Map<String, Map<String, List<ImsDd>>> getImsSsidToDatabaseToDataSetDds() {
        return FMHost.copyOfDdSettings(this.imsSsidToDatabaseToDataSetDds);
    }

    private static Map<String, Map<String, List<ImsDd>>> copyOfDdSettings(Map<String, Map<String, List<ImsDd>>> src) {
        HashMap<String, Map<String, List<ImsDd>>> copy = new HashMap<String, Map<String, List<ImsDd>>>();
        for (Map.Entry<String, Map<String, List<ImsDd>>> ssidToDbMap : src.entrySet()) {
            HashMap dbMapCopy = new HashMap();
            for (Map.Entry<String, List<ImsDd>> dbNameToDds : ssidToDbMap.getValue().entrySet()) {
                ArrayList<ImsDd> ddsCopy = new ArrayList<ImsDd>();
                for (ImsDd imsDd : dbNameToDds.getValue()) {
                    ddsCopy.add(new ImsDd(imsDd));
                }
                dbMapCopy.put(dbNameToDds.getKey(), ddsCopy);
            }
            copy.put(ssidToDbMap.getKey(), dbMapCopy);
        }
        return copy;
    }

    public Result<StringBuffer> executeOnHost(IPDHost aHost, String command, IHowIsGoing monitor) throws InterruptedException {
        UtilityFunction func = new UtilityFunction(command);
        return UtilityFunctionRunner.execute(aHost, (IPDConnectEndpoint)this, func, monitor);
    }

    private Result<StringBuffer> executeOnThisHost(IPDHost aHost, String command, IProgressMonitor monitor) {
        return this.executeOnThisHost(aHost, command, PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor));
    }

    public void loadServerVersion(IPDHost aHost, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
        Throwable throwable = null;
        Object var4_4 = null;
        try {
            CommonConnectionFM connection = (CommonConnectionFM)ConnPoolManagerFM.instance().getConnection(aHost, (IPDConnectEndpoint)this, monitor);
            if (connection != null) {
                connection.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Deprecated
    public CommonConnectionJhost getNewConnection(IPDHost pdHost, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
        return this.getNewConnection(pdHost, null, monitor);
    }

    public CommonConnectionJhost getNewConnection(IPDHost pdHost, PDContext pdContext, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
        if (HostType.ZOS != pdHost.getHostType()) {
            throw new IllegalStateException(MessageFormat.format("HostType: {0} not supported by this method!", pdHost.getHostType()));
        }
        ZosConnectionFM chosenConnection = new ZosConnectionFM(pdHost, (IPDConnectEndpoint)this, pdContext, monitor);
        logger.debug((Object)("Established z/OS connection for endpoint " + String.valueOf((Object)this) + " on system " + pdHost.toString()));
        Result<StringBuffer> compileOptsUpdateResult = chosenConnection.updateCompilerOptions(monitor);
        if (!compileOptsUpdateResult.isSuccessfulWithoutWarnings()) {
            logger.debug((Object)("Failed to set compiler options for endpoint " + String.valueOf((Object)this) + " on system " + pdHost.toString()));
            chosenConnection = null;
        }
        return chosenConnection;
    }

    public static int requestFMVRM(IPDHost host) {
        int vrm = 0;
        try {
            String s;
            Matcher matcher;
            VER ver = new VER();
            IHowIsGoing monitor = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)new NullProgressMonitor());
            Result<StringBuffer> result = UtilityFunctionRunner.execute(host, (IPDConnectEndpoint)FMHost.getSystem((IPDHost)host), ver, monitor);
            if (result == null || result.getOutput() == null) {
                result = UtilityFunctionRunner.execute(host, (IPDConnectEndpoint)FMHost.getSystem((IPDHost)host), ver, monitor);
            }
            if (result != null && result.getOutput() != null && (matcher = vrmPattern.matcher(s = ((StringBuffer)result.getOutput()).toString())).find() && matcher.groupCount() > 2) {
                vrm = Integer.parseInt(matcher.group(1)) * 10000 + Integer.parseInt(matcher.group(2)) * 100 + Integer.parseInt(matcher.group(3));
            }
        }
        catch (IllegalArgumentException | InterruptedException e) {
            logger.trace((Object)("Attempt to determine FM version failed: " + e.getMessage()));
        }
        return vrm;
    }
}

