/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum DataSetType {
    UNKNOWN,
    PS(AccessMethod.QSAM),
    DA(AccessMethod.QSAM),
    HFS(AccessMethod.USS),
    PDS(AccessMethod.QSAM),
    LIBRARY(AccessMethod.QSAM),
    LDS(AccessMethod.VSAM),
    ESDS(AccessMethod.VSAM),
    ESDSIAM(AccessMethod.VSAM),
    KSDS(AccessMethod.VSAM),
    KSDSIAM(AccessMethod.VSAM),
    RRDS(AccessMethod.VSAM),
    VRRDS(AccessMethod.VSAM),
    DATA(AccessMethod.VSAM),
    INDEX(AccessMethod.VSAM),
    ALIAS(AccessMethod.VSAM),
    AIX(AccessMethod.VSAM),
    PATH(AccessMethod.VSAM),
    UCAT(AccessMethod.VSAM),
    ARCHIVED(AccessMethod.UNKNOWN),
    MIGRATED(AccessMethod.UNKNOWN),
    GDG(AccessMethod.VSAM),
    GDS(AccessMethod.QSAM);

    private final AccessMethod accessMethod;
    private static final List<DataSetType> NON_STANDARD_VALUES;
    public static final List<DataSetType> STANDARD_VALUES;

    static {
        NON_STANDARD_VALUES = Collections.unmodifiableList(Arrays.asList(UNKNOWN));
        DataSetType[] values = DataSetType.values();
        DataSetType[] standardValues = new DataSetType[values.length - NON_STANDARD_VALUES.size()];
        int j = 0;
        int i = 0;
        while (i < values.length) {
            boolean isStandard = true;
            int k = 0;
            while (k < NON_STANDARD_VALUES.size()) {
                if (NON_STANDARD_VALUES.get(k) == values[i]) {
                    isStandard = false;
                    break;
                }
                ++k;
            }
            if (isStandard) {
                standardValues[j++] = values[i];
            }
            ++i;
        }
        STANDARD_VALUES = Collections.unmodifiableList(Arrays.asList(standardValues));
    }

    private DataSetType() {
        this.accessMethod = AccessMethod.UNKNOWN;
    }

    private DataSetType(AccessMethod accessMethod) {
        this.accessMethod = accessMethod;
    }

    public AccessMethod getAccessMethod() {
        return this.accessMethod;
    }

    public static DataSetType[] getNonStandardValues() {
        return new DataSetType[]{UNKNOWN};
    }

    public static enum AccessMethod {
        UNKNOWN,
        QSAM,
        VSAM,
        USS;

    }
}

