/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.socket.func.DSFL;
import com.ibm.etools.fm.core.socket.func.DSFLParser;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.PDPlatformObject;
import com.ibm.pdtools.common.component.jhost.comms.AuthDetails;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.registery.EListener;
import com.ibm.pdtools.common.component.jhost.registery.EntityEvent;
import com.ibm.pdtools.common.component.jhost.registery.EntityEventDispatcher;
import com.ibm.pdtools.common.component.jhost.registery.IEntityEventDispatcher;
import com.ibm.pdtools.common.component.jhost.util.EncodingUtils;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

public class DataSetQuery
extends PDPlatformObject
implements IEntityEventDispatcher<DataSetQuery> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String SINGLE_CHAR_WILDCARD = "%";
    public static final String MULTI_CHAR_WILDCARD = "*";
    public static final String MULTI_QUALIFER_WILDCARD = "**";
    public static final String BROWSE_PLACEHOLDER = "CURRENT_USERNAME_QUERY";
    public static final Object PROPERTY_QUERY = new Object();
    public static final Object PROPERTY_TYPES_FILTERED = new Object();
    public static final Object PROPERTY_LOADED_DATA_SETS = new Object();
    public static final Object PROPERTY_FETCHING_PROPERTIES = new Object();
    private static final String qualifier = "[*]{0,2}[a-zA-Z#@$*%][a-zA-Z0-9#@$*%-]{0,7}[*]{0,2}";
    private static final Pattern validRegexp = Pattern.compile("[*]{0,2}[a-zA-Z#@$*%][a-zA-Z0-9#@$*%-]{0,7}[*]{0,2}(\\.[*]{0,2}[a-zA-Z#@$*%][a-zA-Z0-9#@$*%-]{0,7}[*]{0,2})*");
    private static final Pattern invalidRegexp = Pattern.compile(".*\\*\\*\\*.*");
    private static final Pattern isLongRunningRegexp = Pattern.compile("^(\\*{1,2})(\\.\\*{1,2})*$");
    private static final Pattern isNotLongRunningRegexp = Pattern.compile("^\\*\\.\\*$");
    private Pattern matchDataSetPattern = null;
    private String query;
    private ArrayList<DataSetType> typesFiltered = new ArrayList();
    private List<DataSet> dataSets = null;
    private final EntityEventDispatcher<DataSetQuery> eventDispatcher = new EntityEventDispatcher((Object)this);
    private boolean fetchingProperties = true;
    private static final PDLogger logger = PDLogger.get(DataSetQuery.class);

    public static DataSetQuery create(IPDHost system, String query) {
        return new DataSetQuery(system, query);
    }

    public static DataSetQuery createBrowseUser(IPDHost system) {
        DataSetQuery query = DataSetQuery.create(system, MULTI_CHAR_WILDCARD);
        query.query = BROWSE_PLACEHOLDER;
        return query;
    }

    public static boolean isValidQuery(String queryText, String codepage) {
        Objects.requireNonNull(queryText, "Please specify non-null queryText.");
        queryText = EncodingUtils.codepageConverter((String)queryText, (String)codepage, (String)HostType.ZOS.getCommunicationEncoding());
        if (queryText.isEmpty() || queryText.length() > 44) {
            return false;
        }
        return !invalidRegexp.matcher(queryText).matches() && validRegexp.matcher(queryText).matches();
    }

    public static Pattern convertToRegexp(String query) {
        Objects.requireNonNull(query, "Must provide a non-null query.");
        String modifiedQuery = query.replaceAll(StringUtils.escapeRegex((String)".**"), MULTI_QUALIFER_WILDCARD);
        String matchString = StringUtils.escapeRegex((String)modifiedQuery);
        matchString = matchString.replaceAll(StringUtils.escapeRegex((String)"\\*\\*"), "\u0000");
        matchString = matchString.replaceAll(StringUtils.escapeRegex((String)"\\*"), "[a-zA-Z0-9]{0,8}");
        matchString = matchString.replaceAll("\u0000", ".*");
        matchString = matchString.replaceAll(SINGLE_CHAR_WILDCARD, ".");
        return Pattern.compile(matchString, 66);
    }

    protected DataSetQuery(IPDHost system, String query) throws IllegalArgumentException {
        if (system == null) {
            throw new IllegalArgumentException("Must provide a non-null IPDHost.");
        }
        this.query = query.toUpperCase();
        this.setSystem(system);
    }

    public DataSetQuery clone() {
        DataSetQuery clone = DataSetQuery.create(this.getSystem(), this.query);
        if (this.dataSets != null) {
            clone.setDataSets(new ArrayList<DataSet>(this.dataSets));
        }
        clone.setTypesFiltered(this.typesFiltered);
        clone.setFetchingProperties(this.fetchingProperties);
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DataSetQuery) {
            DataSetQuery otherQuery = (DataSetQuery)((Object)obj);
            return this.query.equals(otherQuery.query) && this.getSystem().equals(otherQuery.getSystem()) && this.typesFiltered.equals(otherQuery.typesFiltered);
        }
        return false;
    }

    public int hashCode() {
        return this.query.hashCode() * this.getSystem().hashCode() * this.typesFiltered.hashCode();
    }

    public String[] getQualifiers() {
        return this.query.split("\\.");
    }

    public String getQuery() {
        Object resolvedQuery = this.query;
        if (((String)resolvedQuery).equals(BROWSE_PLACEHOLDER)) {
            AuthDetails details = null;
            try {
                details = this.getSystem().getLogin(false);
            }
            catch (Exception e) {
                logger.trace((Object)"Error getting login for browse data sets query in getQuery()", (Throwable)e);
                details = null;
            }
            if (details != null) {
                String username = details.getUsername();
                if (this.getSystem().getCodePage() != this.getSystem().getHostType().getCommunicationEncoding()) {
                    try {
                        username = new String(username.getBytes(this.getSystem().getHostType().getCommunicationEncoding()), this.getSystem().getCodePage());
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                resolvedQuery = username + ".**";
                logger.trace((Object)("Data set query resolved: " + this.query + " -> " + (String)resolvedQuery));
            } else {
                resolvedQuery = MULTI_CHAR_WILDCARD;
                logger.debug((Object)("Couldn't resolve data set query " + this.query + " because user has not provided username"));
            }
        }
        return resolvedQuery;
    }

    public String getRawQuery() {
        return this.query;
    }

    protected void setDataSets(List<DataSet> dataSets) {
        this.dataSets = dataSets;
        this.eventDispatcher.fireChangedEvent(PROPERTY_LOADED_DATA_SETS);
    }

    public List<DataSet> getDataSets() {
        if (this.dataSets == null) {
            return this.dataSets;
        }
        return Collections.unmodifiableList(this.dataSets);
    }

    public boolean matches(DataSet dataSet) {
        Objects.requireNonNull(dataSet, "Must provide a non-null dataSet");
        if (!this.getSystem().equals(dataSet.getSystem())) {
            return false;
        }
        if (this.matchDataSetPattern == null) {
            this.matchDataSetPattern = DataSetQuery.convertToRegexp(this.getQuery());
        }
        return this.matchDataSetPattern.matcher(dataSet.getName()).matches();
    }

    public boolean isLikelyLongRunning() {
        return !isNotLongRunningRegexp.matcher(this.query).matches() && isLongRunningRegexp.matcher(this.query).matches();
    }

    public boolean isFetchingProperties() {
        return this.fetchingProperties;
    }

    public void setFetchingProperties(boolean fetchingProperties) {
        this.fetchingProperties = fetchingProperties;
        this.eventDispatcher.fireChangedEvent(PROPERTY_FETCHING_PROPERTIES);
    }

    public String toString() {
        return this.query;
    }

    public List<DataSetType> getTypesFiltered() {
        return Collections.unmodifiableList(this.typesFiltered);
    }

    public void setTypesFiltered(Collection<DataSetType> typesFiltered) {
        Objects.requireNonNull(typesFiltered, "Must provide a non-null typesFiltered");
        this.typesFiltered.clear();
        this.typesFiltered.addAll(typesFiltered);
        this.eventDispatcher.fireChangedEvent(PROPERTY_TYPES_FILTERED);
    }

    public void setQuery(String value) {
        if (!DataSetQuery.isValidQuery(value, this.getSystem().getCodePage())) {
            throw new IllegalArgumentException(value);
        }
        this.query = value.toUpperCase();
        this.eventDispatcher.fireChangedEvent(PROPERTY_QUERY);
    }

    public Result<List<DataSet>> loadDataSets(IHowIsGoing monitor) throws InterruptedException {
        DSFL dsfl = new DSFL();
        this.getSystem().getLogin(true);
        dsfl.setDSN(this.getQuery());
        dsfl.setProps(this.isFetchingProperties());
        List<DataSetType> typesFiltered = this.getTypesFiltered();
        if (typesFiltered.size() != DataSetType.STANDARD_VALUES.size() && typesFiltered.size() != DataSetType.values().length) {
            dsfl.setIncludedTypes(typesFiltered);
        }
        Result result = UtilityFunctionRunner.executeAndParse(this.getSystem(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.getSystem()), dsfl, new DSFLParser(this.getSystem(), false), monitor);
        this.setDataSets((List)result.getOutput());
        return result;
    }

    public String getLabel() {
        String savedQuery = this.query;
        if (BROWSE_PLACEHOLDER.equals(savedQuery)) {
            return Messages.DataSetQuery_NODE_LABEL_MY_DATA_SETS;
        }
        return savedQuery;
    }

    public void addListener(EListener<EntityEvent<DataSetQuery>> listener) {
        this.eventDispatcher.addListener(listener);
    }

    public void removeListener(EListener<EntityEvent<DataSetQuery>> listener) {
        this.eventDispatcher.removeListener(listener);
    }

    public String getPDImageName() {
        return "ds_query";
    }

    public String getPDLabel() {
        return this.getLabel();
    }

    public String getPDPluginId() {
        return "com.ibm.etools.fm.ui";
    }
}

