/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model;

import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.Volume;
import com.ibm.etools.fm.core.model.data.DataSetProperties;
import com.ibm.etools.fm.core.socket.func.DSFD;
import com.ibm.etools.fm.core.socket.func.DSFL;
import com.ibm.etools.fm.core.socket.func.DSFLParser;
import com.ibm.etools.fm.core.socket.func.DSFR;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.PDPlatformObject;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Pattern;

public class DataSet
extends PDPlatformObject
implements Comparable<DataSet>,
DataSetOrMember {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String CP037_QUALIFIER = "[a-zA-Z#@$][a-zA-Z0-9#@$-]{0,7}";
    public static final String CP037_QUALIFIER_FULL = "^[a-zA-Z#@$][a-zA-Z0-9#@$-]{0,7}(\\.[a-zA-Z#@$][a-zA-Z0-9#@$-]{0,7}){0,21}$";
    public static final String GDG_QUALIFIER = "^\\+[0-9]+";
    public static final Pattern validRegexp = Pattern.compile("^[a-zA-Z#@$][a-zA-Z0-9#@$-]{0,7}(\\.[a-zA-Z#@$][a-zA-Z0-9#@$-]{0,7}){0,21}$");
    public static final Pattern validGDG = Pattern.compile("^\\+[0-9]+");
    public static final String QUALIFIER_SEP = ".";
    private String name;
    private DataSetType type = DataSetType.UNKNOWN;
    private List<Member> members = null;
    private DataSetProperties properties = null;
    private List<DataSet> associatedDataSets = null;
    private boolean confirmedExists = false;
    private final Properties resourceProperties = new Properties();
    private List<Volume> volumes = new ArrayList<Volume>();
    public static final String SYSTEM_CANNOT_BE_NULL = "System cannot be null";
    private String crossRegion = null;
    private String crossSystem = null;
    private static final PDLogger logger = PDLogger.get(DataSet.class);

    public static DataSet create(IPDHost system, String fullName) {
        return new DataSet(system, fullName);
    }

    public static DataSet create(Volume volume, String fullName) {
        ArrayList<Volume> vols = new ArrayList<Volume>();
        vols.add(volume);
        return new DataSet(vols, fullName);
    }

    public static boolean isValidName(String fullName, String codepage) throws IllegalArgumentException {
        if (fullName == null) {
            throw new IllegalArgumentException("Please provide a non-null fullName.");
        }
        if (fullName.length() < 1 || fullName.length() > 44) {
            return false;
        }
        String nameCheck = fullName;
        if (codepage != HostType.ZOS.getCommunicationEncoding()) {
            try {
                nameCheck = new String(fullName.getBytes(codepage), HostType.ZOS.getCommunicationEncoding());
            }
            catch (UnsupportedEncodingException e) {
                return false;
            }
        }
        return validRegexp.matcher(nameCheck).matches();
    }

    public static boolean isValidNameOrGDG(String fullName, String codepage) throws IllegalArgumentException {
        if (fullName == null) {
            throw new IllegalArgumentException("Please provide a non-null fullName.");
        }
        if (fullName.length() < 1 || fullName.length() > 44) {
            return false;
        }
        String nameCheck = fullName;
        int startGDG = nameCheck.indexOf("(");
        if (startGDG > 0) {
            int endGDG = nameCheck.indexOf(")");
            if (endGDG < startGDG) {
                return false;
            }
            String gdg = nameCheck.substring(startGDG + 1, endGDG);
            if (!validGDG.matcher(gdg).matches()) {
                return false;
            }
            nameCheck = nameCheck.substring(0, startGDG);
        }
        if (codepage != HostType.ZOS.getCommunicationEncoding()) {
            try {
                nameCheck = new String(nameCheck.getBytes(codepage), HostType.ZOS.getCommunicationEncoding());
            }
            catch (UnsupportedEncodingException e) {
                return false;
            }
        }
        return validRegexp.matcher(nameCheck).matches();
    }

    public static boolean isValidDataSetName(String fullName, String codepage) throws IllegalArgumentException {
        if (fullName == null) {
            throw new IllegalArgumentException("Please provide a non-null fullName.");
        }
        if (fullName.length() < 1 || fullName.length() > 44) {
            return false;
        }
        String nameCheck = fullName;
        if (codepage != HostType.ZOS.getCommunicationEncoding()) {
            try {
                nameCheck = new String(nameCheck.getBytes(codepage), HostType.ZOS.getCommunicationEncoding());
            }
            catch (UnsupportedEncodingException e) {
                return false;
            }
        }
        return validRegexp.matcher(nameCheck).matches();
    }

    protected DataSet(IPDHost system, String fullName) {
        if (system == null) {
            throw new IllegalArgumentException(SYSTEM_CANNOT_BE_NULL);
        }
        this.name = fullName.toUpperCase();
        this.setSystem(system);
    }

    protected DataSet(List<Volume> volumes, String fullName) {
        this(Objects.requireNonNull(volumes, "Must provide a non-null volumes List<String>.").get(0).getSystem(), fullName);
        this.volumes = volumes;
    }

    public DataSet clone() {
        DataSet copy = DataSet.create(this.getSystem(), this.name);
        copy.setType(this.type);
        if (this.volumes.size() > 0) {
            copy.setVolumes(this.volumes);
        }
        if (this.members != null) {
            copy.setMembers(this.members);
        }
        if (this.associatedDataSets != null) {
            copy.setAssociatedDataSets(this.associatedDataSets);
        }
        copy.setProperties(this.properties);
        copy.setConfirmedExists(this.confirmedExists);
        for (Object key : this.resourceProperties.keySet()) {
            copy.setPersistentProperty(key.toString(), this.resourceProperties.get(key).toString());
        }
        return copy;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DataSet) {
            DataSet dataSet = (DataSet)obj;
            return dataSet.getSystem().equals(this.getSystem()) && dataSet.name.equals(this.name);
        }
        return false;
    }

    @Override
    public boolean equalsWithVolumes(Object obj) {
        return this.equals(obj) && ((DataSet)obj).volumes.equals(this.volumes);
    }

    public int hashCode() {
        return this.name.hashCode() * this.getSystem().hashCode();
    }

    @Override
    public int compareTo(DataSet o) {
        int systemCompare = this.getSystem().compareTo(o.getSystem());
        if (systemCompare != 0) {
            return systemCompare;
        }
        return this.name.compareTo(o.name);
    }

    public boolean getHasMembers() {
        return this.getType() == DataSetType.PDS || this.getType() == DataSetType.LIBRARY;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public void setAssociatedDataSets(List<DataSet> associatedDataSets) {
        this.associatedDataSets = associatedDataSets == null ? null : new ArrayList<DataSet>(associatedDataSets);
    }

    public List<DataSet> getAssociatedDataSets() {
        if (this.associatedDataSets == null) {
            return null;
        }
        return Collections.unmodifiableList(this.associatedDataSets);
    }

    public String getFormattedName() {
        return this.getName();
    }

    public String[] getQualifiers() {
        return this.name.split("\\.");
    }

    public Volume getVolume() {
        if (this.volumes.isEmpty()) {
            return null;
        }
        return this.volumes.get(0);
    }

    public List<Volume> getAllVolumes() {
        return Collections.unmodifiableList(this.volumes);
    }

    public void setVolume(Volume volume) {
        this.volumes.clear();
        if (volume != null) {
            this.volumes.add(volume);
        }
    }

    public void setVolumes(List<Volume> volumes) {
        Objects.requireNonNull(volumes, "Must provide a non-null volumes");
        this.volumes = new ArrayList<Volume>(volumes);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public DataSet asDataSet() {
        return this;
    }

    @Override
    public Member asMember() {
        return null;
    }

    public void setType(DataSetType type) {
        this.type = type;
    }

    public DataSetType getType() {
        return this.type;
    }

    public void setConfirmedExists(boolean confirmedExists) {
        this.confirmedExists = confirmedExists;
    }

    public boolean getConfirmedExists() {
        return this.confirmedExists;
    }

    public void setProperties(DataSetProperties props) {
        this.properties = props;
    }

    public DataSetProperties getProperties() {
        return this.properties;
    }

    public void setMembers(List<Member> members) {
        this.members = members == null ? null : new ArrayList<Member>(members);
    }

    public List<Member> getMembers() {
        if (this.members == null) {
            return null;
        }
        return Collections.unmodifiableList(this.members);
    }

    public String getPersistentProperty(String key) {
        return this.resourceProperties.getProperty(key);
    }

    public void setPersistentProperty(String key, String value) {
        this.resourceProperties.setProperty(key, value);
    }

    @Override
    public void renameTo(String newName, String codepage) {
        Objects.requireNonNull(newName, "Must provide a non-null newName");
        if (!this.isValidNewName(newName, codepage)) {
            throw new IllegalArgumentException(newName);
        }
        this.setName(newName);
        this.setConfirmedExists(false);
    }

    @Override
    public boolean isValidNewName(String newName, String codepage) {
        if (newName.toUpperCase().equals(this.getName().toUpperCase())) {
            return false;
        }
        return DataSet.isValidName(newName, codepage);
    }

    @Override
    public Result<StringBuffer> deleteOnHost(IHowIsGoing monitor) throws InterruptedException {
        DSFD dsfd = new DSFD();
        dsfd.setDsnIn(this.getFormattedName());
        Result<StringBuffer> result = UtilityFunctionRunner.execute(this.getSystem(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.getSystem()), dsfd, monitor);
        this.setConfirmedExists(!result.isSuccessfulWithoutWarnings());
        return result;
    }

    public Result<?> refreshSelf(IHowIsGoing monitor) throws InterruptedException {
        return this.doRefresh(monitor, true);
    }

    public Result<?> refreshExistence(IHowIsGoing monitor) throws InterruptedException {
        return this.doRefresh(monitor, false);
    }

    private synchronized Result<?> doRefresh(IHowIsGoing monitor, boolean doFullRefresh) throws InterruptedException {
        DSFL dsfl = new DSFL();
        dsfl.setDSN(this.getName());
        if (this.getVolume() != null) {
            dsfl.setVolume(this.getVolume().getVolserID());
        }
        if (doFullRefresh) {
            dsfl.setMember("*");
        }
        dsfl.setProps(doFullRefresh);
        Result result = UtilityFunctionRunner.executeAndParse(this.getSystem(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.getSystem()), dsfl, new DSFLParser(this.getSystem(), true), monitor);
        List dataSets = (List)result.getOutput();
        DataSet updateFrom = null;
        if (dataSets == null) {
            logger.trace(new Object[]{"Error refreshingSelf for data set ", this.getFormattedName()});
        } else if (dataSets.isEmpty()) {
            logger.trace(new Object[]{"Data set does not exist: ", this});
        } else {
            DataSet matchingDataSet = (DataSet)dataSets.get(0);
            if (!this.getName().equals(matchingDataSet.getName())) {
                logger.error(new Object[]{this.getName(), " expected but got data set name of ", matchingDataSet.getName()});
                return result;
            }
            updateFrom = matchingDataSet;
        }
        this.updateFrom(updateFrom);
        return result;
    }

    public void updateFrom(DataSet updateFrom) {
        if (updateFrom == null) {
            this.setConfirmedExists(false);
            this.setMembers(null);
            this.setProperties(null);
            this.setAssociatedDataSets(null);
        } else {
            this.setConfirmedExists(true);
            List<Member> members = updateFrom.getMembers();
            if (members != null && members.size() > 0) {
                for (Member member : members) {
                    member.setDataSet(this);
                }
            }
            this.setMembers(members);
            this.setType(updateFrom.getType());
            this.setProperties(updateFrom.getProperties());
            ArrayList<DataSet> associatedDataSets = new ArrayList<DataSet>(updateFrom.getAssociatedDataSets());
            int i = 0;
            while (i < associatedDataSets.size()) {
                DataSet dataSet = (DataSet)associatedDataSets.get(i);
                if (dataSet == updateFrom) {
                    associatedDataSets.set(i, this);
                }
                ++i;
            }
            this.setAssociatedDataSets(associatedDataSets);
            for (DataSet dataSet : associatedDataSets) {
                if (dataSet == null) continue;
                dataSet.setAssociatedDataSets(associatedDataSets);
            }
        }
    }

    @Override
    public Result<StringBuffer> renameOnHost(String newName, IHowIsGoing monitor) throws InterruptedException {
        Objects.requireNonNull(newName, "Must provide a non-null newName");
        Objects.requireNonNull(monitor, "Must provide a non-null monitor");
        if (newName.isEmpty()) {
            throw new IllegalArgumentException(newName);
        }
        newName = newName.toUpperCase();
        DSFR dsfr = new DSFR();
        dsfr.setDsnIn(this.getFormattedName());
        dsfr.setNewDataSetName(newName);
        Result<StringBuffer> result = UtilityFunctionRunner.execute(this.getSystem(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.getSystem()), dsfr, monitor);
        if (result.isSuccessfulWithoutWarnings()) {
            this.setConfirmedExists(true);
            this.setName(newName);
        }
        return result;
    }

    public String getPDImageName() {
        return "data_set" + File.separator + this.getType().toString().toLowerCase();
    }

    public String getPDLabel() {
        return this.getName();
    }

    public String getPDPluginId() {
        return "com.ibm.etools.fm.ui";
    }

    public String copyName() {
        return this.getFormattedName();
    }

    public String getCrossRegion() {
        return this.crossRegion;
    }

    public void setCrossRegion(String string) {
        this.crossRegion = string;
    }

    public String getCrossSystem() {
        return this.crossSystem;
    }

    public void setCrossSystem(String crossSystem) {
        this.crossSystem = crossSystem;
    }
}

