/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model;

import com.ibm.etools.fm.core.model.MessageQueue;
import com.ibm.etools.fm.core.util.StringUtils;
import com.ibm.etools.fm.jhost.core.model.FMHostJhost;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.jhost.comms.PDContext;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import java.util.UUID;

public class BaseEditorOptions {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int EDIT_PROTOCOL_VERSION = 4;
    private boolean edit = false;
    private IZRL aResource = null;
    private String aVolumeSerial = null;
    private IPDHost templateSystem = null;
    private IZRL aTemplate = null;
    private BaseStartPosType startType = BaseStartPosType.NONE;
    private String aStartPosition = null;
    private boolean inplaceEdit = false;
    private boolean recordSampling = false;
    private String includePhysicalRecords = null;
    private String skipPhysicalRecords = null;
    private String recordLimit = null;
    private boolean onlySelectedRecs = false;
    private String binaryLength = null;
    private String encodingForSession = null;
    private String dbcsEncodingForSession = null;
    private String bidiFormat = null;
    private String ioExitName = null;
    private boolean mqDesciptor = false;
    private PDContext pdContext;
    private UUID uniqueKey = null;
    private boolean templateDirty = false;
    private boolean newDynamicTemplateFlag = false;
    private static final String MQ_DESCRIPTOR_KEYWORD = "INCLUDEMD";

    public BaseEditorOptions() {
        this.setPDContext(null);
    }

    public BaseEditorOptions(IZRL aResource, IZRL aTemplate, boolean isEdit) {
        this();
        this.edit = isEdit;
        this.aResource = aResource;
        this.aTemplate = aTemplate;
    }

    public BaseEditorOptions clone() {
        BaseEditorOptions newOpts = new BaseEditorOptions();
        newOpts.edit = this.edit;
        newOpts.aResource = this.aResource;
        newOpts.aVolumeSerial = this.aVolumeSerial;
        newOpts.templateSystem = this.templateSystem;
        newOpts.aTemplate = this.aTemplate;
        newOpts.startType = this.startType;
        newOpts.aStartPosition = this.aStartPosition;
        newOpts.inplaceEdit = this.inplaceEdit;
        newOpts.recordSampling = this.recordSampling;
        newOpts.includePhysicalRecords = this.includePhysicalRecords;
        newOpts.skipPhysicalRecords = this.skipPhysicalRecords;
        newOpts.recordLimit = this.recordLimit;
        newOpts.onlySelectedRecs = this.onlySelectedRecs;
        newOpts.binaryLength = this.binaryLength;
        newOpts.encodingForSession = this.encodingForSession;
        newOpts.dbcsEncodingForSession = this.dbcsEncodingForSession;
        newOpts.bidiFormat = this.bidiFormat;
        newOpts.ioExitName = this.ioExitName;
        newOpts.mqDesciptor = this.mqDesciptor;
        return newOpts;
    }

    public boolean isEditSession() {
        return this.edit;
    }

    public void setEditSession(boolean edit) {
        this.edit = edit;
    }

    public IZRL getaResource() {
        return this.aResource;
    }

    public void setaResource(IZRL aResource) {
        this.aResource = aResource;
    }

    public String getaVolumeSerial() {
        return this.aVolumeSerial;
    }

    public void setaVolumeSerial(String aVolumeSerial) {
        this.aVolumeSerial = aVolumeSerial;
    }

    public IPDHost getTemplateSystem() {
        return this.templateSystem;
    }

    public void setTemplateSystem(IPDHost templateSystem) {
        this.templateSystem = templateSystem;
    }

    public IZRL getaTemplate() {
        return this.aTemplate;
    }

    public void setaTemplate(IZRL aTemplate) {
        this.aTemplate = aTemplate;
    }

    public TemplateProcessingOptionType getTemplateProcessingType() {
        if (this.getaTemplate() == null) {
            return TemplateProcessingOptionType.NONE;
        }
        return TemplateProcessingOptionType.ABOVE;
    }

    public BaseStartPosType getStartType() {
        return this.startType;
    }

    public void setStartType(BaseStartPosType startType) {
        this.startType = startType;
    }

    public void setStartTypeToRecordNumber() {
        this.startType = BaseStartPosType.RECORD_NUMBER;
    }

    public String getaStartPosition() {
        return this.aStartPosition;
    }

    public void setaStartPosition(String aStartPosition) {
        this.aStartPosition = aStartPosition;
    }

    public boolean isInplaceEdit() {
        return this.inplaceEdit;
    }

    public void setInplaceEdit(boolean inplaceEdit) {
        this.inplaceEdit = inplaceEdit;
    }

    public boolean isRecordSampling() {
        return this.recordSampling;
    }

    public void setRecordSampling(boolean recordSampling) {
        this.recordSampling = recordSampling;
    }

    public String getIncludePhysicalRecords() {
        return this.includePhysicalRecords;
    }

    public void setIncludePhysicalRecords(String includePhysicalRecords) {
        this.includePhysicalRecords = includePhysicalRecords;
    }

    public String getSkipPhysicalRecords() {
        return this.skipPhysicalRecords;
    }

    public void setSkipPhysicalRecords(String skipPhysicalRecords) {
        this.skipPhysicalRecords = skipPhysicalRecords;
    }

    public String getRecordLimit() {
        return this.recordLimit;
    }

    public void setRecordLimit(String recordLimit) {
        this.recordLimit = recordLimit;
    }

    public boolean isOnlySelectedRecs() {
        return this.onlySelectedRecs;
    }

    public void setOnlySelectedRecs(boolean onlySelectedRecs) {
        this.onlySelectedRecs = onlySelectedRecs;
    }

    public String getBinaryLength() {
        return this.binaryLength;
    }

    public void setBinaryLength(String binaryLength) {
        this.binaryLength = binaryLength;
    }

    public String getEncodingForSession() {
        return this.encodingForSession;
    }

    public void setEncodingForSession(String encodingForSession) {
        this.encodingForSession = encodingForSession;
    }

    public String getBidiFormat() {
        return this.bidiFormat;
    }

    public void setBidiFormat(String bidiFormat) {
        this.bidiFormat = bidiFormat;
    }

    public String getDbcsEncodingForSession() {
        if (BaseTitleAreaDialog.checkIfNullOrEmpty((String)this.dbcsEncodingForSession)) {
            return "cp930";
        }
        return this.dbcsEncodingForSession;
    }

    public boolean isDbcsEncodingValueSet() {
        return !BaseTitleAreaDialog.checkIfNullOrEmpty((String)this.dbcsEncodingForSession);
    }

    public void setDbcsEncodingForSession(String dbcsEncodingForSession) {
        this.dbcsEncodingForSession = dbcsEncodingForSession;
    }

    public String getIoExitName() {
        return this.ioExitName;
    }

    public void setIoExitName(String ioExitName) {
        this.ioExitName = ioExitName == null || ioExitName.trim().isEmpty() ? null : ioExitName.trim().toUpperCase();
    }

    public void setMQDescriptor(boolean mqDesciptor) {
        this.mqDesciptor = mqDesciptor;
    }

    public boolean isMQDescriptorSelected() {
        return this.mqDesciptor;
    }

    public String toCommandString() {
        String xmlVersionTag;
        String processingOptions;
        StringBuilder sb = new StringBuilder();
        String resourceName = StringUtils.escapeResourceForHost(this.getaResource().getFormattedName(), this.aResource.getSystem().getHostType().getCommunicationEncoding());
        if (this.getaTemplate() == null) {
            sb.append((this.isEditSession() ? "DSE DSNIN=" : "DSV DSNIN=") + resourceName);
        } else {
            sb.append((this.isEditSession() ? "DSE DSNIN=" : "DSV DSNIN=") + resourceName + ",TCIN=" + this.getaTemplate().getFormattedName());
        }
        sb.append("," + this.getStartPosParameter());
        if (this.getaVolumeSerial() != null && this.getaVolumeSerial().length() > 0) {
            sb.append(",VOLSERIN=" + this.getaVolumeSerial());
        }
        if ((processingOptions = this.getProcessingOptions()) != null && processingOptions.length() > 0) {
            sb.append("," + processingOptions);
        }
        if (!(xmlVersionTag = FMHostJhost.getXmlVersionTag((IPDHost)this.aResource.getSystem())).isEmpty()) {
            sb.append("," + xmlVersionTag);
        }
        return sb.toString();
    }

    private String getStartPosParameter() {
        Object startPositionParm = "";
        startPositionParm = this.getStartType() == BaseStartPosType.KEY ? "KEY=" + this.getaStartPosition() : (this.getStartType() == BaseStartPosType.RBA ? "RBA=" + Integer.parseInt(this.getaStartPosition()) : (this.getStartType() == BaseStartPosType.RECORD_NUMBER ? "POSITION=" + Integer.parseInt(this.getaStartPosition()) : "POSITION=1"));
        return startPositionParm;
    }

    private String getProcessingOptions() {
        String editTypeParm = "EDIT=" + EditType.FULL.toString();
        if (this.isInplaceEdit()) {
            editTypeParm = "EDIT=" + EditType.INPLACE.toString();
        }
        Object recordLimitParm = "";
        if (this.getRecordLimit() != null) {
            recordLimitParm = "NLRECS=" + this.getRecordLimit();
        }
        Object recordSampleParm = "";
        if (this.isRecordSampling()) {
            Object includePhysicalRecordValue = this.getIncludePhysicalRecords();
            Object skipPhysicalRecordValue = this.getSkipPhysicalRecords();
            if (includePhysicalRecordValue != null && ((String)includePhysicalRecordValue).length() > 0) {
                includePhysicalRecordValue = "SMPLINCL=" + (String)includePhysicalRecordValue;
            }
            if (skipPhysicalRecordValue != null && ((String)skipPhysicalRecordValue).length() > 0) {
                skipPhysicalRecordValue = "SMPLSKIP=" + (String)skipPhysicalRecordValue;
            }
            recordSampleParm = (String)includePhysicalRecordValue + "," + (String)skipPhysicalRecordValue;
            editTypeParm = "EDIT=" + EditType.SAMPLE.toString();
        }
        String selectedOnlyParm = "";
        if (this.isOnlySelectedRecs() && this.getTemplateProcessingType() == TemplateProcessingOptionType.ABOVE) {
            selectedOnlyParm = "SELONLY=YES";
        }
        Object binReclParm = "";
        if (this.getBinaryLength() != null) {
            binReclParm = "BINRECIN=" + this.getBinaryLength();
        }
        Object ioExitParm = "";
        if (this.ioExitName != null) {
            ioExitParm = "USEIOXIN=YES,IOXIN=" + this.ioExitName;
        }
        String processingOptionValue = editTypeParm;
        if (!((String)recordLimitParm).isEmpty()) {
            processingOptionValue = processingOptionValue + "," + (String)recordLimitParm;
        }
        if (!((String)recordSampleParm).isEmpty()) {
            processingOptionValue = processingOptionValue + "," + (String)recordSampleParm;
        }
        if (!selectedOnlyParm.isEmpty()) {
            processingOptionValue = processingOptionValue + "," + selectedOnlyParm;
        }
        if (!((String)binReclParm).isEmpty()) {
            processingOptionValue = processingOptionValue + "," + (String)binReclParm;
        }
        if (!((String)ioExitParm).isEmpty()) {
            processingOptionValue = processingOptionValue + "," + (String)ioExitParm;
        }
        if (this.mqDesciptor && this.aResource instanceof MessageQueue) {
            processingOptionValue = processingOptionValue + ",INCLUDEMD=YES";
        }
        return processingOptionValue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.aResource == null ? 0 : this.aResource.hashCode());
        result = 31 * result + (this.aStartPosition == null ? 0 : this.aStartPosition.hashCode());
        result = 31 * result + (this.aTemplate == null ? 0 : this.aTemplate.hashCode());
        result = 31 * result + (this.aVolumeSerial == null ? 0 : this.aVolumeSerial.hashCode());
        result = 31 * result + (this.binaryLength == null ? 0 : this.binaryLength.hashCode());
        result = 31 * result + (this.edit ? 1231 : 1237);
        result = 31 * result + (this.encodingForSession == null ? 0 : this.encodingForSession.hashCode());
        result = 31 * result + (this.bidiFormat == null ? 0 : this.bidiFormat.hashCode());
        result = 31 * result + (this.dbcsEncodingForSession == null ? 0 : this.dbcsEncodingForSession.hashCode());
        result = 31 * result + (this.includePhysicalRecords == null ? 0 : this.includePhysicalRecords.hashCode());
        result = 31 * result + (this.inplaceEdit ? 1231 : 1237);
        result = 31 * result + (this.ioExitName == null ? 0 : this.ioExitName.hashCode());
        result = 31 * result + (this.mqDesciptor ? 1231 : 1237);
        result = 31 * result + (this.onlySelectedRecs ? 1231 : 1237);
        result = 31 * result + (this.recordLimit == null ? 0 : this.recordLimit.hashCode());
        result = 31 * result + (this.recordSampling ? 1231 : 1237);
        result = 31 * result + (this.skipPhysicalRecords == null ? 0 : this.skipPhysicalRecords.hashCode());
        result = 31 * result + (this.startType == null ? 0 : this.startType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BaseEditorOptions)) {
            return false;
        }
        BaseEditorOptions other = (BaseEditorOptions)obj;
        if (this.aResource == null ? other.aResource != null : !this.aResource.equals(other.aResource)) {
            return false;
        }
        if (this.aStartPosition == null ? other.aStartPosition != null : !this.aStartPosition.equals(other.aStartPosition)) {
            return false;
        }
        if (this.aTemplate == null ? other.aTemplate != null : !this.aTemplate.equals(other.aTemplate)) {
            return false;
        }
        if (this.aVolumeSerial == null ? other.aVolumeSerial != null : !this.aVolumeSerial.equals(other.aVolumeSerial)) {
            return false;
        }
        if (this.binaryLength == null ? other.binaryLength != null : !this.binaryLength.equals(other.binaryLength)) {
            return false;
        }
        if (this.edit != other.edit) {
            return false;
        }
        if (this.encodingForSession == null ? other.encodingForSession != null : !this.encodingForSession.equals(other.encodingForSession)) {
            return false;
        }
        if (this.bidiFormat == null ? other.bidiFormat != null : !this.bidiFormat.equals(other.bidiFormat)) {
            return false;
        }
        if (this.dbcsEncodingForSession == null ? other.dbcsEncodingForSession != null : !this.dbcsEncodingForSession.equals(other.dbcsEncodingForSession)) {
            return false;
        }
        if (this.includePhysicalRecords == null ? other.includePhysicalRecords != null : !this.includePhysicalRecords.equals(other.includePhysicalRecords)) {
            return false;
        }
        if (this.inplaceEdit != other.inplaceEdit) {
            return false;
        }
        if (this.ioExitName == null ? other.ioExitName != null : !this.ioExitName.equals(other.ioExitName)) {
            return false;
        }
        if (this.mqDesciptor != other.mqDesciptor) {
            return false;
        }
        if (this.onlySelectedRecs != other.onlySelectedRecs) {
            return false;
        }
        if (this.recordLimit == null ? other.recordLimit != null : !this.recordLimit.equals(other.recordLimit)) {
            return false;
        }
        if (this.recordSampling != other.recordSampling) {
            return false;
        }
        if (this.skipPhysicalRecords == null ? other.skipPhysicalRecords != null : !this.skipPhysicalRecords.equals(other.skipPhysicalRecords)) {
            return false;
        }
        return this.startType == other.startType;
    }

    private void removeStringKeyword(String keyword) {
        if (keyword == null) {
            throw new IllegalArgumentException();
        }
        if (MQ_DESCRIPTOR_KEYWORD.equals(keyword)) {
            this.setMQDescriptor(false);
        }
    }

    public boolean checkForAnddisableUnsupportedHostEditorOptions(Result<StringBuffer> result) {
        String[] msgs;
        boolean removedUnsupportedArg = false;
        String FMNBA113 = "FMNBA113 Parameter ";
        String INVALID_PARAMETER = " invalid or not applicable for this function";
        String[] stringArray = msgs = result.getMessagesCombined().toString().split("\\n");
        int n = msgs.length;
        int n2 = 0;
        while (n2 < n) {
            String message = stringArray[n2];
            if (message.startsWith("FMNBA113 Parameter ")) {
                String keyWord = message.substring("FMNBA113 Parameter ".length(), message.indexOf(" invalid or not applicable for this function"));
                this.removeStringKeyword(keyWord);
                removedUnsupportedArg = true;
            }
            ++n2;
        }
        return removedUnsupportedArg;
    }

    public PDContext getPDContext() {
        return this.pdContext;
    }

    public void setPDContext(PDContext pdContext) {
        this.pdContext = pdContext;
    }

    public UUID getRunTempKey() {
        return this.uniqueKey;
    }

    public void setRunTempKey(UUID uniqueKey) {
        this.uniqueKey = uniqueKey;
    }

    public boolean isTemplateDirty() {
        return this.templateDirty;
    }

    public void setTemplateDirty(boolean dirty) {
        this.templateDirty = dirty;
    }

    public boolean getDynamicTemplateFlag() {
        return this.newDynamicTemplateFlag;
    }

    public void setDynamicTemplateFlag(boolean flag) {
        this.newDynamicTemplateFlag = flag;
    }

    public static enum BaseStartPosType {
        NONE,
        KEY,
        RBA,
        RECORD_NUMBER;

    }

    public static enum EditType {
        FULL,
        INPLACE,
        SAMPLE,
        VIEW;

    }

    public static enum TemplateProcessingOptionType {
        ABOVE,
        NONE;

    }
}

