/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.FMSession;
import com.ibm.etools.fm.core.model.IRetrieveCcsidSession;
import com.ibm.etools.fm.core.model.SessionTemplate;
import com.ibm.pdtools.common.component.core.model.ISessionEdit;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.core.resources.IFile;

public abstract class AbstractSessionTemplate
extends FMSession
implements ISessionEdit,
IRetrieveCcsidSession {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String TEMPLATE_EXTENSION = ".fmt";

    public static AbstractSessionTemplate createTemplateEditSession(IZRL template) {
        Objects.requireNonNull(template, "Must specify a non-null template.");
        if (template.getSystem().getHostType() == HostType.ZOS) {
            return new SessionTemplate(template);
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.AbstractSessionTemplate_0, template.getSystem().getHostType().getName()));
    }

    public static AbstractSessionTemplate createTemplateEditSession(IZRL fromTemplate, IZRL toTemplate) {
        Objects.requireNonNull(fromTemplate, "Must specify a non-null fromTemplate.");
        if (fromTemplate.getSystem().getHostType() == HostType.ZOS) {
            return new SessionTemplate(fromTemplate, toTemplate);
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.AbstractSessionTemplate_0, fromTemplate.getSystem().getHostType().getName()));
    }

    protected AbstractSessionTemplate(IPDHost pdHost, IPDConnectEndpoint endpoint) {
        super(pdHost, endpoint);
    }

    public abstract Result<StringBuffer> start(IHowIsGoing var1) throws InterruptedException;

    public abstract Result<StringBuffer> start(IHowIsGoing var1, String var2) throws InterruptedException;

    public abstract Result<StringBuffer> startMappingSession(IHowIsGoing var1, boolean var2) throws InterruptedException;

    public abstract Result<StringBuffer> startNew(IHowIsGoing var1, StringBuffer var2) throws InterruptedException;

    public abstract Result<StringBuffer> updateAndStart(IHowIsGoing var1, StringBuffer var2) throws InterruptedException;

    public abstract Result<StringBuffer> getCompilerListing(IHowIsGoing var1, IFile var2) throws InterruptedException;

    public abstract IFile getFromCacheFile();

    public abstract IFile getToCacheFile();

    public abstract void deleteCache();

    public abstract StringBuffer updateTemplate(StringBuffer var1, IHowIsGoing var2, Result<StringBuffer> var3, boolean var4, boolean var5) throws InterruptedException;

    public abstract StringBuffer getCurrentTemplateContents(IHowIsGoing var1, Result<StringBuffer> var2) throws InterruptedException;

    public abstract IFile saveAs(IZRL var1, IHowIsGoing var2, Result<StringBuffer> var3) throws InterruptedException;

    public abstract IFile saveTOAs(IZRL var1, IHowIsGoing var2, Result<StringBuffer> var3) throws InterruptedException;

    public abstract void unlock();

    public abstract Result<StringBuffer> retrieveToMappingTemplate(IHowIsGoing var1) throws InterruptedException;

    public abstract StringBuffer updateTOTemplate(StringBuffer var1, IHowIsGoing var2, Result<StringBuffer> var3) throws InterruptedException;

    public abstract Result<StringBuffer> generateMapping(IHowIsGoing var1);

    public abstract StringBuffer getTOTemplate(IHowIsGoing var1, Result<StringBuffer> var2) throws InterruptedException;

    public abstract void closeConnection();

    public abstract void end(IHowIsGoing var1);

    public abstract Result<StringBuffer> save(IHowIsGoing var1) throws InterruptedException;

    public abstract Result<StringBuffer> saveTO(IHowIsGoing var1) throws InterruptedException;

    public abstract IZRL getFromTemplate();

    public abstract IZRL getToTemplate();
}

