/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model;

import com.ibm.etools.fm.core.model.BaseEditorOptions;
import com.ibm.etools.fm.core.model.FMSession;
import com.ibm.etools.fm.core.model.SessionFormatted;
import com.ibm.etools.fm.core.model.db2.Db2EditOptions;
import com.ibm.etools.fm.core.model.ims.ImsEditorOptions;
import com.ibm.etools.fm.core.model.ims.ImsSegmentsInformation;
import com.ibm.etools.fm.core.socket.io.CommonConnectionFM;
import com.ibm.etools.fm.editor.formatted.FMEditSessionProperties;
import com.ibm.etools.fm.model.formatted.RecType;
import com.ibm.pdtools.common.component.core.model.ISessionEdit;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;

public abstract class AbstractSessionFormatted
extends FMSession
implements ISessionEdit {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String EDITOR_EXTENSION = ".fme";
    public static final String IMS_EDITOR_EXTENSION = ".fme1";
    private int offset = 0;

    public void setEditorOffset(int offset) {
        this.offset = offset;
    }

    public int getEditorOffset() {
        return this.offset;
    }

    public static AbstractSessionFormatted createFormattedEditSession(BaseEditorOptions options, FMEditSessionProperties props) {
        if (options.getaResource().getSystem().getHostType() == HostType.ZOS) {
            return new SessionFormatted(options, props);
        }
        throw new IllegalStateException(MessageFormat.format("HostType: {0} not supported!", options.getaResource().getSystem().getHostType()));
    }

    public static AbstractSessionFormatted createFormattedEditSession(Db2EditOptions options, FMEditSessionProperties props) {
        if (options.getSystem().getHostType() == HostType.ZOS) {
            return new SessionFormatted(options, props);
        }
        throw new IllegalArgumentException("DB2 Connection to the specified host type is not supported: " + options.getSystem().getHostType().getName());
    }

    public static AbstractSessionFormatted createFormattedEditSession(ImsEditorOptions options, FMEditSessionProperties props) {
        if (options.getSystem().getHostType() == HostType.ZOS) {
            return new SessionFormatted(options, props);
        }
        throw new IllegalArgumentException("IMS Connection to the specified host type is not supported: " + options.getSystem().getHostType().getName());
    }

    protected AbstractSessionFormatted(IPDHost pdHost, IPDConnectEndpoint endpoint) {
        super(pdHost, endpoint);
    }

    public abstract boolean isEditingEnabled();

    public abstract Result<StringBuffer> startBase(IHowIsGoing var1, String var2) throws InterruptedException;

    public abstract Result<StringBuffer> startBase(IHowIsGoing var1, String var2, String var3) throws InterruptedException;

    public abstract Result<StringBuffer> startDB2Session(IHowIsGoing var1) throws InterruptedException;

    public abstract Result<StringBuffer> createIMSEditSession(IHowIsGoing var1) throws InterruptedException;

    public abstract Result<StringBuffer> startIMSEditSession(IHowIsGoing var1) throws InterruptedException;

    public abstract IFile getCacheFile();

    public abstract void removeCacheFile(IHowIsGoing var1);

    public abstract IFile getAssociatedTemplate(IHowIsGoing var1) throws InterruptedException;

    public abstract Result<StringBuffer> sendCommand(String var1, String var2, IHowIsGoing var3) throws InterruptedException;

    public abstract Result<StringBuffer> requestLayoutChange(int var1, IHowIsGoing var2) throws InterruptedException;

    public abstract Result<StringBuffer> setCursorPosition(IHowIsGoing var1, RecType var2, String var3) throws InterruptedException;

    public abstract Result<StringBuffer> setCursorPositionToTop(IHowIsGoing var1) throws InterruptedException;

    public abstract Result<StringBuffer> setCursorPositionToBottom(IHowIsGoing var1, int var2) throws InterruptedException;

    public abstract FMEditSessionProperties getProperties(IHowIsGoing var1);

    public abstract IFile readRecords(IHowIsGoing var1, Result<StringBuffer> var2, int var3) throws InterruptedException;

    public abstract Result<StringBuffer> readRecords(IHowIsGoing var1, StringBuilder var2, int var3) throws InterruptedException;

    public abstract boolean updateRecordsInHexInEditSession(StringBuffer var1, int var2, IHowIsGoing var3, Result<StringBuffer> var4) throws InterruptedException;

    public abstract Result<StringBuffer> prepareNewFormattedRecordsInEditSession(StringBuffer var1, int var2, IHowIsGoing var3) throws InterruptedException;

    public abstract Result<StringBuffer> checkFormattedRecordsEditSession(StringBuffer var1, int var2, IHowIsGoing var3) throws InterruptedException;

    public abstract Result<StringBuffer> saveAs(IZRL var1, IHowIsGoing var2) throws InterruptedException;

    public abstract IFile readAllBytes(IHowIsGoing var1, Result<StringBuffer> var2) throws InterruptedException;

    public abstract SessionType getSessionType();

    public abstract BaseEditorOptions getBaseEditOptions();

    public abstract Db2EditOptions getDb2EditOptions();

    public abstract ImsEditorOptions getImsEditOptions();

    public abstract void end(IHowIsGoing var1);

    public abstract void file(IHowIsGoing var1);

    public abstract Result<StringBuffer> save(IHowIsGoing var1) throws InterruptedException;

    public abstract Result<StringBuffer> getCompilerListing(IHowIsGoing var1, IFile var2) throws InterruptedException;

    public abstract Result<StringBuffer> getImsKeyPosition(IHowIsGoing var1) throws InterruptedException;

    public abstract Result<StringBuffer> setImsKeyPosition(String var1, IHowIsGoing var2) throws InterruptedException;

    public abstract ImsSegmentsInformation getImsSegInfo();

    public abstract void setImsSegInfo(ImsSegmentsInformation var1);

    public abstract CommonConnectionFM getConnection();

    public static enum SessionType {
        BASE,
        DB2,
        IMS;

    }
}

