/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.widget;

import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.LoadingNode;
import com.ibm.pdtools.common.component.ui.widget.ICachedTreeContentProvider;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class CachedPatternFilter
extends ViewerFilter {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private Map<Object, Object> cache = new HashMap<Object, Object>();
    private Map<Object, Boolean> foundAnyCache = new HashMap<Object, Boolean>();
    private boolean useCache = false;
    private boolean includeLeadingWildcard = false;
    private Pattern pattern;
    private boolean useEarlyReturnIfMatcherIsNull = true;
    private static Object[] EMPTY = new Object[0];

    public final Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        if (this.pattern == null && this.useEarlyReturnIfMatcherIsNull) {
            return elements;
        }
        if (!this.useCache) {
            return super.filter(viewer, parent, elements);
        }
        Object[] filtered = (Object[])this.cache.get(parent);
        if (filtered == null) {
            Boolean foundAny = this.foundAnyCache.get(parent);
            filtered = foundAny != null && foundAny == false ? EMPTY : super.filter(viewer, parent, elements);
            this.cache.put(parent, filtered);
        }
        return filtered;
    }

    private boolean isAnyVisible(Viewer viewer, Object parent, Object[] elements) {
        if (this.pattern == null) {
            return true;
        }
        if (!this.useCache) {
            return this.computeAnyVisible(viewer, elements);
        }
        Object[] filtered = (Object[])this.cache.get(parent);
        if (filtered != null) {
            return filtered.length > 0;
        }
        Boolean foundAny = this.foundAnyCache.get(parent);
        if (foundAny == null) {
            foundAny = this.computeAnyVisible(viewer, elements) ? Boolean.TRUE : Boolean.FALSE;
            this.foundAnyCache.put(parent, foundAny);
        }
        return foundAny;
    }

    public final boolean select(Viewer viewer, Object parentElement, Object element) {
        return this.isElementVisible(viewer, element);
    }

    public final void setIncludeLeadingWildcard(boolean includeLeadingWildcard) {
        this.includeLeadingWildcard = includeLeadingWildcard;
    }

    private boolean computeAnyVisible(Viewer viewer, Object[] elements) {
        boolean elementFound = false;
        int i = 0;
        while (i < elements.length && !elementFound) {
            Object element = elements[i];
            elementFound = this.isElementVisible(viewer, element);
            ++i;
        }
        return elementFound;
    }

    public void setPattern(String patternString) {
        if ("org.eclipse.ui.keys.optimization.true".equals(patternString)) {
            this.useEarlyReturnIfMatcherIsNull = true;
            return;
        }
        if ("org.eclipse.ui.keys.optimization.false".equals(patternString)) {
            this.useEarlyReturnIfMatcherIsNull = false;
            return;
        }
        this.clearCaches();
        if (patternString == null || ((String)patternString).equals("")) {
            this.pattern = null;
        } else {
            patternString = ((String)patternString).replaceAll("\\*\\*", "*");
            patternString = StringUtils.escapeRegex((String)patternString);
            patternString = ((String)patternString).replaceAll("\\\\\\*", ".*");
            patternString = ((String)patternString).replaceAll("\\\\\\%", ".");
            patternString = ((String)patternString).replaceAll("%", ".");
            if (this.includeLeadingWildcard) {
                patternString = ".*" + (String)patternString;
            }
            patternString = (String)patternString + ".*";
            this.pattern = Pattern.compile((String)patternString, 2);
        }
    }

    protected void clearCaches() {
        this.cache.clear();
        this.foundAnyCache.clear();
    }

    private boolean match(String string) {
        if (this.pattern == null) {
            return true;
        }
        boolean matches = this.pattern.matcher(string).matches();
        return matches;
    }

    public boolean isElementSelectable(Object element) {
        return element != null;
    }

    public boolean isElementVisible(Viewer viewer, Object element) {
        Objects.requireNonNull(viewer, "Please provide a non-null viewer.");
        ICachedTreeContentProvider cp = (ICachedTreeContentProvider)((AbstractTreeViewer)viewer).getContentProvider();
        if (this.isParentMatch(viewer, element) || this.isLeafMatch(viewer, element)) {
            return true;
        }
        Object ancestor = element;
        while ((ancestor = cp.getParent(ancestor)) != null) {
            if (!this.isLeafMatch(viewer, ancestor)) continue;
            return true;
        }
        return false;
    }

    protected boolean isParentMatch(Viewer viewer, Object element) {
        Object[] children = ((ICachedTreeContentProvider)((AbstractTreeViewer)viewer).getContentProvider()).getRealisedChildren(element);
        if (children != null && children.length > 0) {
            return this.isAnyVisible(viewer, element, children);
        }
        return false;
    }

    protected boolean isLeafMatch(Viewer viewer, Object element) {
        String labelText = ((ILabelProvider)((StructuredViewer)viewer).getLabelProvider()).getText(element);
        if (labelText == null) {
            return false;
        }
        if (element instanceof LoadingNode) {
            return true;
        }
        return this.wordMatches(labelText);
    }

    private static String[] getWords(String text2) {
        ArrayList<String> words = new ArrayList<String>();
        BreakIterator iter = BreakIterator.getWordInstance();
        iter.setText(text2);
        int i = iter.first();
        while (i != -1 && i < text2.length()) {
            int j = iter.following(i);
            if (j == -1) {
                j = text2.length();
            }
            if (Character.isLetterOrDigit(text2.charAt(i))) {
                String word = text2.substring(i, j);
                words.add(word);
            }
            i = j;
        }
        return words.toArray(new String[words.size()]);
    }

    protected boolean wordMatches(String text2) {
        if (text2 == null) {
            return false;
        }
        if (this.match(text2)) {
            return true;
        }
        String[] words = CachedPatternFilter.getWords(text2);
        int i = 0;
        while (i < words.length) {
            String word = words[i];
            if (this.match(word)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }
}

