/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.widget;

import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.LoadingNode;
import com.ibm.pdtools.common.component.ui.widget.CachedPatternFilter;
import com.ibm.pdtools.common.component.ui.widget.ICachedTreeContentProvider;
import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.WorkbenchJob;

public class CachedFilteredTree
extends Composite {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int ICON_CANCEL = 256;
    protected Text filterText;
    protected ToolBarManager filterToolBar;
    protected Control clearButtonControl;
    protected TreeViewer treeViewer;
    protected Composite filterComposite;
    private CachedPatternFilter patternFilter;
    protected String initialText = "";
    private Job refreshJob;
    protected Composite parentComposite;
    protected boolean showFilterControls;
    protected Composite treeComposite;
    private boolean useNewLook = false;
    private static final String CLEAR_ICON = "org.eclipse.ui.internal.dialogs.CLEAR_ICON";
    private static final String DISABLED_CLEAR_ICON = "org.eclipse.ui.internal.dialogs.DCLEAR_ICON";
    private static final long SOFT_MAX_EXPAND_TIME = 200L;
    private TreePath[] originalExpandedPaths;
    private static Boolean useNativeSearchField;
    private String previousFilterText;
    private boolean narrowingDown;

    static {
        ImageDescriptor descriptor = CachedFilteredTree.getSharedImageDescriptor("IMG_ETOOL_CLEAR");
        if (descriptor != null) {
            JFaceResources.getImageRegistry().put(CLEAR_ICON, descriptor);
        }
        if ((descriptor = CachedFilteredTree.getSharedImageDescriptor("IMG_ETOOL_CLEAR_DISABLED")) != null) {
            JFaceResources.getImageRegistry().put(DISABLED_CLEAR_ICON, descriptor);
        }
    }

    private static ImageDescriptor getSharedImageDescriptor(String imageFilePath) {
        Objects.requireNonNull(imageFilePath, "The imageFilePath parameter passed to getSharedImageDescriptor() cannot be null");
        if (!PlatformUI.isWorkbenchRunning()) {
            return null;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        return Objects.requireNonNull(workbench.getSharedImages().getImageDescriptor(imageFilePath), "The image descriptor " + imageFilePath + " was not found!");
    }

    @Deprecated
    public CachedFilteredTree(Composite parent, int treeStyle, CachedPatternFilter filter) {
        super(parent, 0);
        this.parentComposite = parent;
        this.init(treeStyle, filter);
    }

    public CachedFilteredTree(Composite parent, int treeStyle, CachedPatternFilter filter, boolean useNewLook) {
        super(parent, 0);
        this.parentComposite = parent;
        this.useNewLook = useNewLook;
        this.init(treeStyle, filter);
    }

    @Deprecated
    protected CachedFilteredTree(Composite parent) {
        super(parent, 0);
        this.parentComposite = parent;
    }

    protected CachedFilteredTree(Composite parent, boolean useNewLook) {
        super(parent, 0);
        this.parentComposite = parent;
        this.useNewLook = useNewLook;
    }

    protected void init(int treeStyle, CachedPatternFilter filter) {
        this.patternFilter = filter;
        this.showFilterControls = PlatformUI.getPreferenceStore().getBoolean("SHOW_FILTERED_TEXTS");
        this.createControl(this.parentComposite, treeStyle);
        this.createRefreshJob();
        this.setInitialText(Messages.CachedFilteredTree_TYPE_FILTER_TEXT);
        this.setFont(this.parentComposite.getFont());
    }

    protected void createControl(Composite parent, int treeStyle) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true));
        if (this.showFilterControls) {
            if (!this.useNewLook || CachedFilteredTree.useNativeSearchField(parent)) {
                this.filterComposite = new Composite((Composite)this, 0);
            } else {
                this.filterComposite = new Composite((Composite)this, 2048);
                this.filterComposite.setBackground(this.getDisplay().getSystemColor(25));
            }
            GridLayout filterLayout = new GridLayout(2, false);
            filterLayout.marginHeight = 0;
            filterLayout.marginWidth = 0;
            this.filterComposite.setLayout((Layout)filterLayout);
            this.filterComposite.setFont(parent.getFont());
            this.createFilterControls(this.filterComposite);
            this.filterComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        }
        this.treeComposite = new Composite((Composite)this, 0);
        GridLayout treeCompositeLayout = new GridLayout();
        treeCompositeLayout.marginHeight = 0;
        treeCompositeLayout.marginWidth = 0;
        this.treeComposite.setLayout((Layout)treeCompositeLayout);
        GridData data = new GridData(4, 4, true, true);
        this.treeComposite.setLayoutData((Object)data);
        this.createTreeControl(this.treeComposite, treeStyle);
    }

    private static boolean useNativeSearchField(Composite composite) {
        if (useNativeSearchField == null) {
            useNativeSearchField = Boolean.FALSE;
            Text testText = null;
            try {
                testText = new Text(composite, 384);
                useNativeSearchField = (testText.getStyle() & 0x100) != 0;
            }
            finally {
                if (testText != null) {
                    testText.dispose();
                }
            }
        }
        return useNativeSearchField;
    }

    protected Composite createFilterControls(Composite parent) {
        this.createFilterText(parent);
        if (this.useNewLook) {
            this.createClearTextNew(parent);
        } else {
            this.createClearTextOld(parent);
        }
        if (this.clearButtonControl != null) {
            this.clearButtonControl.setVisible(false);
        }
        if (this.filterToolBar != null) {
            this.filterToolBar.update(false);
            this.filterToolBar.getControl().setVisible(false);
        }
        return parent;
    }

    protected Control createTreeControl(Composite parent, int style) {
        this.treeViewer = this.doCreateTreeViewer(parent, style);
        GridData data = new GridData(4, 4, true, true);
        this.treeViewer.getControl().setLayoutData((Object)data);
        this.treeViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CachedFilteredTree.this.refreshJob.cancel();
            }
        });
        if (this.treeViewer instanceof NotifyingTreeViewer) {
            this.patternFilter.setUseCache(true);
        }
        this.treeViewer.addFilter((ViewerFilter)this.patternFilter);
        this.treeViewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if ((e.keyCode == 102 && (e.stateMask & 0x40000) != 0 || e.keyCode == 0x100000F) && CachedFilteredTree.this.filterText != null && !CachedFilteredTree.this.filterText.isDisposed()) {
                    CachedFilteredTree.this.filterText.setFocus();
                }
            }
        });
        return this.treeViewer.getControl();
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        return new NotifyingTreeViewer(parent, style);
    }

    private TreeItem getFirstMatchingItem(TreeItem[] items) {
        int i = 0;
        while (i < items.length) {
            if (this.patternFilter.isLeafMatch((Viewer)this.treeViewer, items[i].getData()) && this.patternFilter.isElementSelectable(items[i].getData())) {
                return items[i];
            }
            TreeItem treeItem = this.getFirstMatchingItem(items[i].getItems());
            if (treeItem != null) {
                return treeItem;
            }
            ++i;
        }
        return null;
    }

    private void createRefreshJob() {
        this.refreshJob = this.doCreateRefreshJob();
        this.refreshJob.setSystem(true);
    }

    protected WorkbenchJob doCreateRefreshJob() {
        return new WorkbenchJob(Messages.CachedFilteredTree_REFRESH_FILTER){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                boolean initial;
                if (CachedFilteredTree.this.treeViewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                String text2 = CachedFilteredTree.this.getFilterString();
                if (text2 == null) {
                    return Status.OK_STATUS;
                }
                boolean bl = initial = CachedFilteredTree.this.initialText != null && CachedFilteredTree.this.initialText.equals(text2);
                if (initial) {
                    CachedFilteredTree.this.patternFilter.setPattern(null);
                } else {
                    CachedFilteredTree.this.patternFilter.setPattern(text2);
                }
                Composite redrawFalseControl = CachedFilteredTree.this.treeComposite != null ? CachedFilteredTree.this.treeComposite : CachedFilteredTree.this.treeViewer.getControl();
                try {
                    redrawFalseControl.setRedraw(false);
                    if (!CachedFilteredTree.this.narrowingDown) {
                        TreeItem[] is = CachedFilteredTree.this.treeViewer.getTree().getItems();
                        int i = 0;
                        while (i < is.length) {
                            TreeItem item = is[i];
                            if (item.getExpanded()) {
                                CachedFilteredTree.this.treeViewer.setExpandedState(item.getData(), false);
                            }
                            ++i;
                        }
                    }
                    CachedFilteredTree.this.treeViewer.refresh(true);
                    if (text2.length() > 0 && !initial) {
                        TreeItem[] items = CachedFilteredTree.this.getViewer().getTree().getItems();
                        int treeHeight = CachedFilteredTree.this.getViewer().getTree().getBounds().height;
                        int numVisibleItems = treeHeight / CachedFilteredTree.this.getViewer().getTree().getItemHeight();
                        long stopTime = 200L + System.currentTimeMillis();
                        boolean cancel = false;
                        if (items.length > 0 && this.recursiveExpand(items, monitor, stopTime, new int[]{numVisibleItems})) {
                            cancel = true;
                        }
                        CachedFilteredTree.this.updateToolbar(true);
                        if (cancel) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                    } else {
                        CachedFilteredTree.this.updateToolbar(false);
                        if (CachedFilteredTree.this.originalExpandedPaths != null && CachedFilteredTree.this.originalExpandedPaths.length > 0) {
                            CachedFilteredTree.this.treeViewer.setExpandedTreePaths(CachedFilteredTree.this.originalExpandedPaths);
                        }
                    }
                }
                finally {
                    TreeItem[] items = CachedFilteredTree.this.getViewer().getTree().getItems();
                    if (items.length > 0 && CachedFilteredTree.this.getViewer().getTree().getSelectionCount() == 0) {
                        CachedFilteredTree.this.treeViewer.getTree().setTopItem(items[0]);
                    }
                    redrawFalseControl.setRedraw(true);
                }
                return Status.OK_STATUS;
            }

            private boolean recursiveExpand(TreeItem[] items, IProgressMonitor monitor, long cancelTime, int[] numItemsLeft) {
                boolean canceled = false;
                int i = 0;
                while (!canceled && i < items.length) {
                    boolean visible;
                    TreeItem item = items[i];
                    int n = numItemsLeft[0];
                    numItemsLeft[0] = n - 1;
                    boolean bl = visible = n >= 0;
                    if (monitor.isCanceled() || !visible && System.currentTimeMillis() > cancelTime) {
                        canceled = true;
                    } else {
                        Object itemData = item.getData();
                        if (itemData != null) {
                            if (!item.getExpanded() && ((ICachedTreeContentProvider)CachedFilteredTree.this.treeViewer.getContentProvider()).getRealisedChildren(itemData).length > 0) {
                                CachedFilteredTree.this.treeViewer.setExpandedState(itemData, true);
                            }
                            TreeItem[] children = item.getItems();
                            if (items.length > 0) {
                                canceled = this.recursiveExpand(children, monitor, cancelTime, numItemsLeft);
                            }
                        }
                    }
                    ++i;
                }
                return canceled;
            }
        };
    }

    protected void updateToolbar(boolean visible) {
        if (this.clearButtonControl != null) {
            this.clearButtonControl.setVisible(visible);
        }
        if (this.filterToolBar != null) {
            this.filterToolBar.getControl().setVisible(visible);
        }
    }

    protected void createFilterText(Composite parent) {
        this.filterText = this.doCreateFilterText(parent);
        this.filterText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String filterTextString = CachedFilteredTree.this.filterText.getText();
                e.result = filterTextString.isEmpty() || filterTextString.equals(CachedFilteredTree.this.initialText) ? CachedFilteredTree.this.initialText : MessageFormat.format(Messages.CachedFilteredTree_MATCHES, filterTextString, String.valueOf(this.getFilteredItemsCount()));
            }

            private int getFilteredItemsCount() {
                int total = 0;
                TreeItem[] items = CachedFilteredTree.this.getViewer().getTree().getItems();
                int i = 0;
                while (i < items.length) {
                    total += this.itemCount(items[i]);
                    ++i;
                }
                return total;
            }

            private int itemCount(TreeItem treeItem) {
                int count = 1;
                TreeItem[] children = treeItem.getItems();
                int i = 0;
                while (i < children.length) {
                    count += this.itemCount(children[i]);
                    ++i;
                }
                return count;
            }
        });
        this.filterText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (!CachedFilteredTree.this.useNewLook) {
                    Display display = CachedFilteredTree.this.filterText.getDisplay();
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!(this).CachedFilteredTree.this.filterText.isDisposed() && CachedFilteredTree.this.getInitialText().equals((this).CachedFilteredTree.this.filterText.getText().trim())) {
                                (this).CachedFilteredTree.this.filterText.selectAll();
                            }
                        }
                    });
                    return;
                }
            }

            public void focusLost(FocusEvent e) {
                if (!CachedFilteredTree.this.useNewLook) {
                    return;
                }
                if (CachedFilteredTree.this.filterText.getText().equals("")) {
                    CachedFilteredTree.this.setFilterText(CachedFilteredTree.this.initialText);
                    CachedFilteredTree.this.textChanged();
                }
            }
        });
        if (this.useNewLook) {
            this.filterText.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    if (CachedFilteredTree.this.filterText.getText().equals(CachedFilteredTree.this.initialText)) {
                        CachedFilteredTree.this.setFilterText("");
                        CachedFilteredTree.this.textChanged();
                    }
                }
            });
        }
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean hasItems;
                boolean bl = hasItems = CachedFilteredTree.this.getViewer().getTree().getItemCount() > 0;
                if (hasItems && e.keyCode == 0x1000002) {
                    CachedFilteredTree.this.treeViewer.getTree().setFocus();
                    return;
                }
                if (e.keyCode == 27) {
                    CachedFilteredTree.this.clearText();
                }
            }
        });
        this.filterText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    if (CachedFilteredTree.this.getViewer().getTree().getItemCount() == 0) {
                        Display.getCurrent().beep();
                    } else {
                        TreeItem item;
                        boolean textChanged;
                        boolean hasFocus = CachedFilteredTree.this.getViewer().getTree().setFocus();
                        boolean bl = textChanged = !CachedFilteredTree.this.getInitialText().equals(CachedFilteredTree.this.filterText.getText().trim());
                        if (hasFocus && textChanged && CachedFilteredTree.this.filterText.getText().trim().length() > 0 && (item = CachedFilteredTree.this.getFirstMatchingItem(CachedFilteredTree.this.getViewer().getTree().getItems())) != null) {
                            CachedFilteredTree.this.getViewer().getTree().setSelection(new TreeItem[]{item});
                            ISelection sel = CachedFilteredTree.this.getViewer().getSelection();
                            CachedFilteredTree.this.getViewer().setSelection(sel, true);
                        }
                    }
                }
            }
        });
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CachedFilteredTree.this.textChanged();
            }
        });
        if ((this.filterText.getStyle() & 0x100) != 0) {
            this.filterText.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    if (e.detail == 256) {
                        CachedFilteredTree.this.clearText();
                    }
                }
            });
        }
        GridData gridData = new GridData(4, 0x1000000, true, false);
        if ((this.filterText.getStyle() & 0x100) != 0) {
            gridData.horizontalSpan = 2;
        }
        this.filterText.setLayoutData((Object)gridData);
        this.filterText.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent arg0) {
                if (CachedFilteredTree.this.filterText != null) {
                    CachedFilteredTree.this.filterText.pack(false);
                }
            }
        });
    }

    protected Text doCreateFilterText(Composite parent) {
        if (!this.useNewLook || CachedFilteredTree.useNativeSearchField(parent)) {
            return new Text(parent, 2436);
        }
        return new Text(parent, 4);
    }

    protected void textChanged() {
        String filterString = this.getFilterString();
        boolean bl = this.narrowingDown = this.previousFilterText == null || filterString.startsWith(this.previousFilterText);
        if (this.previousFilterText != null && this.previousFilterText.isEmpty() && this.treeViewer != null) {
            this.originalExpandedPaths = this.treeViewer.getExpandedTreePaths();
        }
        this.previousFilterText = filterString;
        this.refreshJob.cancel();
        this.refreshJob.schedule(this.getRefreshJobDelay());
    }

    protected long getRefreshJobDelay() {
        return 1000L;
    }

    public void setBackground(Color background) {
        super.setBackground(background);
        if (this.filterComposite != null && (!this.useNewLook || CachedFilteredTree.useNativeSearchField(this.filterComposite))) {
            this.filterComposite.setBackground(background);
        }
        if (this.filterToolBar != null && this.filterToolBar.getControl() != null) {
            this.filterToolBar.getControl().setBackground(background);
        }
    }

    private void createClearTextOld(Composite parent) {
        if ((this.filterText.getStyle() & 0x100) == 0) {
            this.filterToolBar = new ToolBarManager(0x800100);
            this.filterToolBar.createControl(parent);
            Action clearTextAction = new Action("", 1){

                public void run() {
                    CachedFilteredTree.this.clearText();
                }
            };
            clearTextAction.setToolTipText(Messages.__CLEAR);
            clearTextAction.setImageDescriptor(JFaceResources.getImageRegistry().getDescriptor(CLEAR_ICON));
            clearTextAction.setDisabledImageDescriptor(JFaceResources.getImageRegistry().getDescriptor(DISABLED_CLEAR_ICON));
            this.filterToolBar.add((IAction)clearTextAction);
        }
    }

    private void createClearTextNew(Composite parent) {
        if ((this.filterText.getStyle() & 0x100) == 0) {
            final Image inactiveImage = JFaceResources.getImageRegistry().getDescriptor(DISABLED_CLEAR_ICON).createImage();
            final Image activeImage = JFaceResources.getImageRegistry().getDescriptor(CLEAR_ICON).createImage();
            final Image pressedImage = new Image((Device)this.getDisplay(), activeImage, 2);
            final Label clearButton = new Label(parent, 0);
            clearButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            clearButton.setImage(inactiveImage);
            clearButton.setBackground(parent.getDisplay().getSystemColor(25));
            clearButton.setToolTipText(Messages.__CLEAR);
            clearButton.addMouseListener((MouseListener)new MouseAdapter(){
                private MouseMoveListener fMoveListener;

                public void mouseDown(MouseEvent e) {
                    clearButton.setImage(pressedImage);
                    this.fMoveListener = new MouseMoveListener(){
                        private boolean fMouseInButton = true;

                        public void mouseMove(MouseEvent moveEvent) {
                            boolean mouseInButton = this.isMouseInButton(moveEvent);
                            if (mouseInButton != this.fMouseInButton) {
                                this.fMouseInButton = mouseInButton;
                                clearButton.setImage(mouseInButton ? pressedImage : inactiveImage);
                            }
                        }
                    };
                    clearButton.addMouseMoveListener(this.fMoveListener);
                }

                public void mouseUp(MouseEvent e) {
                    if (this.fMoveListener != null) {
                        clearButton.removeMouseMoveListener(this.fMoveListener);
                        this.fMoveListener = null;
                        boolean mouseInButton = this.isMouseInButton(e);
                        clearButton.setImage(mouseInButton ? activeImage : inactiveImage);
                        if (mouseInButton) {
                            CachedFilteredTree.this.clearText();
                            CachedFilteredTree.this.filterText.setFocus();
                        }
                    }
                }

                private boolean isMouseInButton(MouseEvent e) {
                    Point buttonSize = clearButton.getSize();
                    return e.x >= 0 && e.x < buttonSize.x && e.y >= 0 && e.y < buttonSize.y;
                }
            });
            clearButton.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseEnter(MouseEvent e) {
                    clearButton.setImage(activeImage);
                }

                public void mouseExit(MouseEvent e) {
                    clearButton.setImage(inactiveImage);
                }
            });
            clearButton.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    inactiveImage.dispose();
                    activeImage.dispose();
                    pressedImage.dispose();
                }
            });
            clearButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = Messages.CachedFilteredTree_CLEAR_FILTER_FIELD;
                }
            });
            clearButton.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

                public void getRole(AccessibleControlEvent e) {
                    e.detail = 43;
                }
            });
            this.clearButtonControl = clearButton;
        }
    }

    protected void clearText() {
        this.setFilterText("");
    }

    protected void setFilterText(String string) {
        if (this.filterText != null) {
            this.filterText.setText(string);
            if (string.equals(this.initialText)) {
                this.filterText.setForeground(this.filterText.getDisplay().getSystemColor(15));
            } else {
                this.filterText.setForeground(this.filterText.getDisplay().getSystemColor(2));
            }
            this.selectAll();
        }
    }

    public final CachedPatternFilter getPatternFilter() {
        return this.patternFilter;
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    public Text getFilterControl() {
        return this.filterText;
    }

    protected String getFilterString() {
        return this.filterText != null ? (this.filterText.isDisposed() ? null : this.filterText.getText()) : null;
    }

    public void setInitialText(String text2) {
        this.initialText = text2;
        if (this.useNewLook && this.filterText != null) {
            this.filterText.setMessage(text2);
            if (this.filterText.isFocusControl()) {
                this.setFilterText(this.initialText);
                this.textChanged();
            } else {
                this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!CachedFilteredTree.this.filterText.isDisposed() && !CachedFilteredTree.this.filterText.isFocusControl()) {
                            CachedFilteredTree.this.setFilterText(CachedFilteredTree.this.initialText);
                            CachedFilteredTree.this.textChanged();
                        } else {
                            CachedFilteredTree.this.textChanged();
                        }
                    }
                });
            }
        } else {
            this.setFilterText(this.initialText);
            this.textChanged();
        }
    }

    protected void selectAll() {
        if (this.filterText != null) {
            this.filterText.selectAll();
        }
    }

    protected String getInitialText() {
        return this.initialText;
    }

    public static Font getBoldFont(Object element, CachedFilteredTree tree, CachedPatternFilter filter) {
        String filterText = tree.getFilterString();
        if (filterText == null) {
            return null;
        }
        String initialText = tree.getInitialText();
        if (!filterText.equals("") && !filterText.equals(initialText)) {
            if (tree.getPatternFilter() != filter) {
                boolean initial;
                boolean bl = initial = initialText != null && initialText.equals(filterText);
                if (initial) {
                    filter.setPattern(null);
                } else {
                    filter.setPattern(filterText);
                }
            }
            if (element instanceof LoadingNode) {
                return null;
            }
            if (filter.isLeafMatch((Viewer)tree.getViewer(), element)) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
            }
        }
        return null;
    }

    public boolean isMatchingLeafElement(Object element) {
        String filterString = this.getFilterString();
        if (filterString == null) {
            return false;
        }
        return !filterString.isEmpty() && !filterString.equals(this.getInitialText()) && this.getPatternFilter().isElementVisible((Viewer)this.getViewer(), element) && this.getPatternFilter().isLeafMatch((Viewer)this.getViewer(), element);
    }

    class NotifyingTreeViewer
    extends TreeViewer {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        public NotifyingTreeViewer(Composite parent, int style) {
            super(parent, style);
        }

        public void add(Object parentElementOrTreePath, Object childElement) {
            CachedFilteredTree.this.getPatternFilter().clearCaches();
            super.add(parentElementOrTreePath, childElement);
        }

        public void add(Object parentElementOrTreePath, Object[] childElements) {
            CachedFilteredTree.this.getPatternFilter().clearCaches();
            super.add(parentElementOrTreePath, childElements);
        }

        protected void inputChanged(Object input, Object oldInput) {
            CachedFilteredTree.this.getPatternFilter().clearCaches();
            super.inputChanged(input, oldInput);
        }

        public void insert(Object parentElementOrTreePath, Object element, int position) {
            CachedFilteredTree.this.getPatternFilter().clearCaches();
            super.insert(parentElementOrTreePath, element, position);
        }

        public void refresh() {
            CachedFilteredTree.this.getPatternFilter().clearCaches();
            if (!CachedFilteredTree.this.isDisposed()) {
                super.refresh();
            }
        }

        public void refresh(boolean updateLabels) {
            CachedFilteredTree.this.getPatternFilter().clearCaches();
            if (!CachedFilteredTree.this.isDisposed()) {
                super.refresh(updateLabels);
            }
        }

        public void refresh(Object element) {
            CachedFilteredTree.this.getPatternFilter().clearCaches();
            if (!CachedFilteredTree.this.isDisposed() && !this.isBusy()) {
                super.refresh(element);
            }
        }

        public void refresh(Object element, boolean updateLabels) {
            CachedFilteredTree.this.getPatternFilter().clearCaches();
            if (!CachedFilteredTree.this.isDisposed()) {
                super.refresh(element, updateLabels);
            }
        }

        public void remove(Object elementsOrTreePaths) {
            CachedFilteredTree.this.getPatternFilter().clearCaches();
            if (!CachedFilteredTree.this.isDisposed()) {
                super.remove(elementsOrTreePaths);
            }
        }

        public void remove(Object parent, Object[] elements) {
            CachedFilteredTree.this.getPatternFilter().clearCaches();
            super.remove(parent, elements);
        }

        public void remove(Object[] elementsOrTreePaths) {
            CachedFilteredTree.this.getPatternFilter().clearCaches();
            super.remove(elementsOrTreePaths);
        }

        public void replace(Object parentElementOrTreePath, int index, Object element) {
            CachedFilteredTree.this.getPatternFilter().clearCaches();
            super.replace(parentElementOrTreePath, index, element);
        }

        public void setChildCount(Object elementOrTreePath, int count) {
            CachedFilteredTree.this.getPatternFilter().clearCaches();
            super.setChildCount(elementOrTreePath, count);
        }

        public void setContentProvider(IContentProvider provider) {
            CachedFilteredTree.this.getPatternFilter().clearCaches();
            super.setContentProvider(provider);
        }

        public void setHasChildren(Object elementOrTreePath, boolean hasChildren) {
            CachedFilteredTree.this.getPatternFilter().clearCaches();
            super.setHasChildren(elementOrTreePath, hasChildren);
        }
    }
}

