/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.views.systems.properties;

import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.comms.AuthDetails;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class PDHostPropertySource
implements IPropertySource2 {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(PDHostPropertySource.class);
    private static final Object KEY_DESCRIPTION = new Object();
    private static final Object KEY_USER_NAME = new Object();
    private static final Object KEY_HOST_IP = new Object();
    private static final Object KEY_HOST_PORT = new Object();
    private static final Object KEY_HOST_DEFAULT_ENCODING = new Object();
    private static final Object KEY_HOST_BIDI_FORMAT = new Object();
    private static final Object KEY_HOST_TYPE = new Object();
    private static final IPropertyDescriptor[] MAIN_DESCRIPTORS = new IPropertyDescriptor[]{new PropertyDescriptor(KEY_DESCRIPTION, Messages.HostNode_DESCRIPTION), new PropertyDescriptor(KEY_USER_NAME, Messages.HostNode_USER_NAME), new PropertyDescriptor(KEY_HOST_IP, Messages.HostNode_HOST_NAME), new PropertyDescriptor(KEY_HOST_PORT, Messages.HostNode_HOST_PORT), new PropertyDescriptor(KEY_HOST_DEFAULT_ENCODING, Messages.HostNode_HOST_ENCODING), new PropertyDescriptor(KEY_HOST_BIDI_FORMAT, Messages.HostNode_BIDI_FORMAT), new PropertyDescriptor(KEY_HOST_TYPE, Messages.HostNode_HOST_TYPE)};
    private static final IPropertyDescriptor[] OPTIONAL_DESCRIPTORS = new IPropertyDescriptor[]{new PropertyDescriptor((Object)"SSL", Messages.HostNode_SECURED), new PropertyDescriptor((Object)"ATTLS", Messages.HostNode_ATTLS), new PropertyDescriptor((Object)"PROTOCOL", Messages.HostNode_PROTOCOL), new PropertyDescriptor((Object)"SERVERNAME", Messages.HostNode_SERVERNAME), new PropertyDescriptor((Object)"NODENAME", Messages.HostNode_NODENAME)};
    private IPDHost host;

    public PDHostPropertySource(IPDHost host) {
        this.host = host;
    }

    public Object getEditableValue() {
        return this.host.getDescription();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<IPropertyDescriptor> props = new ArrayList<IPropertyDescriptor>(Arrays.asList(MAIN_DESCRIPTORS));
        if (this.host.getIPVServerProperties().size() > 0) {
            props.addAll(Arrays.asList(OPTIONAL_DESCRIPTORS));
        }
        return props.toArray(new IPropertyDescriptor[0]);
    }

    public Object getPropertyValue(Object id) {
        if (KEY_DESCRIPTION.equals(id)) {
            return this.host.getDescription();
        }
        if (KEY_USER_NAME.equals(id)) {
            try {
                AuthDetails login = this.host.getLogin(false);
                return login == null ? null : login.getUsername();
            }
            catch (Exception e) {
                logger.trace((Object)"No login found for displaying in the Properties view.");
            }
        } else {
            if ("SSL".equals(id)) {
                String object = (String)this.host.getIPVServerProperties().get("SSL");
                if (object == null) {
                    return null;
                }
                if ("Y".equals(object)) {
                    return Messages.__TRUE;
                }
                return Messages.__FALSE;
            }
            if ("PROTOCOL".equals(id)) {
                return this.host.getIPVServerProperties().get("PROTOCOL");
            }
            if ("ATTLS".equals(id)) {
                String value = (String)this.host.getIPVServerProperties().get("ATTLS");
                if (value == null) {
                    return null;
                }
                return value;
            }
            if (KEY_HOST_IP.equals(id)) {
                return this.host.getHostName();
            }
            if (KEY_HOST_PORT.equals(id)) {
                return "" + this.host.getPort();
            }
            if ("SERVERNAME".equals(id)) {
                return this.host.getIPVServerProperties().get("SERVERNAME");
            }
            if ("NODENAME".equals(id)) {
                return this.host.getIPVServerProperties().get("NODENAME");
            }
            if (KEY_HOST_DEFAULT_ENCODING.equals(id)) {
                return this.host.getCodePage();
            }
            if (KEY_HOST_TYPE.equals(id)) {
                return this.host.getHostType().getName();
            }
            if (KEY_HOST_DEFAULT_ENCODING.equals(id)) {
                return this.host.getCodePage();
            }
            if (KEY_HOST_BIDI_FORMAT.equals(id)) {
                return this.host.getBidiFormat();
            }
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        if (KEY_DESCRIPTION.equals(id)) {
            return !"".equals(this.host.getDescription());
        }
        if ("ATTLS".equals(id)) {
            return this.host.getIPVServerProperties().get("ATTLS") != null;
        }
        if ("SSL".equals(id)) {
            return this.host.getIPVServerProperties().get("SSL") != null;
        }
        if ("PROTOCOL".equals(id)) {
            return this.host.getIPVServerProperties().get("PROTOCOL") != null;
        }
        if ("SERVERNAME".equals(id)) {
            return this.host.getIPVServerProperties().get("SERVERNAME") != null;
        }
        if ("NODENAME".equals(id)) {
            return this.host.getIPVServerProperties().get("NODENAME") != null;
        }
        if (KEY_HOST_IP.equals(id)) {
            return true;
        }
        if (KEY_HOST_PORT.equals(id)) {
            return true;
        }
        if (KEY_HOST_DEFAULT_ENCODING.equals(id)) {
            return true;
        }
        if (KEY_HOST_TYPE.equals(id)) {
            return true;
        }
        return KEY_HOST_BIDI_FORMAT.equals(id);
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public boolean isPropertyResettable(Object id) {
        return false;
    }
}

