/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.views.systems.nodes;

import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.core.model.ISystemsErrorFinder;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.logging.ThrowableRenderer;
import com.ibm.pdtools.common.component.ui.views.systems.IHasLabelAndImage;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsDataNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.io.PrintWriter;
import java.io.StringWriter;

public class LoadErrorNode<E extends IHostProvider>
extends SystemsDataNode<Exception>
implements IHasLabelAndImage,
ISystemsErrorFinder {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final Runnable onRetry;

    public LoadErrorNode(Exception error, Runnable onRetry, SystemsTreeNode parent) {
        super(error, parent);
        this.onRetry = onRetry;
    }

    @Override
    public void refreshSelf() {
        this.onRetry.run();
    }

    @Override
    public String toString() {
        return this.getPDLabel();
    }

    public String getPDLabel() {
        if (this.getDataObject() instanceof InterruptedException) {
            return Messages.LoadErrorNode_NODE_LABEL_CANCELLED;
        }
        return ThrowableRenderer.renderLocalizedOneLiner((Throwable)((Throwable)this.getDataObject()));
    }

    public String getPDImageName() {
        return "error";
    }

    public String getPDPluginId() {
        return "com.ibm.pdtools.common.component.ui";
    }

    public String getErrorText() {
        Exception error = (Exception)this.getDataObject();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ThrowableRenderer.doRender((PrintWriter)pw, (Throwable)error);
        return sw.getBuffer().toString();
    }
}

