/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.views.systems.nodes;

import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.core.comms.ConnectionUtilities;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.views.systems.IHostLeave;
import com.ibm.pdtools.common.component.ui.views.systems.IPDPersistableNode;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsView;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.RootNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsDataNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import com.ibm.pdtools.common.component.ui.views.systems.properties.PDHostPropertySource;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class HostNode
extends SystemsDataNode<IPDHost>
implements IPDPersistableNode {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final IConfigurationElement[] hostLeaves = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.pdtools.common.component.ui.views.systems.nodes.leave");

    protected HostNode(IPDHost system, RootNode parent) {
        super(system, parent);
    }

    @Override
    public List<? extends SystemsTreeNode> getKnownChildren() {
        ArrayList<SystemsTreeNode> nodes = new ArrayList<SystemsTreeNode>();
        IConfigurationElement[] iConfigurationElementArray = hostLeaves;
        int n = hostLeaves.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement hostLeave = iConfigurationElementArray[n2];
            try {
                Object hostLeaveObj = hostLeave.createExecutableExtension("subsystem");
                if (hostLeaveObj instanceof IHostLeave && ((IHostLeave)hostLeaveObj).isSupported((IPDHost)this.getDataObject(), this)) {
                    nodes.add((SystemsTreeNode)hostLeaveObj);
                }
            }
            catch (Exception e) {
                PDLogger.get(this.getClass()).error((Throwable)e);
            }
            ++n2;
        }
        return nodes;
    }

    public void expandSelf() {
        for (PDSystemsView instance : PDSystemsView.getInstances()) {
            instance.getTreeViewer().expandToLevel((Object)this, 1);
        }
    }

    public void collapseSelf() {
        for (PDSystemsView instance : PDSystemsView.getInstances()) {
            instance.getTreeViewer().collapseToLevel((Object)this, -1);
        }
    }

    @Override
    public void removeNode() {
        String hostID = ((IPDHost)this.getDataObject()).getHostID();
        if (ConnectionUtilities.canDelete((String)hostID)) {
            if (((IPDHost)this.getDataObject()).confirmRemoveHost()) {
                if (((IPDHost)this.getDataObject()).removeHost()) {
                    ConnectionUtilities.deleteConnection((String)hostID);
                } else {
                    PDDialogs.openInfoThreadSafe(MessageFormat.format(Messages.Remove_NoRemoveAllowed, ((IPDHost)this.getDataObject()).getConnectionName()));
                }
            }
        } else {
            PDDialogs.openInfoThreadSafe(MessageFormat.format(Messages.Remove_NoRemoveAllowedImported, ((IPDHost)this.getDataObject()).getConnectionName()));
        }
    }

    @Override
    public Object getPropertySource() {
        return new PDHostPropertySource((IPDHost)this.getDataObject());
    }

    @Override
    public String getPersistanceName() {
        return String.valueOf(this.getParent().getDataObject()) + "-->" + ((IPDHost)this.getDataObject()).getConnectionName() + "|" + ((IPDHost)this.getDataObject()).getDescription() + "|" + ((IPDHost)this.getDataObject()).getCodePage();
    }
}

