/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.views.systems.model;

import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.registery.IContentLoadStatus;
import com.ibm.pdtools.common.component.jhost.registery.IEntityContentListener;
import com.ibm.pdtools.common.component.jhost.registery.IEntityEventRemoteDispatcher;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.views.systems.model.ContentLoader;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class ContentCache<E, V> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final Map<E, CacheEntry<V>> entries = new ConcurrentHashMap<E, CacheEntry<V>>();
    private final List<EntityContentListener<E, V>> listeners = new CopyOnWriteArrayList<EntityContentListener<E, V>>();
    private final IEntityContentLoader<E, V> entityContentLoader;

    public ContentCache(IEntityContentLoader<E, V> loader) {
        this.entityContentLoader = loader;
    }

    public IContentLoadStatus<V> loadContent(final E entity) {
        final CacheEntry<V> entry = this.entries.get(entity);
        if (entry == null) {
            throw new IllegalStateException(Messages.ContentCache_ERROR_CANT_LOAD_CONTENT_FOR_ENTITY_WHICH_IS_NOT_IN_CACHE);
        }
        entry.loader.loadContent(new ContentLoader.ICallableWithProgress<V>(){

            @Override
            public V call(IHowIsGoing monitor) throws InterruptedException, CommunicationException {
                EntityContentListener remoteListener;
                if (entity instanceof IEntityEventRemoteDispatcher && (remoteListener = (EntityContentListener)((IEntityEventRemoteDispatcher)entity).getLoadFinishedListener()) != null) {
                    ContentCache.this.addContentLoadedListener(remoteListener);
                }
                return ContentCache.this.entityContentLoader.loadEntityContent(entity, monitor);
            }
        }, new Runnable(){

            @Override
            public void run() {
                if (entry.loader != null) {
                    EntityContentListener remoteListener;
                    for (EntityContentListener listener : ContentCache.this.listeners) {
                        try {
                            listener.postEntityContentLoad(entity, entry.loader);
                        }
                        catch (Exception e) {
                            PDLogger.get(this.getClass()).error((Object)"Error encountered in postEntityContentLoad listener", (Throwable)e);
                        }
                    }
                    if (entity instanceof IEntityEventRemoteDispatcher && (remoteListener = (EntityContentListener)((IEntityEventRemoteDispatcher)entity).getLoadFinishedListener()) != null) {
                        ContentCache.this.removeContentLoadedListener(remoteListener);
                    }
                }
            }
        }, this.entityContentLoader.getJobName(entity));
        return entry.loader;
    }

    public IContentLoadStatus<V> getLoadStatus(E entity) {
        CacheEntry<V> entry = this.entries.get(entity);
        return entry == null ? null : entry.loader;
    }

    public void unloadContent(E entity) {
        CacheEntry<V> entry = this.entries.get(entity);
        if (entry != null) {
            for (EntityContentListener<E, V> listener : this.listeners) {
                try {
                    listener.preEntityContentUnload(entity, entry.loader);
                }
                catch (Exception e) {
                    PDLogger.get(this.getClass()).error((Object)"Error encountered in preEntityContentUnload listener", (Throwable)e);
                }
            }
            entry.loader.unloadContent();
        }
    }

    public void unloadContentOnly(Object entity) {
        CacheEntry<V> entry = this.entries.get(entity);
        if (entry != null) {
            entry.loader.unloadContent();
        }
    }

    public boolean addContentLoadedListener(EntityContentListener<E, V> listener) {
        if (!this.listeners.contains(listener)) {
            return this.listeners.add(listener);
        }
        return false;
    }

    public boolean removeContentLoadedListener(EntityContentListener<E, V> listener) {
        return this.listeners.remove(listener);
    }

    public void acquireContentLock(E entity) {
        CacheEntry<V> cacheEntry = this.entries.get(entity);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry(new ContentLoader());
            this.entries.put(entity, cacheEntry);
        }
        cacheEntry.refCount.addAndGet(1);
    }

    public void releaseContentLock(E entity) {
        CacheEntry<V> cacheEntry = this.entries.get(entity);
        if (cacheEntry != null && cacheEntry.refCount.addAndGet(-1) <= 0) {
            this.entries.remove(entity);
        }
    }

    private static class CacheEntry<V> {
        public final AtomicInteger refCount = new AtomicInteger();
        public final ContentLoader<V> loader;

        public CacheEntry(ContentLoader<V> loader) {
            this.loader = Objects.requireNonNull(loader, "Must provide a non-null loader");
        }
    }

    public static interface EntityContentListener<E, V>
    extends IEntityContentListener<E, V> {
    }

    public static interface IEntityContentLoader<E, V> {
        public V loadEntityContent(E var1, IHowIsGoing var2) throws InterruptedException, CommunicationException;

        public String getJobName(E var1);
    }

    public static interface IEntityLoadJobNamer<E> {
    }
}

