/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.views.systems.handlers;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.util.PDGenerics;
import java.text.MessageFormat;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.TextEditor;

public enum PDHandlerUtil {
    UTIL;

    private static final PDLogger logger;

    static {
        logger = PDLogger.get(PDHandlerUtil.class);
    }

    public static TextEditor getActiveTextEditor(IEditorPart activeEditor) {
        return PDHandlerUtil.getActiveTypeEditor(activeEditor, TextEditor.class);
    }

    private static <T> T getActiveTypeEditor(IEditorPart activeEditor, Class<T> type) {
        if (activeEditor == null) {
            logger.error((Object)("The specified editor is null. Can't cast to " + type.getCanonicalName()));
            return null;
        }
        Object cast = PDGenerics.castIfInstanceOf((Object)activeEditor, type);
        if (cast == null) {
            logger.trace((Object)MessageFormat.format("The selected editor is not a {0}: it is in fact a {1}", type.getCanonicalName(), activeEditor.getClass().getCanonicalName()));
        }
        return (T)cast;
    }

    public static Object getFirstSelectedElementFromSelection(ISelection s) {
        if (s == null) {
            logger.trace((Object)"The specified selection is null.");
            return null;
        }
        if (!(s instanceof StructuredSelection)) {
            logger.trace((Object)("Selection is not a structuredSelection: " + s.getClass().getCanonicalName()));
            return null;
        }
        IStructuredSelection sSelection = (IStructuredSelection)s;
        if (sSelection.isEmpty()) {
            logger.trace((Object)"Selection is empty.");
            return null;
        }
        return sSelection.getFirstElement();
    }
}

