/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.views.systems.handlers;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsView;
import com.ibm.pdtools.common.component.ui.views.systems.PDTreeContentHolder;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsContentProvider;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.HostNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class Expand
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(Expand.class);

    @Override
    protected void handle(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (!(activePart instanceof PDSystemsView)) {
            return;
        }
        PDSystemsView activeSystemsView = (PDSystemsView)activePart;
        ArrayList<SystemsTreeNode> nodesToExpand = new ArrayList<SystemsTreeNode>();
        List<HostNode> hostNodes = PDTreeContentHolder.getInstance().getNodesOfType(HostNode.class);
        Stack<SystemsTreeNode> nodesToCheck = new Stack<SystemsTreeNode>();
        for (HostNode hostNode : hostNodes) {
            nodesToCheck.add(hostNode);
        }
        SystemsContentProvider cp = activeSystemsView.getContentProvider();
        while (!nodesToCheck.isEmpty()) {
            SystemsTreeNode currentNode = (SystemsTreeNode)nodesToCheck.pop();
            Object[] realisedChildren = cp.getRealisedChildren(currentNode);
            if (realisedChildren.length <= 0) continue;
            nodesToExpand.add(currentNode);
            Object[] objectArray = realisedChildren;
            int n = realisedChildren.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof SystemsTreeNode) {
                    nodesToCheck.add((SystemsTreeNode)object);
                }
                ++n2;
            }
        }
        TreeViewer tree = activeSystemsView.getTreeViewer();
        tree.getControl().setRedraw(false);
        logger.trace((Object)("Nodes to expand: " + String.valueOf(nodesToExpand)));
        for (SystemsTreeNode node : nodesToExpand) {
            tree.expandToLevel((Object)node, 1);
        }
        tree.getControl().setRedraw(true);
    }
}

