/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.views.systems;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDPlatformObject;
import com.ibm.pdtools.common.component.ui.util.ImageLoader;
import com.ibm.pdtools.common.component.ui.views.systems.IHasLabelAndImage;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import com.ibm.pdtools.common.component.ui.widget.CachedFilteredTree;
import java.io.File;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class SystemsLabelProvider
extends LabelProvider
implements IFontProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final ImageLoader imgLoader = new ImageLoader("icons" + File.separator + "tree" + File.separator);
    private final CachedFilteredTree cachedTree;

    public static void clearImageCache() {
        imgLoader.clearCache();
    }

    public SystemsLabelProvider() {
        this.cachedTree = null;
    }

    public SystemsLabelProvider(CachedFilteredTree cachedTree) {
        this.cachedTree = cachedTree;
    }

    public void dispose() {
        super.dispose();
    }

    public Image getImage(Object element) {
        return SystemsLabelProvider.getImageStatic(element);
    }

    public static synchronized Image getImageStatic(Object element) {
        String pluginId;
        String imageName;
        if (element instanceof IHasLabelAndImage) {
            imageName = ((IHasLabelAndImage)element).getPDImageName();
            pluginId = ((IHasLabelAndImage)element).getPDPluginId();
        } else {
            Object dataObject = element;
            if (element instanceof SystemsTreeNode) {
                dataObject = ((SystemsTreeNode)element).getDataObject();
            }
            imageName = "IMG_OBJ_ELEMENTS";
            pluginId = "com.ibm.pdtools.common.component.ui";
            if (dataObject instanceof IPDPlatformObject) {
                imageName = ((IPDPlatformObject)dataObject).getPDImageName();
                pluginId = ((IPDPlatformObject)dataObject).getPDPluginId();
            }
        }
        return imgLoader.getImageByName(pluginId, imageName);
    }

    public static synchronized ImageDescriptor getImageDescriptor(Object element) {
        String pluginId;
        String imageName;
        if (element instanceof IHasLabelAndImage) {
            imageName = ((IHasLabelAndImage)element).getPDImageName();
            pluginId = ((IHasLabelAndImage)element).getPDPluginId();
        } else {
            Object dataObject = element;
            if (element instanceof SystemsTreeNode) {
                dataObject = ((SystemsTreeNode)element).getDataObject();
            }
            imageName = "IMG_OBJ_ELEMENTS";
            pluginId = "com.ibm.pdtools.common.component.ui";
            if (dataObject instanceof IPDPlatformObject) {
                imageName = ((IPDPlatformObject)dataObject).getPDImageName();
                pluginId = ((IPDPlatformObject)dataObject).getPDPluginId();
            }
        }
        return imgLoader.getImageDescriptor(pluginId, imageName);
    }

    public String getText(Object element) {
        return SystemsLabelProvider.getTextStatic(element);
    }

    public static String getTextStatic(Object element) {
        if (element instanceof IHasLabelAndImage) {
            return ((IHasLabelAndImage)element).getPDLabel();
        }
        Object dataObject = element instanceof SystemsTreeNode ? ((SystemsTreeNode)element).getDataObject() : element;
        if (dataObject instanceof IPDPlatformObject) {
            return ((IPDPlatformObject)dataObject).getPDLabel();
        }
        PDLogger.get(SystemsLabelProvider.class).warn((Object)("Unable to get proper label for " + String.valueOf(element)));
        return element == null ? "" : element.toString();
    }

    public Font getFont(Object element) {
        if (this.cachedTree != null) {
            return CachedFilteredTree.getBoldFont(element, this.cachedTree, this.cachedTree.getPatternFilter());
        }
        return null;
    }
}

