/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.views.systems;

import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.core.comms.ConnectionUtilities;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.INaiveTreeUpdater;
import com.ibm.pdtools.common.component.core.model.ITreeContentHolder;
import com.ibm.pdtools.common.component.core.model.PDHost;
import com.ibm.pdtools.common.component.jhost.comms.HostDetails;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.registery.HostRegistry;
import com.ibm.pdtools.common.component.jhost.registery.RegistryLocator;
import com.ibm.pdtools.common.component.ui.PDTCCui;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.RootNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;

public class PDTreeContentHolder
implements ITreeContentHolder {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static PDTreeContentHolder instance = new PDTreeContentHolder();
    private final RootNode rootNode = new RootNode();

    public static PDTreeContentHolder getInstance() {
        return instance;
    }

    private PDTreeContentHolder() {
    }

    public Object getDefaultInput() {
        return this.rootNode;
    }

    public <Node_Type> List<Node_Type> getNodesOfType(Class<Node_Type> type) {
        ArrayList<Node_Type> nodesFound = new ArrayList<Node_Type>();
        ArrayList<? extends SystemsTreeNode> nodesToVisit = new ArrayList<SystemsTreeNode>();
        nodesToVisit.add(this.rootNode);
        while (nodesToVisit.size() > 0) {
            SystemsTreeNode current = (SystemsTreeNode)nodesToVisit.remove(nodesToVisit.size() - 1);
            if (!current.hasChildren()) continue;
            List<? extends SystemsTreeNode> children = current.getKnownChildren();
            for (SystemsTreeNode systemsTreeNode : children) {
                if (!type.isAssignableFrom(systemsTreeNode.getClass())) continue;
                nodesFound.add(type.cast(systemsTreeNode));
            }
            nodesToVisit.addAll(children);
        }
        return nodesFound;
    }

    public List<SystemsTreeNode> getNodesFor(Object object) {
        ArrayList<SystemsTreeNode> nodesFound = new ArrayList<SystemsTreeNode>();
        ArrayList<? extends SystemsTreeNode> nodesToVisit = new ArrayList<SystemsTreeNode>();
        nodesToVisit.add(this.rootNode);
        while (nodesToVisit.size() > 0) {
            SystemsTreeNode current = (SystemsTreeNode)nodesToVisit.remove(nodesToVisit.size() - 1);
            if (!current.hasChildren()) continue;
            List<? extends SystemsTreeNode> children = current.getKnownChildren();
            for (SystemsTreeNode systemsTreeNode : children) {
                if (!systemsTreeNode.getDataObject().equals(object)) continue;
                nodesFound.add(systemsTreeNode);
            }
            nodesToVisit.addAll(children);
        }
        return nodesFound;
    }

    public Job getLoadTreeJob(final String treeFile, final boolean saveOnShutdown) {
        return new Job(Messages.SystemsView_LOADING_VIEW){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    String path = PDTCCui.getDefault().getStateLocation().append(treeFile).toString();
                    File aFile = new File(path);
                    if (!aFile.exists()) {
                        String location = PDTCCui.getDefault().getStateLocation().toString();
                        try {
                            location = location.replace("com.ibm.pdtools.common.component.ui", "com.ibm.etools.fm.ui");
                            Path aPath = new Path(location);
                            aFile = new File(aPath.append(treeFile).toString());
                            if (!aFile.exists()) {
                                location = PDTCCui.getDefault().getStateLocation().toString();
                                try {
                                    location = location.replace("com.ibm.pdtools.common.component.ui", "com.ibm.pdtools.common.client.ui");
                                    aPath = new Path(location);
                                    aFile = new File(aPath.append(treeFile).toString());
                                }
                                catch (Exception exception) {}
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    Throwable throwable = null;
                    Object var5_9 = null;
                    try (BufferedReader mementoReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(aFile), StandardCharsets.UTF_8));){
                        XMLMemento mementoRoot = XMLMemento.createReadRoot((Reader)mementoReader);
                        PDTreeContentHolder.this.loadTreeStateFromMemento((IMemento)mementoRoot);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (FileNotFoundException e) {
                    PDLogger.get(((Object)((Object)this)).getClass()).trace((Object)("No existing systems found in file " + treeFile));
                }
                catch (IllegalStateException e) {
                    PDLogger.get(((Object)((Object)this)).getClass()).error((Object)"Failed to ascertain plugin data location", (Throwable)e);
                }
                catch (Exception e) {
                    PDLogger.get(((Object)((Object)this)).getClass()).error((Object)"Failed to load FM Systems tree contents", (Throwable)e);
                }
                PDTreeContentHolder.addNewConnectionsDefined(false);
                if (saveOnShutdown) {
                    PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

                        public boolean preShutdown(IWorkbench workbench, boolean forced) {
                            return true;
                        }

                        public void postShutdown(IWorkbench workbench) {
                            PDTreeContentHolder.this.saveTreeStateToFile(treeFile);
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
    }

    public void saveTreeStateToFile(String treeFile) {
        String path;
        XMLMemento rootMemento = XMLMemento.createWriteRoot((String)"tree");
        this.saveTreeStateToMemento((IMemento)rootMemento);
        try {
            path = PDTCCui.getDefault().getStateLocation().append(treeFile).toString();
        }
        catch (IllegalStateException e) {
            PDLogger.get(this.getClass()).warn((Object)"Failed to ascertain plugin data location", (Throwable)e);
            return;
        }
        try {
            Throwable e = null;
            Object var5_8 = null;
            try (BufferedWriter mementoWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), StandardCharsets.UTF_8));){
                rootMemento.save((Writer)mementoWriter);
                PDLogger.get(this.getClass()).trace((Object)("Saved content to file:\n" + path + "\n"));
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            PDLogger.get(this.getClass()).error((Throwable)e);
        }
    }

    public void saveTreeStateToMemento(IMemento rootMemento) {
        Objects.requireNonNull(rootMemento, "Must provide a non-null mementoRoot IMemento.");
        ITreeContentHolder[] treeContentHolders = PDHost.getTreeContentHolders();
        if (treeContentHolders != null) {
            ITreeContentHolder[] iTreeContentHolderArray = treeContentHolders;
            int n = treeContentHolders.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeContentHolder aTreeContentHolder = iTreeContentHolderArray[n2];
                aTreeContentHolder.saveTreeStateToMemento((ITreeContentHolder)this, rootMemento);
                ++n2;
            }
        }
    }

    public void loadTreeStateFromMemento(IMemento mementoRoot) {
        Objects.requireNonNull(mementoRoot, "Must provide a non-null mementoRoot IMemento.");
        ITreeContentHolder[] treeContentHolders = PDHost.getTreeContentHolders();
        if (treeContentHolders != null) {
            ITreeContentHolder[] iTreeContentHolderArray = treeContentHolders;
            int n = treeContentHolders.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeContentHolder aTreeContentHolder = iTreeContentHolderArray[n2];
                aTreeContentHolder.loadTreeStateFromMemento(mementoRoot);
                ++n2;
            }
        }
    }

    public void __clearTreeState() {
        if (!PDTCCui.getDefault().__isExperimentalTestingFunctionalityEnabled()) {
            PDLogger.get(this.getClass()).debug((Object)"Can't clear tree state without experimental testing functionality enabled");
            return;
        }
        PDLogger.get(this.getClass()).warn((Object)"EXPERIMENTAL: Clearing tree state by removing all hosts from host registry");
        HostRegistry registry = RegistryLocator.instance().getHostRegistry();
        for (IPDHost host : registry.all()) {
            registry.remove((Object)host);
        }
    }

    public static void addNewConnectionsDefined(boolean newHost) {
        Collection hosts = ConnectionUtilities.getSystemInformation();
        for (HostDetails aHostDetails : hosts) {
            IPDHost host = PDHost.create((HostDetails)aHostDetails);
            if (newHost) {
                RegistryLocator.instance().getHostRegistry().findOrAdd((Object)host);
                continue;
            }
            RegistryLocator.instance().getHostRegistry().addOld((Object)host);
        }
    }

    public static void addNewConnectionsDefined() {
        PDTreeContentHolder.addNewConnectionsDefined(true);
    }

    public INaiveTreeUpdater createNaiveTreeUpdater() {
        return null;
    }

    public void saveTreeStateToMemento(ITreeContentHolder pdTreeContentHolder, IMemento rootMemento) {
    }

    public boolean refreshAllRelatedTo(Object anObject) {
        return false;
    }
}

