/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.views.systems;

import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.registery.EListener;
import com.ibm.pdtools.common.component.jhost.registery.EntityEvent;
import com.ibm.pdtools.common.component.jhost.registery.HostRegistry;
import com.ibm.pdtools.common.component.jhost.registery.RegistryLocator;
import com.ibm.pdtools.common.component.ui.util.EclipseUtils;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.AbstractSourceProvider;

public class PDSystemsViewSourceProvider
extends AbstractSourceProvider
implements EclipseUtils.IRefreshableSourceProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String VAR_HOSTS_DEFINED = "com.ibm.pdtools.common.component.hostsDefined";
    private static final String HOSTS_DEFINED_NO = "no";
    private static final String HOSTS_DEFINED_YES = "yes";
    private EListener<EntityEvent<IPDHost>> hostListener = new EListener<EntityEvent<IPDHost>>(){

        public void onEvent(EntityEvent<IPDHost> event) {
            switch (event.getType()) {
                case OLDADDED: 
                case ADDED: 
                case REMOVED: {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            PDSystemsViewSourceProvider.this.fireSourceChanged(0, PDSystemsViewSourceProvider.VAR_HOSTS_DEFINED, PDSystemsViewSourceProvider.this.getHostState());
                        }
                    });
                    break;
                }
            }
        }
    };
    private final HostRegistry hostRegistry = RegistryLocator.instance().getHostRegistry();

    public PDSystemsViewSourceProvider() {
        this.hostRegistry.addListener(this.hostListener);
    }

    public void dispose() {
        this.hostRegistry.removeListener(this.hostListener);
    }

    public Map<String, Object> getCurrentState() {
        HashMap<String, Object> currentState = new HashMap<String, Object>();
        currentState.put(VAR_HOSTS_DEFINED, this.getHostState());
        return currentState;
    }

    private String getHostState() {
        int numHosts = this.hostRegistry.size();
        return numHosts == 0 ? HOSTS_DEFINED_NO : HOSTS_DEFINED_YES;
    }

    public String[] getProvidedSourceNames() {
        return new String[]{VAR_HOSTS_DEFINED};
    }

    @Override
    public void refreshAllVariables() {
        this.fireSourceChanged(0, this.getCurrentState());
    }
}

