/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.views.systems;

import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsErrorFinder;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.util.Iterator;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.viewers.IStructuredSelection;

public class PDSystemsViewPropertyTester
extends PropertyTester {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String NAMESPACE = "com.ibm.pdtools.common.component.ui.tree";
    public static final String PROPERTY_HAS_ERROR = "hasError";
    public static final String PROPERTY_CAN_HAVE_CHILDREN = "canHaveChildren";
    public static final String PROPERTY_FROM_SAME_SYSTEM = "fromSameSystem";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (PROPERTY_HAS_ERROR.equals(property)) {
            return PDSystemsViewPropertyTester.hasError(receiver);
        }
        if (PROPERTY_CAN_HAVE_CHILDREN.equals(property)) {
            return PDSystemsViewPropertyTester.canHaveChildren(receiver);
        }
        if (PROPERTY_FROM_SAME_SYSTEM.equals(property)) {
            return PDSystemsViewPropertyTester.fromSameSystem(receiver);
        }
        return false;
    }

    private static boolean hasError(Object receiver) {
        if (!(receiver instanceof SystemsTreeNode)) {
            return false;
        }
        SystemsTreeNode systemsTreeNode = (SystemsTreeNode)receiver;
        return SystemsErrorFinder.INSTANCE.hasError(systemsTreeNode);
    }

    private static boolean canHaveChildren(Object receiver) {
        return receiver instanceof SystemsTreeNode && ((SystemsTreeNode)receiver).hasChildren();
    }

    private static boolean fromSameSystem(Object receiver) {
        if (!(receiver instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection selection = (IStructuredSelection)receiver;
        Iterator iterator = selection.iterator();
        IPDHost firstSystem = null;
        while (iterator.hasNext()) {
            Object current = iterator.next();
            if (!(current instanceof SystemsTreeNode)) continue;
            SystemsTreeNode stn = (SystemsTreeNode)current;
            IPDHost currentSystem = null;
            if (stn instanceof IHostProvider) {
                currentSystem = ((IHostProvider)stn).getSystem();
            } else if (stn.getDataObject() instanceof IHostProvider) {
                currentSystem = ((IHostProvider)stn.getDataObject()).getSystem();
            } else {
                return false;
            }
            if (firstSystem == null) {
                firstSystem = currentSystem;
                continue;
            }
            if (firstSystem.equals(currentSystem)) continue;
            return false;
        }
        return true;
    }
}

