/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.views.systems;

import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.core.PDTCCcore;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.IDoubleClickSensitiveNode;
import com.ibm.pdtools.common.component.core.model.IUIPluginHostConnection;
import com.ibm.pdtools.common.component.core.model.PDHost;
import com.ibm.pdtools.common.component.jhost.core.model.ISystemsView;
import com.ibm.pdtools.common.component.jhost.registery.RegistryLocator;
import com.ibm.pdtools.common.component.ui.PDTCCui;
import com.ibm.pdtools.common.component.ui.context.SystemsViewContext;
import com.ibm.pdtools.common.component.ui.prefs.PDCommonPreferenceFeaturesPage;
import com.ibm.pdtools.common.component.ui.prefs.PDCommonPreferencePage;
import com.ibm.pdtools.common.component.ui.util.EclipseUtils;
import com.ibm.pdtools.common.component.ui.util.PDPlatformUIUtils;
import com.ibm.pdtools.common.component.ui.util.PDSafeUIRunner;
import com.ibm.pdtools.common.component.ui.views.systems.IPDPersistableNode;
import com.ibm.pdtools.common.component.ui.views.systems.PDNaiveTreeUpdater;
import com.ibm.pdtools.common.component.ui.views.systems.PDStructuredViewerDragAndDropSupport;
import com.ibm.pdtools.common.component.ui.views.systems.PDTreeContentHolder;
import com.ibm.pdtools.common.component.ui.views.systems.SorterEBCDIC;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsContentProvider;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsDecoratingLabelProvider;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsErrorFinder;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsLabelDecorator;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsLabelProvider;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDEventNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.HostNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.LoadErrorNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import com.ibm.pdtools.common.component.ui.widget.CachedFilteredTree;
import com.ibm.pdtools.common.component.ui.widget.CachedPatternFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class PDSystemsView
extends ViewPart
implements IDoubleClickListener,
ISystemsView,
PDCommonPreferencePage.ICommonPreferencePage {
    private static final PDLogger logger = PDLogger.get(PDSystemsView.class);
    private static final String TREE_REFRESH_JOB = "TREE_REFRESH_JOB";
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2022. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String ID = "com.ibm.etools.fm.views.Systems";
    private static final String[] STANDARD_DOUBLE_CLICK_COMMANDS = new String[]{"com.ibm.pdtools.common.component.ui.model.commands.viewErrors"};
    private static final long minTimeBetweenRefresh = 500L;
    private static long lastRefreshTime = System.currentTimeMillis();
    private static final List<TabbedPropertySheetPage> propertyPages = Collections.synchronizedList(new ArrayList());
    private static final SystemsContentProvider contentProvider = new SystemsContentProvider();
    private static final String fmEditorInvokeCommand = "com.ibm.etools.fm.ext.rse.integration.command.formattededitor";
    private static final List<PDSystemsView> initCompleteInstances = Collections.synchronizedList(new ArrayList());
    private CachedFilteredTree filteredTree;
    private TreeViewer treeViewer;
    private DrillDownAdapter drillDownAdapter;
    protected PDNaiveTreeUpdater pdNaiveTreeUpdater;
    private SystemsViewContext context;
    private static IMemento memento;
    private static final String persistanceRootName = "com.ibm.pdtools.systems.information.tree.expanded.nodes";
    private static final String persistanceNodeName = "IPDPersistableNode";
    private static final String persistanceCloseNodeName = "PDHostNode";

    public static List<PDSystemsView> getInstances() {
        return Collections.unmodifiableList(initCompleteInstances);
    }

    public static void tryRefresh() {
        UIJob run = new UIJob("Refreshing tree..."){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (!monitor.isCanceled()) {
                    for (PDSystemsView view2 : PDSystemsView.getInstances()) {
                        if (view2 == null || view2.treeViewer == null || view2.treeViewer.getTree().isDisposed()) continue;
                        lastRefreshTime = System.currentTimeMillis();
                        EclipseUtils.retestEclipseProperty("com.ibm.pdtools.common.component.ui.tree", "hasError");
                        if (monitor.isCanceled()) continue;
                        view2.treeViewer.refresh();
                    }
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            }

            public boolean belongsTo(Object family) {
                return family == PDSystemsView.TREE_REFRESH_JOB;
            }
        };
        Job.getJobManager().cancel((Object)TREE_REFRESH_JOB);
        run.schedule(50L);
    }

    public static synchronized void refreshPropertyPage() {
        PDLogger.get(PDSystemsView.class).trace((Object)"Refreshing property sheet pages");
        Iterator<TabbedPropertySheetPage> iterator = propertyPages.iterator();
        while (iterator.hasNext()) {
            TabbedPropertySheetPage propertyPage = iterator.next();
            Control control = propertyPage.getControl();
            if (control == null) continue;
            if (control.isDisposed()) {
                PDLogger.get(PDSystemsView.class).trace((Object)"Removed old property sheet control");
                iterator.remove();
                continue;
            }
            if (propertyPage.getCurrentTab() == null) continue;
            propertyPage.refresh();
        }
    }

    public void createPartControl(Composite parent) {
        this.filteredTree = new CachedFilteredTree(parent, 2818, new CachedPatternFilter(), true);
        this.filteredTree.getPatternFilter().setIncludeLeadingWildcard(true);
        this.filteredTree.setInitialText(Messages.SystemsView_TYPE_TO_SEARCH_TREE);
        this.treeViewer = this.filteredTree.getViewer();
        PDStructuredViewerDragAndDropSupport.addDragAndDrop((StructuredViewer)this.treeViewer);
        this.treeViewer.getControl().setRedraw(false);
        this.treeViewer.getTree().setRedraw(false);
        this.treeViewer.setUseHashlookup(true);
        CustomToolTipSupport.enableFor((ColumnViewer)this.treeViewer, 2);
        this.treeViewer.setContentProvider((IContentProvider)contentProvider);
        SystemsLabelDecorator labelDecorator = new SystemsLabelDecorator();
        SystemsLabelProvider labelProvider = new SystemsLabelProvider(this.filteredTree);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new SystemsDecoratingLabelProvider((ILabelProvider)labelProvider, (ILabelDecorator)labelDecorator));
        this.treeViewer.setSorter((ViewerSorter)SorterEBCDIC.getInstance());
        this.treeViewer.setInput(PDTreeContentHolder.getInstance().getDefaultInput());
        this.treeViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolbarMgr = actionBars.getToolBarManager();
        this.drillDownAdapter = new DrillDownAdapter(this.treeViewer);
        this.drillDownAdapter.addNavigationActions(toolbarMgr);
        MenuManager popupMenuMgr = new MenuManager("#PopupMenu");
        popupMenuMgr.setRemoveAllWhenShown(false);
        Menu menu = popupMenuMgr.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(popupMenuMgr, (ISelectionProvider)this.treeViewer);
        if (PDLogger.isTraceEnabled()) {
            PDSystemsView.addTracingListeners((Tree)this.treeViewer.getControl());
        }
        this.context.enable();
        UIJob job = new UIJob(Messages.PDSystemsView_0){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                PDSystemsView.this.pdNaiveTreeUpdater = new PDNaiveTreeUpdater(PDSystemsView.this.treeViewer, RegistryLocator.instance().getHostRegistry(), PDTreeContentHolder.getInstance());
                PDTreeContentHolder.addNewConnectionsDefined(false);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!(this).PDSystemsView.this.treeViewer.getTree().isDisposed()) {
                            (this).PDSystemsView.this.treeViewer.refresh();
                        }
                        if (PDTCCcore.getDefault().getPreferenceStore().getBoolean("saveSystemsTree")) {
                            PDSystemsView.restoreState();
                        } else {
                            (this).PDSystemsView.this.treeViewer.expandToLevel(2);
                        }
                    }
                });
                if (!PDSystemsView.this.treeViewer.getTree().isDisposed()) {
                    PDSystemsView.this.treeViewer.getControl().setRedraw(true);
                    PDSystemsView.this.treeViewer.getTree().setRedraw(true);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.setPriority(50);
        job.schedule();
    }

    private static void addTracingListeners(final Tree tree) {
        tree.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                StringBuilder sb = new StringBuilder();
                TreeItem[] selection = tree.getSelection();
                int i = 0;
                while (i < selection.length) {
                    sb.append(selection[i]).append(" ");
                    ++i;
                }
                PDLogger.get(this.getClass()).trace((Object)("Selection=" + sb.toString()));
            }
        });
        tree.addListener(14, new Listener(){

            public void handleEvent(Event e) {
                StringBuilder sb = new StringBuilder();
                TreeItem[] selection = tree.getSelection();
                int i = 0;
                while (i < selection.length) {
                    sb.append(selection[i]).append(" ");
                    ++i;
                }
                PDLogger.get(this.getClass()).trace((Object)("DefaultSelection=" + sb.toString()));
            }
        });
        tree.addListener(17, new Listener(){

            public void handleEvent(Event e) {
                PDLogger.get(this.getClass()).trace((Object)("Expanded=" + String.valueOf(e.item)));
            }
        });
        tree.addListener(18, new Listener(){

            public void handleEvent(Event e) {
                PDLogger.get(this.getClass()).trace((Object)("Collapsed=" + String.valueOf(e.item)));
            }
        });
    }

    public DrillDownAdapter getDrillDownAdapter() {
        return this.drillDownAdapter;
    }

    public void doubleClick(final DoubleClickEvent event) {
        IUIPluginHostConnection[] uiPluginHostConnections;
        int n;
        int n2;
        Object[] objectArray;
        boolean defauldCommandProcessed = false;
        ITreeSelection selection = (ITreeSelection)event.getSelection();
        TreePath[] selectedPaths = selection.getPaths();
        if (selectedPaths.length > 0) {
            final TreePath firstPath = selectedPaths[0];
            SystemsTreeNode node = (SystemsTreeNode)firstPath.getLastSegment();
            final IHandlerService handlerService = EclipseUtils.getService(IHandlerService.class);
            if (this.getContentProvider().hasChildren(node)) {
                PDSafeUIRunner.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PDSystemsView.this.treeViewer.setExpandedState((Object)firstPath, !PDSystemsView.this.treeViewer.getExpandedState((Object)firstPath));
                    }
                });
                defauldCommandProcessed = true;
            } else if (!(node instanceof IDoubleClickSensitiveNode) && (node instanceof LoadErrorNode || SystemsErrorFinder.INSTANCE.hasError(node))) {
                objectArray = STANDARD_DOUBLE_CLICK_COMMANDS;
                n2 = STANDARD_DOUBLE_CLICK_COMMANDS.length;
                n = 0;
                while (n < n2) {
                    ISystemsView command2 = objectArray[n];
                    if (EclipseUtils.isCommandEnabled((String)command2)) {
                        PDSafeUIRunner.syncExec(new Runnable((String)command2, node){
                            private final /* synthetic */ String val$command;
                            private final /* synthetic */ SystemsTreeNode val$node;
                            {
                                this.val$command = string;
                                this.val$node = systemsTreeNode;
                            }

                            @Override
                            public void run() {
                                try {
                                    handlerService.executeCommand(this.val$command, null);
                                }
                                catch (Exception e) {
                                    PDLogger.get(this.getClass()).debug((Object)("Failed to execute enabled command; node=" + String.valueOf(this.val$node) + "; command=" + this.val$command), (Throwable)e);
                                }
                            }
                        });
                        defauldCommandProcessed = true;
                        break;
                    }
                    ++n;
                }
            }
        }
        if ((uiPluginHostConnections = PDHost.getUiSystemExtendPlugins()) != null) {
            ISystemsView[] systemsViews = new ISystemsView[uiPluginHostConnections.length];
            int i = 0;
            while (i < uiPluginHostConnections.length) {
                systemsViews[i] = uiPluginHostConnections[i].createSystemsViewExtention();
                ++i;
            }
            if (PDLogger.isTraceEnabled()) {
                PDLogger.get(this.getClass()).trace((Object)("PD: " + String.valueOf(event)));
            }
            final boolean defFinal = defauldCommandProcessed;
            objectArray = systemsViews;
            n2 = systemsViews.length;
            n = 0;
            while (n < n2) {
                final ISystemsView aSystemsView = objectArray[n];
                PDSafeUIRunner.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            aSystemsView.doubleClick((ISystemsView)PDSystemsView.this, (Object)event, defFinal);
                        }
                        catch (Exception e) {
                            PDLogger.get(this.getClass()).debug(new Object[]{"Failed to execute double click ", event, e});
                        }
                    }
                });
                ++n;
            }
        }
    }

    public static boolean handleDoubleClick(Object node, boolean isExpandable, boolean fromPDSystemsView, boolean passNode) {
        ISystemsView[] systemsViews;
        IHandlerService handlerService = EclipseUtils.getService(IHandlerService.class);
        if (!(node instanceof IDoubleClickSensitiveNode) && (node instanceof LoadErrorNode || SystemsErrorFinder.INSTANCE.hasError(node))) {
            String[] stringArray = STANDARD_DOUBLE_CLICK_COMMANDS;
            int n = STANDARD_DOUBLE_CLICK_COMMANDS.length;
            int n2 = 0;
            while (n2 < n) {
                String command2 = stringArray[n2];
                if (EclipseUtils.isCommandEnabled(command2)) {
                    try {
                        handlerService.executeCommand(command2, (Event)(passNode ? new PDEventNode((SystemsTreeNode)node, fromPDSystemsView) : null));
                    }
                    catch (Exception e) {
                        PDLogger.get(PDSystemsView.class).debug((Object)("Failed to execute enabled command; node=" + String.valueOf(node) + "; command=" + command2), (Throwable)e);
                    }
                    return true;
                }
                ++n2;
            }
        }
        if (isExpandable) {
            return false;
        }
        boolean commandExecuteStatus = PDSystemsView.executeFMEditorCmd(handlerService);
        if (!commandExecuteStatus && (systemsViews = PDSystemsView.getSystemsView()) != null) {
            ISystemsView[] iSystemsViewArray = systemsViews;
            int n = systemsViews.length;
            int n3 = 0;
            while (n3 < n) {
                ISystemsView aSystemsView = iSystemsViewArray[n3];
                aSystemsView.doubleClick(aSystemsView, (Object)new PDEventNode((SystemsTreeNode)node, fromPDSystemsView), false);
                ++n3;
            }
        }
        return false;
    }

    private static boolean executeFMEditorCmd(IHandlerService handlerService) {
        boolean commandExecuteStatus = true;
        try {
            handlerService.executeCommand(fmEditorInvokeCommand, null);
        }
        catch (ExecutionException e) {
            commandExecuteStatus = false;
        }
        catch (NotDefinedException e) {
            commandExecuteStatus = false;
        }
        catch (NotEnabledException e) {
            commandExecuteStatus = false;
        }
        catch (NotHandledException e) {
            commandExecuteStatus = false;
        }
        return commandExecuteStatus;
    }

    public void expandAndSelect(Object data, Class<? extends SystemsTreeNode> nodeClass) {
        List<SystemsTreeNode> visibleNodes = this.getVisibleNodesFor(data, nodeClass);
        if (!this.treeViewer.getTree().isDisposed()) {
            for (SystemsTreeNode node : visibleNodes) {
                this.treeViewer.expandToLevel((Object)node, 1);
            }
            this.treeViewer.setSelection((ISelection)new StructuredSelection(visibleNodes), true);
        }
    }

    private List<SystemsTreeNode> getVisibleNodesFor(Object data, Class<? extends SystemsTreeNode> nodeClass) {
        ArrayList<SystemsTreeNode> nodesFound = new ArrayList<SystemsTreeNode>();
        ArrayList<? extends SystemsTreeNode> nodesToVisit = new ArrayList<SystemsTreeNode>();
        nodesToVisit.add((SystemsTreeNode)this.treeViewer.getInput());
        while (nodesToVisit.size() > 0) {
            SystemsTreeNode current = (SystemsTreeNode)nodesToVisit.remove(nodesToVisit.size() - 1);
            if (!current.hasChildren()) continue;
            List<? extends SystemsTreeNode> children = current.getKnownChildren();
            for (SystemsTreeNode systemsTreeNode : children) {
                if (nodeClass != null && !systemsTreeNode.getClass().equals(nodeClass) || !systemsTreeNode.getDataObject().equals(data)) continue;
                nodesFound.add(systemsTreeNode);
            }
            nodesToVisit.addAll(children);
        }
        return nodesFound;
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public SystemsContentProvider getContentProvider() {
        return contentProvider;
    }

    public void setFocus() {
        if (!this.treeViewer.getTree().isDisposed()) {
            this.treeViewer.getControl().setFocus();
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            TabbedPropertySheetPage propertySheetPage = new TabbedPropertySheetPage(new ITabbedPropertySheetPageContributor(){

                public String getContributorId() {
                    return PDSystemsView.ID;
                }
            });
            propertyPages.add(propertySheetPage);
            PDLogger.get(this.getClass()).trace((Object)"Added newproperty sheet control to list of property sheets");
            return propertySheetPage;
        }
        return super.getAdapter(adapter);
    }

    private static void setMemento(IMemento memento) {
        if (memento != null) {
            PDSystemsView.memento = memento;
        }
    }

    public static IMemento getMemento() {
        return memento;
    }

    public void init(IViewSite site, IMemento initMemento) throws PartInitException {
        super.init(site, initMemento);
        PDSystemsView.setMemento(initMemento);
        initCompleteInstances.add(this);
        PDCommonPreferencePage.setCommonPreferencePageObserver(this);
        PDCommonPreferenceFeaturesPage.setCommonPreferencePageObserver(this);
        PDTCCui.getDefault().loadSysInfoTreeContents();
        this.context = new SystemsViewContext((IWorkbenchPartSite)site);
    }

    public static ISystemsView[] getSystemsView() {
        ISystemsView[] systemsViews = null;
        IUIPluginHostConnection[] uiPluginHostConnections = PDHost.getUiSystemExtendPlugins();
        if (uiPluginHostConnections != null) {
            systemsViews = new ISystemsView[uiPluginHostConnections.length];
            int i = 0;
            while (i < uiPluginHostConnections.length) {
                systemsViews[i] = uiPluginHostConnections[i].createSystemsViewExtention();
                ++i;
            }
        }
        return systemsViews;
    }

    public void dispose() {
        if (this.pdNaiveTreeUpdater != null) {
            this.pdNaiveTreeUpdater.dispose();
        }
        initCompleteInstances.remove(this);
        try {
            Job.getJobManager().cancel((Object)TREE_REFRESH_JOB);
        }
        catch (Exception e) {
            logger.error((Object)"Error occurred while cancelling refresh job.", (Throwable)e);
        }
        this.context.disable();
        super.dispose();
    }

    public String getPartProperty(String key) {
        if ("com.ibm.cics.core.comm.IConnectionCategory".equals(key)) {
            return "com.ibm.pdtools.comms.cics.category";
        }
        return super.getPartProperty(key);
    }

    public void doubleClick(ISystemsView pdSystemsView, Object eventObject, boolean deafultCommandProcessed) {
    }

    @Override
    public void okay() {
        PDSystemsView.tryRefresh();
    }

    public static String getPersistanceRootName() {
        return persistanceRootName;
    }

    public static String getPersistanceNodeName() {
        return persistanceNodeName;
    }

    public static String getPersistanceCloseNodeName() {
        return persistanceCloseNodeName;
    }

    public void saveState(IMemento stateMemento) {
        Iterator<Object> iter = Arrays.asList(this.treeViewer.getVisibleExpandedElements()).iterator();
        if (iter.hasNext()) {
            stateMemento = stateMemento.createChild(persistanceRootName);
            while (iter.hasNext()) {
                Object node = iter.next();
                if (!(node instanceof IPDPersistableNode)) continue;
                String persistanceName = ((IPDPersistableNode)node).getPersistanceName();
                stateMemento.createChild(persistanceNodeName, persistanceName);
            }
        }
        for (HostNode n : PDTreeContentHolder.getInstance().getNodesOfType(HostNode.class)) {
            boolean visible = false;
            for (Object node : Arrays.asList(this.treeViewer.getVisibleExpandedElements())) {
                if (!(node instanceof HostNode) || !n.getPersistanceName().equals(((HostNode)node).getPersistanceName())) continue;
                visible = true;
                break;
            }
            if (visible) continue;
            stateMemento.createChild(persistanceCloseNodeName, n.getPersistanceName());
        }
        if (stateMemento != null) {
            PDTCCui.saveSysInfo(stateMemento);
        }
        PDSystemsView.setMemento(stateMemento);
    }

    private static void restoreState() {
        if (PDSystemsView.getMemento() == null) {
            PDLogger.get(PDSystemsView.class).trace((Object)"cant restore tree state if memento is null.");
            return;
        }
        IMemento expandedMemento = PDSystemsView.getMemento().getChild(persistanceRootName);
        if (expandedMemento != null) {
            PDTCCui.restoreSysInfo(expandedMemento);
            IMemento[] expandedNodes = expandedMemento.getChildren(persistanceNodeName);
            ArrayList<String> nodesToExpand = new ArrayList<String>();
            if (expandedNodes.length > 0) {
                int i = 0;
                while (i < expandedNodes.length) {
                    String id = expandedNodes[i].getID();
                    if (id != null) {
                        nodesToExpand.add(id);
                    }
                    ++i;
                }
                StringBuffer buf = new StringBuffer();
                for (IPDPersistableNode n : PDTreeContentHolder.getInstance().getNodesOfType(IPDPersistableNode.class)) {
                    for (String toExpand : nodesToExpand) {
                        if (!n.getPersistanceName().equals(toExpand)) continue;
                        buf.append("\nexpanding... " + toExpand);
                        for (PDSystemsView instance : PDSystemsView.getInstances()) {
                            TreeViewer tv = instance.getTreeViewer();
                            if (tv.getTree().isDisposed()) continue;
                            tv.expandToLevel((Object)n, 1);
                        }
                    }
                }
                if (PDLogger.isTraceEnabled()) {
                    PDLogger.get(PDSystemsView.class).trace((Object)buf.toString());
                }
            }
        }
    }

    public static PDSystemsView showView() {
        return PDPlatformUIUtils.view.showView(ID, PDSystemsView.class);
    }

    public static void runAndMarkPartBusy(Job job) {
        Objects.requireNonNull(job, "Must specify a non-null job.");
        PDSystemsView list = PDSystemsView.showView();
        if (list != null) {
            PDPlatformUIUtils.scheduleAndMarkPartBusy(job, list.getSite());
        } else {
            job.schedule();
        }
    }

    private static class CustomToolTipSupport
    extends ColumnViewerToolTipSupport {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2022. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private static final int MAX_WIDTH = 600;
        private static final int MAX_HEIGHT = 400;

        protected CustomToolTipSupport(ColumnViewer viewer, int style, boolean manualActivation) {
            super(viewer, style, manualActivation);
        }

        protected Composite createToolTipContentArea(Event event, Composite parent) {
            Composite composite = new Composite(parent, 0);
            String input = this.getText(event);
            GC gc = new GC((Drawable)new Text((Composite)new Shell(), 0));
            int width = (int)Math.min(CustomToolTipSupport.getMaxLineWidth(input, gc.getFontMetrics().getAverageCharWidth()), 600.0);
            int height = Math.min(CustomToolTipSupport.getTotalLines(input, gc.getFontMetrics().getHeight(), width, gc.getFontMetrics().getAverageCharWidth()), 400);
            int style = 74;
            if (height == 400) {
                style |= 0x200;
            }
            Text text2 = new Text(composite, style);
            text2.setText(input);
            text2.setSize(width, height);
            text2.setBackground(new Color(gc.getDevice(), 255, 255, 225));
            return composite;
        }

        private static final int getTotalLines(String text2, int avgLineHeight, int maxWidth, double avgCharWidth) {
            Throwable throwable = null;
            Object var6_6 = null;
            try (Scanner sc = new Scanner(text2);){
                int totLines = 0;
                while (sc.hasNextLine()) {
                    String line = sc.nextLine();
                    double lineWidth = CustomToolTipSupport.getMaxLineWidth(line, avgCharWidth);
                    totLines = (int)((double)totLines + (lineWidth / (double)maxWidth + (double)(lineWidth == 0.0 || lineWidth > 0.0 && (int)lineWidth % maxWidth > 0 ? 1 : 0)));
                }
                return totLines * avgLineHeight;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        private static final double getMaxLineWidth(String text2, double avgCharWidth) {
            Throwable throwable = null;
            Object var4_4 = null;
            try (Scanner sc = new Scanner(text2);){
                double maxLength = 0.0;
                while (sc.hasNextLine()) {
                    String line = sc.nextLine();
                    double lineWidth = 0.0;
                    int i = 0;
                    while (i < line.length()) {
                        lineWidth += Character.isUpperCase(line.charAt(i)) ? avgCharWidth * 1.4 : avgCharWidth;
                        ++i;
                    }
                    maxLength = Math.max(maxLength, lineWidth);
                }
                return maxLength;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        public boolean isHideOnMouseDown() {
            return false;
        }

        public static final void enableFor(ColumnViewer viewer) {
            new CustomToolTipSupport(viewer, 2, false);
        }

        public static final void enableFor(ColumnViewer viewer, int style) {
            new CustomToolTipSupport(viewer, style, false);
        }
    }
}

