/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.views.systems;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.ITreeContentHolder;
import com.ibm.pdtools.common.component.core.model.PDHost;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsView;
import java.util.Objects;

public class PDSystemsTreeUpdater {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(PDSystemsTreeUpdater.class);

    public static void refreshAllRelatedTo(Object anObject) {
        ITreeContentHolder[] treeContentHolders;
        Objects.requireNonNull(anObject, "anObject must not be null");
        boolean refreshed = false;
        ITreeContentHolder[] iTreeContentHolderArray = treeContentHolders = PDHost.getTreeContentHolders();
        int n = treeContentHolders.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeContentHolder aTreeContentHolder = iTreeContentHolderArray[n2];
            if (aTreeContentHolder.refreshAllRelatedTo(anObject)) {
                refreshed = true;
                break;
            }
            ++n2;
        }
        if (!refreshed) {
            logger.debug(new Object[]{"Don't know how to refresh objects of type ", anObject.getClass(), " : " + anObject.toString()});
        }
        PDSystemsView.tryRefresh();
    }
}

