/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.views.systems;

import com.ibm.pdtools.common.component.ui.views.systems.IPDDragSource;
import com.ibm.pdtools.common.component.ui.views.systems.IPDDropTarget;
import com.ibm.pdtools.common.component.ui.views.systems.PDTransfer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;

public abstract class PDStructuredViewerDragAndDropSupport {
    private static Object dropTarget = null;
    private static List<IPDDragSource> draggedObjects = null;
    public static final boolean enableDNDLogging = false;

    public static void addDragAndDrop(final StructuredViewer viewer) {
        if (viewer == null) {
            return;
        }
        int operations = 19;
        Transfer[] transferTypes = new Transfer[]{PDTransfer.getInstance(), LocalSelectionTransfer.getTransfer()};
        viewer.addDragSupport(operations, transferTypes, new DragSourceListener(){

            public void dragFinished(DragSourceEvent event) {
                if (dropTarget != null && dropTarget instanceof IPDDropTarget) {
                    IPDDropTarget target = (IPDDropTarget)dropTarget;
                    if (draggedObjects != null && target.isValidInput(draggedObjects)) {
                        target.execute(draggedObjects, event.detail);
                    }
                }
                draggedObjects = null;
                dropTarget = null;
            }

            public void dragStart(DragSourceEvent event) {
                dropTarget = null;
                draggedObjects = new ArrayList<IPDDragSource>();
                ISelection selection = viewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection strucSel = (IStructuredSelection)selection;
                    for (Object next : strucSel) {
                        if (!(next instanceof IPDDragSource)) continue;
                        draggedObjects.add((IPDDragSource)next);
                    }
                }
            }

            public void dragSetData(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(viewer.getSelection());
            }
        });
        viewer.addDropSupport(operations, transferTypes, (DropTargetListener)new ViewerDropAdapter((Viewer)viewer){

            public boolean performDrop(Object data) {
                return true;
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                boolean rc = false;
                if (!draggedObjects.isEmpty() && target != null && target instanceof IPDDropTarget) {
                    rc = ((IPDDropTarget)target).isValidInput(draggedObjects);
                }
                return rc;
            }

            public void drop(DropTargetEvent event) {
                Object target = this.determineTarget(event);
                if (this.validateDrop(target, event.detail, event.currentDataType)) {
                    super.drop(event);
                    dropTarget = target;
                }
            }
        });
    }
}

