/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.util.string;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;

public class StringStorage
implements IStorage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final int MAX_ALLOWED_STRING_LENGTH = 4096;
    private final String displayName;
    private final String string;

    public StringStorage(String input, String displayName) {
        Objects.requireNonNull(input, "Please provide a non-null string as input.");
        int toNum = Math.min(4096, input.length());
        this.string = input.substring(0, toNum) + (input.length() > toNum ? "..." : "");
        this.displayName = displayName == null || displayName.isEmpty() ? this.string.substring(0, Math.min(5, this.string.length())).concat("...") : displayName;
    }

    public InputStream getContents() {
        return new ByteArrayInputStream(this.string.getBytes(StandardCharsets.UTF_8));
    }

    public IPath getFullPath() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (String.class.equals((Object)adapter)) {
            return this.string;
        }
        return null;
    }

    public String getName() {
        return this.displayName;
    }

    public boolean isReadOnly() {
        return true;
    }
}

