/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.util.string;

import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.ui.util.string.StringInputElementFactory;
import com.ibm.pdtools.common.component.ui.util.string.StringStorage;
import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;

public class StringInput
implements IStorageEditorInput {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final StringStorage storage;

    public StringInput(StringStorage storage) {
        this.storage = Objects.requireNonNull(storage, "Must provide a non-null storage.");
    }

    public static StringInput create(String s, String name) {
        return new StringInput(new StringStorage(s, name));
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.storage.getName();
    }

    public IPersistableElement getPersistable() {
        return new IPersistableElement(){

            public void saveState(IMemento m) {
                Object a = StringInput.this.storage.getAdapter(String.class);
                if (a instanceof String) {
                    m.putString("name", StringInput.this.storage.getName());
                    m.putString("STR", (String)a);
                }
            }

            public String getFactoryId() {
                return StringInputElementFactory.class.getName();
            }
        };
    }

    public IStorage getStorage() {
        return this.storage;
    }

    public String getToolTipText() {
        return MessageFormat.format(Messages.StringInput_0, this.storage.getName());
    }

    public Object getAdapter(Class adapter) {
        return null;
    }
}

