/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.util;

import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.PDFileUtils;
import com.ibm.pdtools.common.component.core.util.PDXMLMementoUtils;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public enum XMLMementoUtils {
    INSTANCE;

    private static final PDLogger logger;

    static {
        logger = PDLogger.get(XMLMementoUtils.class);
    }

    public static boolean sameMementoToFileShowErrors(XMLMemento memento, File file) {
        try {
            XMLMementoUtils.saveXMLMementoToFile(memento, file);
            return true;
        }
        catch (IOException e) {
            PDDialogs.openErrorThreadSafe(Messages.XMLMementoUtils_0, MessageFormat.format("{0} {1}", e.getCause(), e.getMessage()));
            return false;
        }
    }

    public static void saveXMLMementoToFile(XMLMemento memento, File file) throws IOException {
        Objects.requireNonNull(memento, "Must provide a non-null memento.");
        Objects.requireNonNull(file, "Must provide a non-null file.");
        StringWriter sw = new StringWriter();
        try {
            memento.save((Writer)sw);
            PDFileUtils.writeFile((File)file, (StringWriter)sw);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
            throw e;
        }
    }

    public static XMLMemento loadMementoFromFileShowErrors(File file) {
        try {
            return PDXMLMementoUtils.loadMementoFromFile((File)file);
        }
        catch (Exception e) {
            PDDialogs.openErrorThreadSafe(MessageFormat.format(Messages.XMLMementoUtils_1, file));
            return null;
        }
    }

    @Deprecated
    public static XMLMemento loadMementoFromFile(File file) throws WorkbenchException, IOException {
        return PDXMLMementoUtils.loadMementoFromFile((File)file);
    }
}

