/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.util;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class SelectionProviderMediator<T extends Viewer>
implements IPostSelectionProvider {
    private List<T> fViewers;
    private T fViewerInFocus;
    private ListenerList<ISelectionChangedListener> fSelectionChangedListeners;
    private ListenerList<ISelectionChangedListener> fPostSelectionChangedListeners;

    public SelectionProviderMediator(T viewerInFocus, List<T> viewers) {
        Assert.isNotNull(viewers);
        this.fViewers = viewers;
        InternalListener listener = new InternalListener();
        this.fSelectionChangedListeners = new ListenerList();
        this.fPostSelectionChangedListeners = new ListenerList();
        this.fViewerInFocus = viewerInFocus;
        for (Viewer viewer : this.fViewers) {
            viewer.addSelectionChangedListener((ISelectionChangedListener)listener);
            ((IPostSelectionProvider)viewer).addPostSelectionChangedListener((ISelectionChangedListener)new InternalPostSelectionListener());
            Control control = viewer.getControl();
            control.addFocusListener((FocusListener)listener);
        }
    }

    private void doFocusChanged(Widget control) {
        for (Viewer fViewer : this.fViewers) {
            if (fViewer.getControl() != control) continue;
            this.propagateFocusChanged(fViewer);
            return;
        }
    }

    final void doPostSelectionChanged(SelectionChangedEvent event) {
        ISelectionProvider provider = event.getSelectionProvider();
        if (provider == this.fViewerInFocus) {
            this.firePostSelectionChanged();
        }
    }

    final void doSelectionChanged(SelectionChangedEvent event) {
        ISelectionProvider provider = event.getSelectionProvider();
        if (provider == this.fViewerInFocus) {
            this.fireSelectionChanged();
        }
    }

    final void propagateFocusChanged(T viewer) {
        if (viewer != this.fViewerInFocus) {
            this.fViewerInFocus = viewer;
            this.fireSelectionChanged();
            this.firePostSelectionChanged();
        }
    }

    private void fireSelectionChanged() {
        if (this.fSelectionChangedListeners != null) {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
            Object[] objectArray = this.fSelectionChangedListeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((ISelectionChangedListener)listener).selectionChanged(event);
                ++n2;
            }
        }
    }

    private void firePostSelectionChanged() {
        if (this.fPostSelectionChangedListeners != null) {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
            Object[] objectArray = this.fPostSelectionChangedListeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((ISelectionChangedListener)listener).selectionChanged(event);
                ++n2;
            }
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionChangedListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionChangedListeners.remove((Object)listener);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.fPostSelectionChangedListeners.add((Object)listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.fPostSelectionChangedListeners.remove((Object)listener);
    }

    public ISelection getSelection() {
        if (this.fViewerInFocus != null) {
            return this.fViewerInFocus.getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void setSelection(ISelection selection) {
        if (this.fViewerInFocus != null) {
            this.fViewerInFocus.setSelection(selection);
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
        if (this.fViewerInFocus != null) {
            this.fViewerInFocus.setSelection(selection, reveal);
        }
    }

    public T getViewerInFocus() {
        return this.fViewerInFocus;
    }

    private class InternalListener
    implements ISelectionChangedListener,
    FocusListener {
        private InternalListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            SelectionProviderMediator.this.doSelectionChanged(event);
        }

        public void focusGained(FocusEvent e) {
            SelectionProviderMediator.this.doFocusChanged(e.widget);
        }

        public void focusLost(FocusEvent e) {
        }
    }

    private class InternalPostSelectionListener
    implements ISelectionChangedListener {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        private InternalPostSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            SelectionProviderMediator.this.doPostSelectionChanged(event);
        }
    }
}

