/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.util;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class PDEditorManagement {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(PDEditorManagement.class);

    public static void openEditorFromWorkerThread(final IFile file, final IHowIsGoing monitor) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    file.refreshLocal(1, (IProgressMonitor)(monitor == null ? new NullProgressMonitor() : (IProgressMonitor)monitor.getMonitor()));
                    String editorID = "org.eclipse.ui.DefaultTextEditor";
                    IEditorDescriptor descriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
                    if (descriptor != null) {
                        editorID = descriptor.getId();
                    }
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(file), editorID);
                }
                catch (Exception e) {
                    logger.error((Object)"An error occurred while opening an editor. See log.", (Throwable)e);
                }
            }
        });
    }

    @Deprecated
    public static void openEditorFromWorkerThread(IFile file, IProgressMonitor monitor) {
        PDEditorManagement.openEditorFromWorkerThread(file, PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor));
    }
}

