/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.util;

import java.io.File;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ImageLoader {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private ImageRegistry imageRegistry = new ImageRegistry();
    private static final String DEFAULT_IMG_DIR = File.separator + "icons" + File.separator;
    private static final String DEFAULT_IMG_EXT = ".gif";
    private final String imgDir;
    private final String imgExt;
    private Image defaultImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");

    public ImageLoader() {
        this(null, null);
    }

    public ImageLoader(String imgDir) {
        this(imgDir, null);
    }

    public ImageLoader(String imgDir, String imgExt) {
        if (imgDir == null) {
            imgDir = DEFAULT_IMG_DIR;
        }
        if (imgExt == null) {
            imgExt = DEFAULT_IMG_EXT;
        }
        this.imgDir = imgDir;
        this.imgExt = imgExt;
    }

    public synchronized void setDefaultImage(Image defaultImage) {
        this.defaultImage = defaultImage;
    }

    public synchronized Image getImageByName(String pluginId, String imageName) {
        if (imageName == null) {
            return null;
        }
        if (pluginId == null) {
            throw new IllegalArgumentException("Must provide non-null pluginId.");
        }
        this.getImageDescriptor(pluginId, imageName);
        Image image = this.imageRegistry.get(imageName);
        if (image == null && (image = PlatformUI.getWorkbench().getSharedImages().getImage(imageName)) == null) {
            image = this.defaultImage;
        }
        return image;
    }

    public synchronized ImageDescriptor getImageDescriptor(String pluginId, String imageName) {
        if (pluginId == null) {
            throw new IllegalArgumentException("Must provide non-null pluginId.");
        }
        ImageDescriptor descriptor = this.imageRegistry.getDescriptor(imageName);
        if (descriptor == null) {
            descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)(this.imgDir + imageName + this.imgExt));
            if (descriptor == null && (descriptor = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(imageName)) == null) {
                String[] imgDirs;
                String[] stringArray = imgDirs = new String[]{"icons" + File.separator + "tree" + File.separator, "icons" + File.separator + "menus" + File.separator, "icons" + File.separator + "decorations" + File.separator, "icons" + File.separator};
                int n = imgDirs.length;
                int n2 = 0;
                while (n2 < n) {
                    String aImgDir = stringArray[n2];
                    if (!aImgDir.equalsIgnoreCase(this.imgDir) && (descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)(aImgDir + imageName + this.imgExt))) != null) break;
                    ++n2;
                }
            }
            if (descriptor != null) {
                this.imageRegistry.put(imageName, descriptor);
            }
        }
        return descriptor;
    }

    public synchronized void clearCache() {
        this.imageRegistry.dispose();
        this.imageRegistry = new ImageRegistry();
    }

    public synchronized void dispose() {
        this.imageRegistry.dispose();
    }
}

