/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.util;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.AbstractContributionFactory;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.services.ISourceProviderService;

public abstract class EclipseUtils {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    public static <E> E getService(Class<E> serviceClass) {
        try {
            return serviceClass.cast(PlatformUI.getWorkbench().getService(serviceClass));
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public static <E> E getServiceChecked(Class<E> serviceClass) throws NullPointerException {
        return Objects.requireNonNull(EclipseUtils.getService(serviceClass), "Couldn't get " + ICommandService.class.getCanonicalName());
    }

    public static void retestEclipseProperty(String namespace, String propertyName) throws NullPointerException {
        String property = MessageFormat.format("{0}.{1}", Objects.requireNonNull(namespace, "Must provide non-null namespace."), Objects.requireNonNull(propertyName, "Must provide non-null namespace."));
        Objects.requireNonNull(property);
        EclipseUtils.getServiceChecked(IEvaluationService.class).requestEvaluation(property);
    }

    public static void refreshSourceProviderVariable(String variableName) throws NullPointerException {
        Objects.requireNonNull(variableName, "Must specify a non-null variableName.");
        ISourceProvider provider = EclipseUtils.getServiceChecked(ISourceProviderService.class).getSourceProvider(variableName);
        if (provider == null) {
            throw new IllegalArgumentException(variableName + " - [Provider does not exist.]");
        }
        if (!(provider instanceof IRefreshableSourceProvider)) {
            throw new IllegalArgumentException(variableName + " - [" + String.valueOf(provider) + "]");
        }
        ((IRefreshableSourceProvider)provider).refreshAllVariables();
    }

    public static Object getVariableValue(String variableName) throws NullPointerException {
        Objects.requireNonNull(variableName, "Must specify a non-null variableName.");
        ISourceProvider sourceProvider = EclipseUtils.getServiceChecked(ISourceProviderService.class).getSourceProvider(variableName);
        Objects.requireNonNull(sourceProvider, "Source " + variableName + " doesn't exist.");
        return sourceProvider.getCurrentState().get(variableName);
    }

    public static void addMenuContributionFactory(AbstractContributionFactory factory) throws NullPointerException {
        EclipseUtils.getServiceChecked(IMenuService.class).addContributionFactory(Objects.requireNonNull(factory, "Must specify a non-null factory."));
    }

    public static boolean isCommandEnabled(String commandId) throws NullPointerException {
        return EclipseUtils.getServiceChecked(ICommandService.class).getCommand(Objects.requireNonNull(commandId, "Must specify a non-null commandId.")).isEnabled();
    }

    public static Object executeParameterizedCommand(String commandID, Map<String, String> parameters) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException, NullPointerException {
        Objects.requireNonNull(commandID, "Must provide a non-null commandID.");
        Objects.requireNonNull(parameters, "Must provide a non-null parameters map ( it can be empty if needed).");
        Command c = EclipseUtils.getServiceChecked(ICommandService.class).getCommand(commandID);
        List<IParameter> possibleParameters = Arrays.asList(c.getParameters());
        ArrayList<Parameterization> parametersList = new ArrayList<Parameterization>();
        for (Map.Entry<String, String> e : parameters.entrySet()) {
            if (e.getKey() == null) continue;
            boolean validParameter = false;
            for (IParameter p : possibleParameters) {
                if (!p.getId().equals(e.getKey())) continue;
                parametersList.add(new Parameterization(c.getParameter(e.getKey()), e.getValue()));
                validParameter = true;
            }
            if (validParameter) continue;
            PDLogger.get(EclipseUtils.class).error((Object)MessageFormat.format("Command: {0} has parameters: {1}. The supplied parameter: {2} with value {3} doesn''t exist.", commandID, possibleParameters, e.getKey() == null ? "null" : e.getKey(), e.getValue() == null ? "null" : e.getValue()));
        }
        for (IParameter p : possibleParameters) {
            if (p == null || p.isOptional()) continue;
            boolean specified = false;
            for (Parameterization param : parametersList) {
                if (!p.equals(param.getParameter())) continue;
                specified = true;
                if (param == null || param.getValue() != null) continue;
                PDLogger.get(EclipseUtils.class).trace((Object)MessageFormat.format("For command: {0}Required parameter: ''{1}'' was null. parameters were: {2}", commandID, p.getId(), parameters));
            }
            if (specified) continue;
            PDLogger.get(EclipseUtils.class).warn((Object)MessageFormat.format("For command: {0}Required parameter: ''{1}'' was not specifed. parameters were: {2}", commandID, p.getId(), parameters));
        }
        return EclipseUtils.getServiceChecked(IHandlerService.class).executeCommand(new ParameterizedCommand(c, parametersList.toArray(new Parameterization[0])), null);
    }

    public static Command getCommand(String commandId) {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command2 = commandService.getCommand(commandId);
        return command2;
    }

    public static interface IRefreshableSourceProvider
    extends ISourceProvider {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        public void refreshAllVariables();
    }
}

