/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.util;

import com.ibm.pdtools.common.component.ui.util.PDSafeUIRunner;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Control;

public class ControlHelpers {
    private static <T extends Control> Runnable getNotDisposedRunner(final T control, final Runnable r) {
        return new Runnable(){

            @Override
            public void run() {
                if (r != null && control != null && !control.isDisposed()) {
                    r.run();
                }
            }
        };
    }

    private static <T extends Control> void runIfNotDisposedSync(T control, Runnable callback) {
        PDSafeUIRunner.syncExec(ControlHelpers.getNotDisposedRunner(control, callback));
    }

    private static <T extends Control> void runIfNotDisposedAsync(T c, Runnable r) {
        PDSafeUIRunner.asyncExec(ControlHelpers.getNotDisposedRunner(c, r));
    }

    public static <T extends Control> void setVisible(final T c, final boolean visible) {
        ControlHelpers.runIfNotDisposedSync(c, new Runnable(){

            @Override
            public void run() {
                c.setVisible(visible);
            }
        });
    }

    public static <T extends Control> void setVisibleAsync(final T c, final boolean visible) {
        ControlHelpers.runIfNotDisposedAsync(c, new Runnable(){

            @Override
            public void run() {
                c.setVisible(visible);
            }
        });
    }

    public static void setTextAsync(final Browser browser, final String text2) {
        ControlHelpers.runIfNotDisposedAsync(browser, new Runnable(){

            @Override
            public void run() {
                browser.setText(text2);
            }
        });
    }

    public static void setUrlSync(final Browser browser, final String url) {
        ControlHelpers.runIfNotDisposedSync(browser, new Runnable(){

            @Override
            public void run() {
                browser.setUrl(url);
            }
        });
    }
}

