/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.util;

import com.ibm.pdtools.common.component.jhost.IAuthTokenManager;
import com.ibm.pdtools.common.component.jhost.Messages;
import com.ibm.pdtools.common.component.jhost.comms.HostDetails;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.swt.widgets.Display;

public class AuthTokenManager
implements IAuthTokenManager {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2019. All rights reserved.";
    private static final AuthTokenManager instance = new AuthTokenManager();
    private final ConcurrentHashMap<ConnectionUser, String> authMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<ConnectionUser, Long> handshakingList = new ConcurrentHashMap();
    private final List<ConnectionPort> connectionIdsUsingTokens = Collections.synchronizedList(new ArrayList());

    private AuthTokenManager() {
    }

    public static AuthTokenManager getInstance() {
        return instance;
    }

    public void setConnectionIdUsingTokens(String host, Integer port) {
        ConnectionPort cp = new ConnectionPort(host, port);
        this.connectionIdsUsingTokens.remove(cp);
        this.connectionIdsUsingTokens.add(cp);
    }

    public boolean isConnectionUsingTokens(String host, Integer port) {
        ConnectionPort cp = new ConnectionPort(host, port);
        return this.connectionIdsUsingTokens.contains(cp);
    }

    public boolean isHandshaking(HostDetails hostDetails, String userName) {
        ConnectionUser user = new ConnectionUser(hostDetails.getHostID(), userName);
        return this.handshakingList.containsKey(user);
    }

    private boolean waiting(ConnectionUser user) {
        return this.handshakingList.containsKey(user);
    }

    public void removeHostTokens(String hostId) {
        ArrayList<ConnectionUser> toRemove = new ArrayList<ConnectionUser>();
        for (ConnectionUser user : this.authMap.keySet()) {
            if (!user.getConnectionName().equals(hostId)) continue;
            toRemove.add(user);
        }
        for (ConnectionUser user : toRemove) {
            this.authMap.remove(user);
        }
    }

    public String getAuthToken(HostDetails hostDetails, String userName, IHowIsGoing monitor) throws InterruptedException {
        ConnectionUser user = new ConnectionUser(hostDetails.getHostID(), userName);
        String result = this.authMap.get(user);
        if (result != null) {
            return result;
        }
        return this.authMap.get(user);
    }

    public boolean hasAuthToken(HostDetails hostDetails, String userName, IHowIsGoing monitor) throws InterruptedException {
        ConnectionUser user = new ConnectionUser(hostDetails.getHostID(), userName);
        return this.authMap.containsKey(user);
    }

    public void setAuthToken(HostDetails hostDetails, String userName, String token) {
        ConnectionUser user = new ConnectionUser(hostDetails.getHostID(), userName);
        this.authMap.put(user, token);
    }

    public void removeAuthToken(HostDetails hostDetails, String userName) {
        this.endHandshake(hostDetails, userName);
        ConnectionUser user = new ConnectionUser(hostDetails.getHostID(), userName);
        this.authMap.remove(user);
    }

    public void startHandshake(HostDetails hostDetails, String userName, IHowIsGoing monitor) throws InterruptedException {
        ConnectionUser user = new ConnectionUser(hostDetails.getHostID(), userName);
        Display display = Display.getDefault();
        while (this.waiting(user)) {
            if (display.getThread() == Thread.currentThread()) {
                if (monitor != null && monitor.isCanceled()) {
                    throw new InterruptedException(Messages.NonBlockingSocketIOJhost_Cancelled);
                }
                if (display.readAndDispatch()) continue;
                display.sleep();
                continue;
            }
            Thread.sleep(5L);
        }
        this.handshakingList.put(user, Thread.currentThread().getId());
    }

    public void endHandshake(HostDetails hostDetails, String userName) {
        ConnectionUser user = new ConnectionUser(hostDetails.getHostID(), userName);
        this.handshakingList.remove(user);
    }

    private static class ConnectionPort {
        private String host;
        private Integer port;

        public ConnectionPort(String host, Integer port) {
            this.host = host;
            this.port = port;
        }

        public int hashCode() {
            return Objects.hash(this.host, this.port);
        }

        public boolean equals(Object obj) {
            return this.hashCode() == obj.hashCode();
        }
    }

    private static class ConnectionUser {
        private String connectionName;
        private String userName;

        public ConnectionUser(String connectionName, String userName) {
            this.connectionName = connectionName;
            this.userName = userName;
            if (this.userName != null) {
                this.userName = this.userName.toUpperCase();
            }
        }

        public int hashCode() {
            return Objects.hash(this.connectionName, this.userName);
        }

        public boolean equals(Object obj) {
            return this.hashCode() == obj.hashCode();
        }

        public String getConnectionName() {
            return this.connectionName;
        }
    }
}

