/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.prefs;

import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.core.PDTCCcore;
import com.ibm.pdtools.common.component.core.comms.ConnectionUtilities;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.PDToolsCommonServerClientJhost;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.comms.HostDetails;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.prefs.CertificateInformation;
import com.ibm.pdtools.common.component.jhost.prefs.PDCommonPreferencePageJhost;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.PDTCCui;
import com.ibm.pdtools.common.component.ui.logging.action.ClearLog;
import com.ibm.pdtools.common.component.ui.logging.action.ViewLog;
import com.ibm.pdtools.common.component.ui.prefs.CertificateViewerDialog;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.util.PDSafeUIRunner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PDCommonPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static BooleanFieldEditor debugMode;
    private static BooleanFieldEditor reportIncompatibleVersion;
    private static Group localPortGroup;
    private static BooleanFieldEditor specifyLocalPort;
    private static IntegerFieldEditor localPortMin;
    private static IntegerFieldEditor localPortMax;
    public static final String CERTIFICATE_VIEW_BUTTON = "icons/view.gif";
    public static final String CERTIFICATE_DELETE_BUTTON = "icons/delete.gif";
    public static final String CHECK_CONNECTION_BUTTON = "icons/check.gif";
    private Table certificateTable = null;
    private TableViewer certificateTableViewer = null;
    private Button viewCertButton = null;
    private Button deleteCertButton = null;
    private List<CertificateInformation> certificatesToDelete = new ArrayList<CertificateInformation>();
    private static ICommonPreferencePage commonPreferencePageObserver;

    static {
        commonPreferencePageObserver = null;
    }

    public static boolean getDebugMode() {
        boolean temp = PDTCCcore.getDefault().getPreferenceStore().getBoolean("ipv.debug");
        PDCommonPreferencePageJhost.setDebugMode((boolean)temp);
        return temp;
    }

    public static boolean isReportingVersionIncompatibleProblems() {
        boolean temp = PDTCCcore.getDefault().getPreferenceStore().getBoolean("ipv.version.mismatch");
        PDCommonPreferencePageJhost.setReportVersionIncompatibleProblems((boolean)temp);
        return temp;
    }

    public static void setReportVersionIncompatibleProblems(boolean value) {
        PDTCCcore.getDefault().getPreferenceStore().setValue("ipv.version.mismatch", value);
        PDCommonPreferencePageJhost.setReportVersionIncompatibleProblems((boolean)value);
    }

    public static boolean specifyLocalPortRange() {
        boolean temp = PDTCCcore.getDefault().getPreferenceStore().getBoolean("ipv.specify.local.port");
        PDCommonPreferencePageJhost.setSpecifyLocalPort((boolean)temp);
        return temp;
    }

    public static synchronized int getCurrentLocalPortNumber() {
        int port = PDCommonPreferencePageJhost.currentLocalPort++;
        if (PDCommonPreferencePageJhost.currentLocalPort > PDCommonPreferencePage.getLocalPortMax()) {
            PDCommonPreferencePageJhost.currentLocalPort = PDCommonPreferencePage.getLocalPortMin();
        }
        return port;
    }

    public static int getLocalPortMin() {
        int storedVal = PDTCCcore.getDefault().getPreferenceStore().getInt("fm.local.port.min");
        storedVal = storedVal == 0 ? 5000 : storedVal;
        PDCommonPreferencePageJhost.setLocalPortMin((int)storedVal);
        return storedVal;
    }

    public static int getLocalPortMax() {
        int storedVal = PDTCCcore.getDefault().getPreferenceStore().getInt("fm.local.port.max");
        storedVal = storedVal == 0 ? 6000 : storedVal;
        PDCommonPreferencePageJhost.setLocalPortMax((int)storedVal);
        return storedVal;
    }

    public PDCommonPreferencePage() {
        super(Messages.PDCommonPreferencePage_COMPONENT_NAME, 1);
        this.setPreferenceStore(PDTCCcore.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        Composite composite = GUI.composite((Composite)this.getFieldEditorParent(), (Layout)GUI.grid.l.margins((int)1, (boolean)true), (Object)GUI.grid.d.fillAll());
        GUI.label.left((Composite)composite, (String)Messages.PDCommonPreferencePage_MAIN_DESC, (Object)GUI.grid.d.left1());
        Group probGroup = GUI.group((Composite)composite, (String)Messages.PDCommonPreferencePage_2, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        debugMode = new BooleanFieldEditor("ipv.debug", Messages.PDCommonPreferencePage_DEBUG_PROMPT, (Composite)probGroup);
        this.addField((FieldEditor)debugMode);
        reportIncompatibleVersion = new BooleanFieldEditor("ipv.version.mismatch", Messages.PDCommonPreferencePage_REPORT_VER_ERR, (Composite)probGroup);
        this.addField((FieldEditor)reportIncompatibleVersion);
        this.connectionCheckComposite((Composite)probGroup);
        PDCommonPreferencePage.logComposite((Composite)probGroup);
        this.createLocalPortGroup(composite);
        this.createCertificateGroup(composite);
    }

    private void connectionCheckComposite(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)composite, (String)Messages.PDCommonPreferencePage_0, (Object)GUI.grid.d.left1());
        final ComboViewer hostComboViewer = new ComboViewer(GUI.combo((Composite)composite, (Object)GUI.grid.d.fillH((int)1), (int)8));
        hostComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element != null && element instanceof HostDetails) {
                    return ((HostDetails)element).getConnectionName();
                }
                return super.getText(element);
            }
        });
        hostComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        Collection hosts = ConnectionUtilities.getSystemInformation();
        hostComboViewer.setInput((Object)hosts);
        Button checkButton = GUI.button.push((Composite)composite, (Image)PDTCCui.getDefault().getImageRegistry().get(CHECK_CONNECTION_BUTTON), (String)Messages.PDCommonPreferencePage_1, (Object)GUI.grid.d.left1());
        checkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object o;
                StructuredSelection selection = (StructuredSelection)hostComboViewer.getSelection();
                if (!selection.isEmpty() && (o = selection.getFirstElement()) instanceof HostDetails) {
                    PDCommonPreferencePage.checkConnectionForHost((HostDetails)o, new Runnable(){

                        @Override
                        public void run() {
                            if (!(this).PDCommonPreferencePage.this.certificateTableViewer.getTable().isDisposed()) {
                                (this).PDCommonPreferencePage.this.certificateTableViewer.setInput((Object)PDToolsCommonServerClientJhost.getDefault().getKnownCertificates());
                                if ((this).PDCommonPreferencePage.this.certificateTable.getItemCount() > 0) {
                                    (this).PDCommonPreferencePage.this.certificateTable.select(0);
                                }
                            }
                        }
                    });
                }
            }
        });
        if (!hosts.isEmpty()) {
            hostComboViewer.setSelection((ISelection)new StructuredSelection(hosts.iterator().next()));
        } else {
            hostComboViewer.getCombo().setEnabled(false);
            checkButton.setEnabled(false);
        }
    }

    public static void checkConnectionForHost(final HostDetails selected, final Runnable onComplete) {
        final AtomicReference resultRef = new AtomicReference();
        Job check = new Job(Messages.PDCommonPreferencePage_CheckingHost){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.PDCommonPreferencePage_6, -1);
                monitor.worked(1);
                try {
                    Result result = ConnectionUtilities.checkConnection2((HostDetails)selected, (IHowIsGoing)PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor));
                    resultRef.set(result);
                    if (result.getRC() == 0) {
                        return Status.OK_STATUS;
                    }
                    return new Status(4, "com.ibm.pdtools.common.component.ui", result.getMessagesCombined().toString(), (Throwable)new CommunicationException(((StringBuilder)result.getOutput()).toString()));
                }
                catch (InterruptedException e) {
                    return Status.CANCEL_STATUS;
                }
            }
        };
        check.setUser(true);
        check.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Result result = (Result)resultRef.get();
                if (event.getResult().isOK()) {
                    String output = ((StringBuilder)result.getOutput()).toString().replaceAll("\r?\n", "\n");
                    PDDialogs.openInfoThreadSafe(Messages.Information, result.getMessagesCombined().toString(), output);
                }
                if (onComplete != null) {
                    PDSafeUIRunner.asyncExec(onComplete);
                }
            }
        });
        check.schedule();
    }

    private static void logComposite(Composite parent) {
        Composite buttonsComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)2, (boolean)true), (Object)GUI.grid.d.left1());
        Button viewLogButton = GUI.button.push((Composite)buttonsComposite, (String)Messages.PDCommonPreferencePage_ViewLog, (Object)GUI.grid.d.fillH((int)1));
        viewLogButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewLog.view();
            }
        });
        Button clearLogButton = GUI.button.push((Composite)buttonsComposite, (String)Messages.PDCommonPreferencePage_ClearLog, (Object)GUI.grid.d.fillH((int)1));
        clearLogButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClearLog.clear();
            }
        });
    }

    private void createLocalPortGroup(Composite parent) {
        localPortGroup = new Group(parent, 0);
        localPortGroup.setText(Messages.PDCommonPreferencePage_LOCAL_PORT_GROUP);
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        localPortGroup.setLayoutData((Object)gd);
        specifyLocalPort = new BooleanFieldEditor("ipv.specify.local.port", Messages.PDCommonPreferencePage_3, (Composite)localPortGroup);
        this.addField((FieldEditor)specifyLocalPort);
        Control aControl = specifyLocalPort.getDescriptionControl((Composite)localPortGroup);
        if (aControl instanceof Button) {
            final Button aButton = (Button)aControl;
            aButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    localPortMin.getTextControl((Composite)localPortGroup).setEnabled(aButton.getSelection());
                    localPortMax.getTextControl((Composite)localPortGroup).setEnabled(aButton.getSelection());
                    PDTCCcore.getDefault().getPreferenceStore().setValue("ipv.specify.local.port", aButton.getSelection());
                }
            });
        }
        localPortMin = new IntegerFieldEditor("fm.local.port.min", Messages.PDCommonPreferencePage_LOCAL_PORT_MIN, (Composite)localPortGroup);
        localPortMin.setValidRange(1, 65535);
        localPortMin.setEmptyStringAllowed(false);
        this.addField((FieldEditor)localPortMin);
        localPortMin.getTextControl((Composite)localPortGroup).setEnabled(PDCommonPreferencePage.specifyLocalPortRange());
        localPortMax = new IntegerFieldEditor("fm.local.port.max", Messages.PDCommonPreferencePage_LOCAL_PORT_MAX, (Composite)localPortGroup);
        localPortMax.setValidRange(1, 65535);
        localPortMax.setEmptyStringAllowed(false);
        this.addField((FieldEditor)localPortMax);
        localPortMax.getTextControl((Composite)localPortGroup).setEnabled(PDCommonPreferencePage.specifyLocalPortRange());
    }

    private void createCertificateGroup(Composite parent) {
        Group group = GUI.group((Composite)parent, (String)Messages.PDCommonPreferencePage_CERTIFICATES_GROUP, (Layout)GUI.grid.l.noMargins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.createCertificateTableComposite(group);
        this.createCertificateButtonsComposite(group);
    }

    private void createCertificateButtonsComposite(Group group) {
        Composite composite = GUI.composite((Composite)group, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.left1());
        this.viewCertButton = GUI.button.push((Composite)composite, (Image)PDTCCui.getDefault().getImageRegistry().get(CERTIFICATE_VIEW_BUTTON), (String)Messages.PDCommonPreferencePage_4, (Object)GUI.grid.d.left1());
        this.viewCertButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)PDCommonPreferencePage.this.certificateTableViewer.getSelection();
                Iterator iterator = selection.iterator();
                while (iterator.hasNext()) {
                    new CertificateViewerDialog((CertificateInformation)iterator.next(), true).open();
                }
            }
        });
        this.deleteCertButton = GUI.button.push((Composite)composite, (Image)PDTCCui.getDefault().getImageRegistry().get(CERTIFICATE_DELETE_BUTTON), (String)Messages.PDCommonPreferencePage_5, (Object)GUI.grid.d.left1());
        this.deleteCertButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PDCommonPreferencePage.this.handleCertificateDelete();
            }
        });
    }

    private void handleCertificateDelete() {
        IStructuredSelection selection = (IStructuredSelection)this.certificateTableViewer.getSelection();
        for (CertificateInformation cert : selection) {
            this.certificatesToDelete.add(cert);
        }
        ArrayList knownCertificates = new ArrayList(PDToolsCommonServerClientJhost.getDefault().getKnownCertificates());
        knownCertificates.removeAll(this.certificatesToDelete);
        this.certificateTableViewer.setInput(knownCertificates);
    }

    private void createCertificateTableComposite(Group group) {
        GridData tableGridData = GUI.grid.d.fillAll();
        tableGridData.heightHint = 200;
        Composite composite = GUI.composite((Composite)group, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)tableGridData);
        this.certificateTable = new Table(composite, 68354);
        this.certificateTable.setHeaderVisible(true);
        this.certificateTable.setLinesVisible(true);
        this.certificateTable.setFont(JFaceResources.getTextFont());
        this.certificateTableViewer = new TableViewer(this.certificateTable);
        PDCommonPreferencePage.createColumns(this.certificateTableViewer);
        this.certificateTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.certificateTable.setLayoutData((Object)GUI.grid.d.fillAll());
        this.certificateTableViewer.setInput((Object)PDToolsCommonServerClientJhost.getDefault().getKnownCertificates());
        if (this.certificateTable.getItemCount() > 0) {
            this.certificateTable.select(0);
        }
        this.certificateTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent arg0) {
                new CertificateViewerDialog((CertificateInformation)((StructuredSelection)PDCommonPreferencePage.this.certificateTableViewer.getSelection()).getFirstElement(), true).open();
            }
        });
        this.certificateTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (127 == e.keyCode) {
                    PDCommonPreferencePage.this.handleCertificateDelete();
                }
            }
        });
    }

    private static void createColumns(TableViewer viewer) {
        TableViewerColumn issuerColumn = PDCommonPreferencePage.createTableViewerColumn(Messages.PDCommonPreferencePage_CERTIFICATE_ISSUER, 200, viewer, 16384);
        issuerColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                if (cell.getElement() instanceof CertificateInformation) {
                    CertificateInformation new_name = (CertificateInformation)cell.getElement();
                    cell.setText(new_name.getIssuerDetails());
                }
            }
        });
        TableViewerColumn validFromColumn = PDCommonPreferencePage.createTableViewerColumn(Messages.PDCommonPreferencePage_CERTIFICATE_VALID_FROM, 100, viewer, 16384);
        validFromColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                if (cell.getElement() instanceof CertificateInformation) {
                    CertificateInformation new_name = (CertificateInformation)cell.getElement();
                    cell.setText(new_name.getValidFromDate());
                }
            }
        });
        TableViewerColumn validToColumn = PDCommonPreferencePage.createTableViewerColumn(Messages.PDCommonPreferencePage_CERTIFICATE_VALID_TO, 100, viewer, 16384);
        validToColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                if (cell.getElement() instanceof CertificateInformation) {
                    CertificateInformation new_name = (CertificateInformation)cell.getElement();
                    cell.setText(new_name.getValidToDate());
                }
            }
        });
    }

    private static TableViewerColumn createTableViewerColumn(String title, int bound, TableViewer viewer, int alignment) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        column.setAlignment(alignment);
        return viewerColumn;
    }

    public void init(IWorkbench arg0) {
    }

    public boolean performOk() {
        if (!this.certificatesToDelete.isEmpty()) {
            for (CertificateInformation ce : this.certificatesToDelete) {
                PDToolsCommonServerClientJhost.getDefault().removeCertificate(ce);
            }
        }
        if (PDCommonPreferencePage.specifyLocalPortRange()) {
            int maxValue;
            int minValue = localPortMin.getIntValue();
            if (minValue >= (maxValue = localPortMax.getIntValue())) {
                this.setErrorMessage(Messages.PDCommonPreferencePage_PORT_MIN_SMALLER);
                localPortMin.setFocus();
                return false;
            }
            this.setErrorMessage(null);
            PDCommonPreferencePageJhost.currentLocalPort = minValue;
        }
        PDLogger.enableLogging((boolean)PDCommonPreferencePage.getDebugMode());
        boolean retValue = super.performOk();
        if (commonPreferencePageObserver != null) {
            commonPreferencePageObserver.okay();
        }
        return retValue;
    }

    protected void performDefaults() {
        super.performDefaults();
        localPortMin.getTextControl((Composite)localPortGroup).setEnabled(false);
        localPortMax.getTextControl((Composite)localPortGroup).setEnabled(false);
        this.certificatesToDelete.clear();
        this.certificateTableViewer.setInput((Object)PDToolsCommonServerClientJhost.getDefault().getKnownCertificates());
    }

    public static void setCommonPreferencePageObserver(ICommonPreferencePage commonPreferencePageObserver) {
        PDCommonPreferencePage.commonPreferencePageObserver = commonPreferencePageObserver;
    }

    public static interface ICommonPreferencePage {
        public void okay();
    }
}

