/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.prefs;

import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.core.PDTCCcore;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.IHostSubSys;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.ui.prefs.PDCommonPreferencePage;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PDCommonPreferenceFeaturesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String IHOST_LEAVES_ID = "com.ibm.pdtools.common.component.ui.views.systems.nodes.leave";
    public static final int MIN_CHILDREN_SHOWN = 100;
    public static final int MAX_CHILDREN_SHOWN = 10000;
    private static PDCommonPreferencePage.ICommonPreferencePage commonPreferencePageObserver = null;

    public static int getChildrenWindowSize() {
        return PDTCCcore.getDefault().getPreferenceStore().getInt("pdtools.common.component.systemsview.childrenShown");
    }

    @Deprecated
    public static boolean getLocalHost() {
        return PDTCCcore.getDefault().getPreferenceStore().getBoolean("ipv.localhost") & PDCommonPreferenceFeaturesPage.isQuokkaEnabled();
    }

    @Deprecated
    public static boolean isQuokkaEnabled() {
        return false;
    }

    public PDCommonPreferenceFeaturesPage() {
        super(Messages.PDCommonPreferencePage_COMPONENT_NAME, 1);
        this.setPreferenceStore(PDTCCcore.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        Composite composite = this.getFieldEditorParent();
        Composite systemsInfoComposite = GUI.composite((Composite)composite, (Layout)GUI.grid.l.margins((int)1, (boolean)true), (Object)GUI.grid.d.fillAll());
        GUI.label.left((Composite)systemsInfoComposite, (String)Messages.PDCommonPreferenceFeaturesPage_1, (Object)GUI.grid.d.fillH((int)1));
        this.createLayoutGroup(systemsInfoComposite);
        this.createFeatureGroup(systemsInfoComposite);
    }

    public void createLayoutGroup(Composite parent) {
        Group layoutGroup = GUI.group((Composite)parent, (String)Messages.PDCommonPreferenceFeaturesPage_0, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        IntegerFieldEditor childrenShownFieldEditor = new IntegerFieldEditor("pdtools.common.component.systemsview.childrenShown", Messages.PDTCCuiPreferencePage_MAX_CHILDREN_PREF, (Composite)layoutGroup, Integer.toString(10000).length());
        childrenShownFieldEditor.setValidRange(100, 10000);
        Text maxChildren = childrenShownFieldEditor.getTextControl((Composite)layoutGroup);
        if (maxChildren != null && !maxChildren.isDisposed()) {
            maxChildren.setToolTipText(Messages.PDCommonPreferenceFeaturesPage_3);
        }
        this.addField((FieldEditor)childrenShownFieldEditor);
        BooleanFieldEditor saveSystemsTree = new BooleanFieldEditor("saveSystemsTree", Messages.PDCommonPreferenceFeaturesPage_2, (Composite)layoutGroup);
        Control saveTree = saveSystemsTree.getDescriptionControl((Composite)layoutGroup);
        if (saveTree != null && !saveTree.isDisposed()) {
            saveTree.setToolTipText(Messages.PDCommonPreferenceFeaturesPage_4);
        }
        this.addField((FieldEditor)saveSystemsTree);
    }

    private void createFeatureGroup(Composite parent) {
        IConfigurationElement[] hostLeaves;
        Group featureGroup = GUI.group((Composite)parent, (String)Messages.PDCommonPreferencePage_FEATURE_GROUP, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        featureGroup.setToolTipText(Messages.PDCommonPreferenceFeaturesPage_5);
        IConfigurationElement[] iConfigurationElementArray = hostLeaves = Platform.getExtensionRegistry().getConfigurationElementsFor(IHOST_LEAVES_ID);
        int n = hostLeaves.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement hostLeave = iConfigurationElementArray[n2];
            try {
                IHostSubSys subSystem;
                Object hostLeaveObj = hostLeave.createExecutableExtension("subsystem");
                if (hostLeaveObj instanceof IHostSubSys && !(subSystem = (IHostSubSys)hostLeaveObj).isQuokka()) {
                    if (subSystem.getFeaturePreference() == null) {
                        PDTCCcore.getDefault().getPreferenceStore().setDefault(subSystem.getPreferenceId(), true);
                    }
                    subSystem.setFeaturePreference(new BooleanFieldEditor(subSystem.getPreferenceId(), subSystem.getSubsysName(), (Composite)featureGroup));
                    this.addField((FieldEditor)subSystem.getFeaturePreference());
                }
            }
            catch (Exception e) {
                PDLogger.get(((Object)((Object)this)).getClass()).error((Throwable)e);
            }
            ++n2;
        }
    }

    public static boolean getFeatureMode(String preferenceId) {
        if (PDTCCcore.getDefault().getPreferenceStore().contains(preferenceId)) {
            return PDTCCcore.getDefault().getPreferenceStore().getBoolean(preferenceId);
        }
        return true;
    }

    public boolean performOk() {
        boolean retValue = super.performOk();
        if (commonPreferencePageObserver != null) {
            commonPreferencePageObserver.okay();
        }
        PDTCCcore.refreshAllOthers();
        return retValue;
    }

    public static void setCommonPreferencePageObserver(PDCommonPreferencePage.ICommonPreferencePage commonPreferencePageObserver) {
        PDCommonPreferenceFeaturesPage.commonPreferencePageObserver = commonPreferencePageObserver;
    }
}

