/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.prefs;

import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.prefs.CertificateInformation;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class CertificateViewerDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private CertificateInformation info;
    private boolean viewOnly;

    public CertificateViewerDialog(CertificateInformation info, boolean viewOnly) {
        this.info = info;
        this.viewOnly = viewOnly;
    }

    protected Composite createDialogContent(Composite parent) {
        this.setTitle(Messages.CertificateViewerDialog_Title);
        if (this.viewOnly) {
            this.setMessage("");
        } else {
            this.setMessage(Messages.CertificateViewerDialog_Message);
        }
        TabFolder tabFolder = new TabFolder(parent, 128);
        tabFolder.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 4).grab(true, true).create());
        this.createGeneralInfoTab(tabFolder);
        this.createDetailsTab(tabFolder);
        this.setComplete(true);
        return parent;
    }

    private void createGeneralInfoTab(TabFolder tabFolder) {
        TabItem generalInfoTab = new TabItem(tabFolder, 0);
        generalInfoTab.setText(Messages.CertificateViewerDialog_GeneralInfoTab);
        Composite composite = GUI.composite((Composite)tabFolder, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillAll());
        GUI.label.left((Composite)composite, (String)Messages.CertificateViewerDialog_Issuer, (Object)GUI.grid.d.left1());
        Text issuerText = GUI.text.fieldReadOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        issuerText.setText(this.info.getIssuerDetails());
        GUI.label.left((Composite)composite, (String)Messages.CertificateViewerDialog_ValidFrom, (Object)GUI.grid.d.left1());
        Text fromDateText = GUI.text.fieldReadOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        fromDateText.setText(this.info.getValidFromDate());
        GUI.label.left((Composite)composite, (String)Messages.CertificateViewerDialog_ValidTo, (Object)GUI.grid.d.left1());
        Text toDateText = GUI.text.fieldReadOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        toDateText.setText(this.info.getValidToDate());
        generalInfoTab.setControl((Control)composite);
    }

    private void createDetailsTab(TabFolder tabFolder) {
        TabItem detailsTab = new TabItem(tabFolder, 0);
        detailsTab.setText(Messages.CertificateViewerDialog_DetailsTab);
        Composite composite = GUI.composite((Composite)tabFolder, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        StyledText detailsText = new StyledText(composite, 840);
        detailsText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).align(4, 4).hint(300, 300).create());
        detailsText.setText(this.info.getCertificateDetails());
        detailsTab.setControl((Control)composite);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridData data = new GridData();
        data.widthHint = 100;
        if (this.viewOnly) {
            Button okButton = GUI.button.push((Composite)parent, (String)JFaceResources.getString((String)"ok"), (Object)data);
            okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CertificateViewerDialog.this.okPressed();
                }
            });
            this.getShell().setDefaultButton(okButton);
        } else {
            Button okButton = GUI.button.push((Composite)parent, (String)JFaceResources.getString((String)"yes"), (Object)data);
            okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CertificateViewerDialog.this.okPressed();
                }
            });
            Button cancelButton = GUI.button.push((Composite)parent, (String)JFaceResources.getString((String)"no"), (Object)data);
            cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CertificateViewerDialog.this.cancelPressed();
                }
            });
            this.getShell().setDefaultButton(okButton);
        }
    }
}

