/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.dialog.lookup;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PatternState {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String WILDCARD = "*";
    private final List<String> patternList = new ArrayList<String>();

    public String[] getPatternList() {
        return this.patternList.toArray(new String[0]);
    }

    public PatternState(String[] patterns) {
        this.setPatternList(patterns);
    }

    private void setPatternList(String[] patterns) throws NullPointerException {
        String[] stringArray = Objects.requireNonNull(patterns, "Please provide a non-null pattern.");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            this.patternList.add(pattern + WILDCARD);
            ++n2;
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof PatternState) {
            PatternState ps = (PatternState)o;
            if (ps.patternList.size() != this.patternList.size()) {
                return false;
            }
            int i = 0;
            while (i < this.patternList.size()) {
                if (!this.patternList.get(i).equals(ps.patternList.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 37;
        for (String pattern : this.patternList) {
            hash = hash * 37 + pattern.hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String pattern : this.patternList) {
            sb.append(MessageFormat.format("Pattern {0}: {1} ", this.patternList.indexOf(pattern), pattern));
        }
        return sb.toString();
    }
}

