/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.dialog.lookup;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.util.ByteStringComparator;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import com.ibm.pdtools.common.component.ui.dialog.lookup.LoadingContentProvider;
import com.ibm.pdtools.common.component.ui.dialog.lookup.Messages;
import com.ibm.pdtools.common.component.ui.dialog.lookup.PatternState;
import com.ibm.pdtools.common.component.ui.util.ImageLoader;
import com.ibm.pdtools.common.component.ui.views.systems.model.ContentLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public abstract class LookupDialog<T>
extends TrayDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(LookupDialog.class);
    private static final String IMG_KEY_REFRESH = "refresh";
    private List<T> selection = new ArrayList<T>();
    private boolean ignoreSelectionChanges = false;
    private ImageLoader images;
    protected String[] initialPatternList;
    protected String[] toolTipList;
    protected Combo[] wPatternList;
    private final String[] labelList;
    private final String[] colNames;
    private final Class<T> type;
    private static final String WILDCARD = "*";
    private Button wLoad;
    protected TableViewer wTableViewer;
    protected Text wSelection;
    protected Label wFilter;
    protected LoadingContentProvider contentProvider = null;
    private DecoratingLabelProvider labelProvider = null;
    private ContentLoader.ICallableWithProgress<List<?>> itemProvider = null;
    protected ViewerComparator tableViewerComparator;

    public LookupDialog(String[] labelList, String[] colNames, String[] initialPatternList, Class<T> type) {
        super(Display.getDefault().getActiveShell());
        this.labelList = labelList == null ? null : Arrays.copyOf(labelList, labelList.length);
        this.colNames = colNames == null ? null : Arrays.copyOf(colNames, colNames.length);
        this.type = type;
        this.setInitialPatternList(initialPatternList);
        this.images = new ImageLoader();
    }

    public void setInitialPatternList(String[] patternList) {
        if (patternList == null) {
            throw new IllegalArgumentException("Must provide non-null patternList.");
        }
        this.initialPatternList = Arrays.copyOf(patternList, patternList.length);
    }

    public void setTooltipList(String ... toolTipList) throws NullPointerException {
        Objects.requireNonNull(toolTipList, "Please provide a non-null toolTipList.");
        this.toolTipList = Arrays.copyOf(toolTipList, toolTipList.length);
        if (toolTipList.length < this.initialPatternList.length) {
            logger.debug((Object)MessageFormat.format("Setting tooltips for the first {0} out of {1} fields", toolTipList.length, this.initialPatternList.length));
        } else if (toolTipList.length > this.initialPatternList.length) {
            logger.debug((Object)MessageFormat.format("Attempting to set {0} tooltips, but only found {1} fields", toolTipList.length, this.initialPatternList.length));
        }
        if (this.wPatternList != null) {
            int i = 0;
            while (i < toolTipList.length) {
                if (i == this.wPatternList.length) break;
                this.wPatternList[i].setToolTipText(this.toolTipList[i]);
                ++i;
            }
        }
    }

    protected void setItemProvider(ContentLoader.ICallableWithProgress<List<?>> itemProvider) {
        this.itemProvider = itemProvider;
    }

    public int open() {
        return super.open();
    }

    protected Control createDialogArea(Composite parent) {
        logger.debug((Object)("Create dialog area for objects of type " + this.type.getSimpleName()));
        this.setDialogName(this.getDialogName());
        LookupDialog.setDialogHelpAvailable((boolean)false);
        this.setHelpAvailable(false);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillAll());
        if (this.wPatternList == null) {
            this.wPatternList = new Combo[this.initialPatternList.length];
        }
        int i = 0;
        while (i < this.wPatternList.length) {
            GUI.label.left((Composite)composite, (String)this.getLabelList()[i], (Object)GUI.grid.d.left1());
            this.wPatternList[i] = this.doCreateFilter(composite, 1);
            if (this.initialPatternList[i] == null) {
                this.initialPatternList[i] = "";
            }
            if (this.toolTipList != null && i < this.toolTipList.length) {
                this.wPatternList[i].setToolTipText(this.toolTipList[i]);
            }
            if (i != this.wPatternList.length - 1) {
                GUI.grid.padding((Composite)composite, (int)1);
            }
            ++i;
        }
        this.wLoad = this.doCreateLoadButton(composite, 1);
        i = 0;
        while (i < this.wPatternList.length) {
            new ComboValueSaver(this.wPatternList[i], ((Object)((Object)this)).getClass().getCanonicalName() + this.getLabelList()[i].replace(":", "") + Messages.LookupDialog_0);
            ++i;
        }
        i = 0;
        while (i < this.wPatternList.length) {
            this.wPatternList[i].setText(this.initialPatternList[i]);
            ++i;
        }
        this.wFilter = GUI.label.left((Composite)composite, (String)Messages.LookupDialog_1, (Object)GUI.grid.d.fillH((int)3));
        this.wFilter.setVisible(false);
        this.wTableViewer = this.doCreateTableViewer(composite, 7);
        logger.debug((Object)"Initialise filters and comparator");
        if (this.getFilters() != null) {
            this.wTableViewer.setFilters(this.getFilters());
        }
        this.wTableViewer.setComparator(this.getComparator(0));
        this.wTableViewer.getTable().setSortDirection(128);
        this.wTableViewer.getTable().setSortColumn(this.wTableViewer.getTable().getColumn(0));
        this.wSelection = GUI.text.fieldReadOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)3));
        int firstPatternLength = this.wPatternList[0].getText().length();
        this.wPatternList[0].setSelection(new Point(firstPatternLength, firstPatternLength));
        this.reloadItemsFromFilter();
        return composite;
    }

    protected abstract String getDialogName();

    protected void setDialogName(String name) {
        Shell shell = this.getShell();
        if (shell != null) {
            shell.setText(name);
        }
    }

    private Combo doCreateFilter(Composite composite, int width) {
        GridData fillH = GUI.grid.d.fillH((int)width);
        fillH.widthHint = 50;
        Combo filter = GUI.combo.editable((Composite)composite, (Object)fillH);
        Listener filterKeyDownListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 0x100000E) {
                    event.doit = false;
                    LookupDialog.this.reloadItems();
                }
            }
        };
        filter.addListener(1, filterKeyDownListener);
        Listener filterTraverseListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 4) {
                    event.doit = false;
                    LookupDialog.this.reloadItems();
                }
            }
        };
        filter.addListener(31, filterTraverseListener);
        Listener filterSelectedListener = new Listener(){

            public void handleEvent(Event event) {
                LookupDialog.this.reloadItemsFromFilter();
            }
        };
        filter.addListener(13, filterSelectedListener);
        Listener filterModifiedListener = new Listener(){

            public void handleEvent(Event event) {
                boolean empty;
                PatternState patternState = LookupDialog.this.getPatternState();
                boolean bl = empty = patternState == null;
                if (LookupDialog.this.contentProvider != null && LookupDialog.this.contentProvider.getLoadedObjects() != null && LookupDialog.this.isFilteredSubset(LookupDialog.this.getPatternState(), LookupDialog.this.contentProvider.getLoadedInput())) {
                    LookupDialog.this.reloadItemsFromFilter();
                }
                LookupDialog.this.wLoad.setEnabled(LookupDialog.this.isValidPatternState(LookupDialog.this.wPatternList));
                if (LookupDialog.this.contentProvider != null && LookupDialog.this.contentProvider.getLoadedObjects() != null && LookupDialog.this.isFilteredSubset(patternState, LookupDialog.this.contentProvider.getLoadedInput()) && !empty && !patternState.equals(LookupDialog.this.contentProvider.getLoadedInput()) && LookupDialog.this.contentProvider.hasLoadedObjects()) {
                    LookupDialog.this.wFilter.setVisible(true);
                } else if (LookupDialog.this.wFilter != null) {
                    LookupDialog.this.wFilter.setVisible(false);
                }
            }
        };
        filter.addListener(24, filterModifiedListener);
        return filter;
    }

    private Button doCreateLoadButton(Composite composite, int width) {
        Button load = GUI.button.push((Composite)composite, (Image)this.images.getImageByName("com.ibm.pdtools.common.component.ui", IMG_KEY_REFRESH), (String)Messages.LookupDialog_3, (Object)GUI.grid.d.horiz((int)4, (boolean)false, (int)width), (boolean)true, (int)64);
        load.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                LookupDialog.this.reloadItems();
            }
        });
        load.setToolTipText(Messages.LookupDialog_3);
        return load;
    }

    private TableViewer doCreateTableViewer(Composite composite, int width) {
        int style = 0x10010B00;
        Table table = this.isMultiselect() ? new Table(composite, style | 2) : new Table(composite, style);
        GridData layoutData = new GridData(4, 4, true, true, width, 1);
        layoutData.widthHint = 450;
        layoutData.heightHint = 300;
        table.setLayoutData((Object)layoutData);
        table.setHeaderVisible(true);
        TableColumn[] columns = new TableColumn[this.colNames.length];
        int i = 0;
        while (i < this.colNames.length) {
            columns[i] = new TableColumn(table, 0);
            columns[i].setText(this.colNames[i]);
            columns[i].setResizable(true);
            columns[i].setMoveable(true);
            columns[i].addSelectionListener((SelectionListener)this.getColumnSelectionAdapter(i));
            ++i;
        }
        final TableViewer viewer = new TableViewer(table);
        this.contentProvider = new LoadingContentProvider(this.itemProvider, this);
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.labelProvider = this.getLabelProvider();
        viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionchangedevent) {
                LookupDialog.this.setSelection(((IStructuredSelection)viewer.getSelection()).toList());
            }
        });
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleclickevent) {
                if (LookupDialog.this.getButton(0).isEnabled()) {
                    LookupDialog.this.okPressed();
                }
            }
        });
        viewer.getTable().addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 0x100000E) {
                    LookupDialog.this.reloadItems();
                    event.doit = false;
                }
            }
        });
        return viewer;
    }

    protected SelectionAdapter getColumnSelectionAdapter(final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LookupDialog.this.wTableViewer.setComparator(null);
                ViewerComparator temp = LookupDialog.this.getComparator(index);
                if (temp == null && LookupDialog.this.tableViewerComparator instanceof TableViewerComparator) {
                    ((TableViewerComparator)LookupDialog.this.tableViewerComparator).updateComparator(index);
                } else if (temp != null) {
                    LookupDialog.this.tableViewerComparator = temp;
                }
                Table table = LookupDialog.this.wTableViewer.getTable();
                if (table.getSortColumn() != table.getColumn(index) || table.getSortDirection() != 128) {
                    logger.debug((Object)MessageFormat.format("Update sort for lookup table to column {0}, ASCENDING", index));
                    table.setSortDirection(128);
                } else {
                    logger.debug((Object)MessageFormat.format("Update sort for lookup table to column {0}, DESCENDING", index));
                    table.setSortDirection(1024);
                }
                table.setSortColumn(table.getColumn(index));
                LookupDialog.this.wTableViewer.setComparator(LookupDialog.this.tableViewerComparator);
            }
        };
        return selectionAdapter;
    }

    protected void updateView() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!LookupDialog.this.wTableViewer.getControl().isDisposed()) {
                    LookupDialog.this.wTableViewer.refresh();
                    Table table = (Table)LookupDialog.this.wTableViewer.getControl();
                    table.setRedraw(false);
                    TableColumn[] tableColumnArray = table.getColumns();
                    int n = tableColumnArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableColumn tc = tableColumnArray[n2];
                        tc.pack();
                        int width = (int)((float)tc.getText().length() * 20.0f);
                        int col = (int)(1.3f * (float)tc.getWidth());
                        if (width < col) {
                            width = col;
                        }
                        tc.setWidth(width);
                        ++n2;
                    }
                    table.setRedraw(true);
                }
                if (!LookupDialog.this.wLoad.isDisposed()) {
                    LookupDialog.this.wLoad.setEnabled(LookupDialog.this.isValidPatternState(LookupDialog.this.wPatternList));
                }
                LookupDialog.this.setSelection(null);
            }
        });
    }

    private void reloadItemsFromFilter() {
        PatternState patternState = this.getPatternState();
        if (patternState != null) {
            this.wTableViewer.setInput((Object)patternState);
            this.updateView();
        } else {
            String[] temp = new String[this.initialPatternList.length];
            int i = 0;
            while (i < temp.length) {
                temp[i] = "";
                ++i;
            }
            this.wTableViewer.setInput((Object)new PatternState(temp));
            this.updateView();
        }
    }

    private void reloadItems() {
        boolean temp = this.contentProvider.isFiltered();
        this.contentProvider.setFiltered(false);
        if (this.getPatternState() != null) {
            this.wTableViewer.setInput((Object)this.getPatternState());
            this.updateView();
        }
        if (this.tableViewerComparator instanceof TableViewerComparator) {
            ((TableViewerComparator)this.tableViewerComparator).resetIndexMap();
        }
        this.wFilter.setVisible(false);
        this.contentProvider.setFiltered(temp);
    }

    protected boolean isMultiselect() {
        return false;
    }

    public abstract DecoratingLabelProvider getLabelProvider();

    protected List<?> getFilteredSubset() {
        return this.contentProvider.getLoadedObjects();
    }

    protected boolean isFilteredSubset(PatternState newInput, PatternState loadedInput) {
        return false;
    }

    protected PatternState getPatternState() {
        if (!this.isValidPatternState(this.wPatternList)) {
            return null;
        }
        String[] temp = new String[this.wPatternList.length];
        int i = 0;
        while (i < this.wPatternList.length) {
            temp[i] = this.wPatternList[i].getText();
            ++i;
        }
        return new PatternState(temp);
    }

    protected boolean isValidPatternState(Combo[] wPatternList) {
        Combo[] comboArray = wPatternList;
        int n = wPatternList.length;
        int n2 = 0;
        while (n2 < n) {
            Combo combo2 = comboArray[n2];
            if (!"".equals(combo2.getText())) {
                return true;
            }
            ++n2;
        }
        return !"".equals(WILDCARD);
    }

    protected ViewerFilter[] getFilters() {
        return null;
    }

    protected ViewerComparator getComparator(int columnIndex) {
        if (this.tableViewerComparator != null && this.tableViewerComparator instanceof TableViewerComparator) {
            ((TableViewerComparator)this.tableViewerComparator).updateComparator(columnIndex);
        } else if (this.tableViewerComparator == null) {
            logger.debug((Object)"Initialise default comparator to use for sorting");
            this.tableViewerComparator = new TableViewerComparator(0, 128);
        }
        return this.tableViewerComparator;
    }

    protected void setSelection(List<?> newSelection) {
        if (this.wSelection.isDisposed()) {
            return;
        }
        if (this.ignoreSelectionChanges || newSelection != null && newSelection.size() > 0 && !this.isSelectable(newSelection.get(0))) {
            this.getButton(0).setEnabled(false);
            this.wSelection.setText(Messages.LookupDialog_4);
            return;
        }
        this.selection.clear();
        if (newSelection != null) {
            for (Object selItem : newSelection) {
                if (selItem.getClass() != this.type) continue;
                this.selection.add(this.type.cast(selItem));
            }
        } else {
            this.wTableViewer.setSelection(null);
        }
        int itemCount = -1;
        if (this.wTableViewer.getTable() != null && !this.wTableViewer.getTable().isDisposed()) {
            itemCount = this.wTableViewer.getTable().getItemCount();
        }
        if (this.contentProvider != null && this.contentProvider.getLoadedObjects() != null && itemCount > 0 && this.contentProvider.getLoadedObjects().size() > 0 && Messages.LookupDialog_Loading.equals(this.contentProvider.getLoadedObjects().get(0))) {
            this.wSelection.setText(Messages.LookupDialog_6);
        } else if (itemCount < 0 || itemCount == 1 && this.contentProvider != null && !this.contentProvider.hasLoadedObjects()) {
            this.wSelection.setText(Messages.LookupDialog_7);
        } else if (this.selection.isEmpty() && itemCount != 1) {
            this.wSelection.setText(MessageFormat.format(Messages.LookupDialog_8, itemCount));
        } else if (this.selection.isEmpty() && itemCount == 1) {
            this.wSelection.setText(Messages.LookupDialog_9);
        } else if (this.selection.size() == 1 || !this.isMultiselect()) {
            T o = this.selection.get(0);
            this.wSelection.setText(MessageFormat.format(Messages.LookupDialog_10, this.getSelectedName(o)));
        } else if (this.isMultiselect()) {
            this.wSelection.setText(Messages.LookupDialog_11);
        }
        if (this.isMultiselect()) {
            this.getButton(0).setEnabled(this.selection.size() >= 1);
        } else {
            this.getButton(0).setEnabled(this.selection.size() == 1);
        }
    }

    protected String getSelectedName(T o) {
        return o.toString();
    }

    public T getFirstSelectedObject() {
        if (this.selection.isEmpty()) {
            return null;
        }
        return this.selection.get(0);
    }

    public List<T> getSelectedObjects() {
        if (this.selection.isEmpty()) {
            return null;
        }
        ArrayList<T> selectedObjects = new ArrayList<T>();
        for (T object : this.selection) {
            selectedObjects.add(object);
        }
        return selectedObjects;
    }

    public String[] getLabelList() {
        return this.labelList == null ? null : Arrays.copyOf(this.labelList, this.labelList.length);
    }

    protected String getWildcard() {
        return WILDCARD;
    }

    protected static Pattern getRegexForm(String pattern) {
        pattern = StringUtils.escapeRegex((String)pattern);
        pattern = pattern.replaceAll(StringUtils.escapeRegex((String)"\\*"), ".*");
        pattern = pattern.replaceAll("\u0000", ".*");
        pattern = pattern.replaceAll("%", ".");
        return Pattern.compile(pattern);
    }

    protected static boolean matchEscapedRegex(String pattern, String matchString) {
        return LookupDialog.getRegexForm(pattern).matcher(matchString).matches();
    }

    protected boolean isResizable() {
        return true;
    }

    public boolean close() {
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        if (this.images != null) {
            this.images.dispose();
        }
        return super.close();
    }

    protected Control createButtonBar(Composite parent) {
        Control buttons = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        this.setSelection(new ArrayList());
        return buttons;
    }

    protected void okPressed() {
        this.ignoreSelectionChanges = true;
        logger.trace(new Object[]{"OK press, selection is now ", this.selection});
        super.okPressed();
    }

    protected boolean isSelectable(Object obj) {
        return true;
    }

    protected class TableViewerComparator
    extends ViewerComparator {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private int columnIndex;
        private boolean sortAscending;
        private Object[] elements;
        private TableItem[] items;
        private Map<Object, Integer> indexMap = new HashMap<Object, Integer>();
        private ByteStringComparator byteStringComparator;

        public TableViewerComparator(int columnIndex, int sortDirection) {
            this.columnIndex = columnIndex;
            this.sortAscending = sortDirection != 1024;
        }

        public void updateComparator(int columnIndex) {
            if (columnIndex == this.columnIndex) {
                this.sortAscending = !this.sortAscending;
            } else {
                this.columnIndex = columnIndex;
                this.sortAscending = true;
            }
        }

        public void resetIndexMap() {
            this.indexMap.clear();
        }

        public int getDirection() {
            return this.sortAscending ? 128 : 1024;
        }

        public boolean getSortAscending() {
            return this.sortAscending;
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (this.indexMap.containsKey(e1)) {
                this.indexMap.put(e1, this.getRowIndex(e1));
            }
            if (this.indexMap.containsKey(e2)) {
                this.indexMap.put(e2, this.getRowIndex(e2));
            }
            if (this.indexMap.get(e1) > this.items.length - 1 || this.indexMap.get(e2) > this.items.length - 1) {
                return 0;
            }
            String s1 = this.items[this.indexMap.get(e1)].getText(this.columnIndex);
            String s2 = this.items[this.indexMap.get(e2)].getText(this.columnIndex);
            if (this.byteStringComparator != null) {
                if (this.getSortAscending()) {
                    return this.byteStringComparator.compare(s1, s2);
                }
                return -this.byteStringComparator.compare(s1, s2);
            }
            return 0;
        }

        private int getRowIndex(Object e1) {
            int i = 0;
            while (i < this.elements.length) {
                if (this.elements[i].equals(e1)) {
                    return i;
                }
                ++i;
            }
            return 0;
        }

        public void sort(final Viewer viewer, Object[] elements) {
            this.elements = (Object[])elements.clone();
            if (this.byteStringComparator == null) {
                if (elements[0] instanceof IHostProvider) {
                    HostType hostType = ((IHostProvider)elements[0]).getSystem().getHostType();
                    this.byteStringComparator = new ByteStringComparator(hostType);
                } else if (elements[0] instanceof IPDHost) {
                    HostType hostType = ((IPDHost)elements[0]).getHostType();
                    this.byteStringComparator = new ByteStringComparator(hostType);
                }
            }
            this.items = ((TableViewer)viewer).getTable().getItems();
            Arrays.sort(elements, new Comparator<Object>(){

                @Override
                public int compare(Object a, Object b) {
                    return TableViewerComparator.this.compare(viewer, a, b);
                }
            });
        }
    }
}

