/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.dialog.lookup;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.core.util.TypedRunnable;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.util.EncodingUtils;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.dialog.lookup.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;

public abstract class LookupContentProvider
implements ILazyContentProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(LookupContentProvider.class);
    private StatusUpdater status;
    private TypedRunnable<List<IZRL>, Void> afterFilter;
    private final IPDHost systemProvider;
    protected TableViewer viewer = null;
    private List<IZRL> viewerData = new ArrayList<IZRL>();
    private List<IZRL> viewerDataFiltered = new ArrayList<IZRL>();
    private Job updateJob;
    private boolean canUseOldData;
    private String filter;
    private String textFilter = "";
    private Object currentInput;

    public LookupContentProvider(IPDHost systemProvider) {
        this.systemProvider = systemProvider;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer == null) {
            throw new IllegalArgumentException();
        }
        if (this.status == null) {
            throw new IllegalStateException();
        }
        this.status.updateStatus(Messages.LookupContentProvider_Idle);
        this.viewer = (TableViewer)viewer;
        if (this.updateJob != null && (newInput != null || viewer.getControl().isDisposed())) {
            this.updateJob.cancel();
        }
        if (newInput == null) {
            this.viewer.setItemCount(0);
            this.filterData();
        } else {
            this.currentInput = newInput;
            this.onInputChange(newInput);
            this.viewerDataFiltered.clear();
            this.viewer.setItemCount(0);
            if (this.canUseOldData && this.canUseLastViewerData()) {
                this.filterData();
            } else {
                this.updateJob = new Job(this.getJobName()){

                    protected IStatus run(IProgressMonitor monitor) {
                        IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                        LookupContentProvider.this.status.updateStatus(this.getName());
                        String newStatus = null;
                        List<? extends IZRL> reloadedData = null;
                        try {
                            reloadedData = LookupContentProvider.this.reloadData(howIsGoing);
                        }
                        catch (InterruptedException e) {
                            logger.trace((Object)"Cancelled lookup of contents for lookup content provider");
                            return new Status(8, "com.ibm.pdtools.common.component.ui", Messages.LookupContentProvider_Cancelled);
                        }
                        if (reloadedData == null) {
                            newStatus = Messages.LookupContentProvider_FailedToLoad;
                            LookupContentProvider.this.viewerData = new ArrayList<IZRL>();
                            LookupContentProvider.this.canUseOldData = false;
                        } else {
                            LookupContentProvider.this.viewerData = new ArrayList<IZRL>(reloadedData);
                            LookupContentProvider.this.canUseOldData = true;
                        }
                        if (!monitor.isCanceled()) {
                            LookupContentProvider.this.filterData();
                        }
                        if (newStatus == null) {
                            newStatus = LookupContentProvider.this.getResultStatusInfo();
                        }
                        LookupContentProvider.this.status.updateStatus(newStatus);
                        return Status.OK_STATUS;
                    }
                };
                this.status.updateStatus(Messages.LookupContentProvider_Waiting);
                this.updateJob.schedule();
            }
        }
    }

    public void filterData() {
        this.viewerDataFiltered.clear();
        for (IZRL resource : this.viewerData) {
            if (!this.matches(resource) || !this.textFilter.isEmpty() && !resource.getName().matches(this.textFilter)) continue;
            this.viewerDataFiltered.add(resource);
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (LookupContentProvider.this.viewer != null && !LookupContentProvider.this.viewer.getTable().isDisposed()) {
                    LookupContentProvider.this.viewer.setItemCount(LookupContentProvider.this.viewerDataFiltered.size());
                    LookupContentProvider.this.viewer.refresh();
                    if (LookupContentProvider.this.afterFilter != null) {
                        LookupContentProvider.this.afterFilter.run(LookupContentProvider.this.viewerDataFiltered);
                    }
                }
            }
        });
    }

    public void updateElement(int i) {
        IZRL data;
        if (this.viewerDataFiltered != null && i < this.viewerDataFiltered.size() && (data = this.viewerDataFiltered.get(i)) != null) {
            Table table = this.viewer.getTable();
            if (!this.viewer.isBusy() && table.getItemCount() > 0) {
                this.viewer.replace((Object)data, i);
            }
        }
    }

    public void dispose() {
        if (this.updateJob != null) {
            this.updateJob.cancel();
        }
    }

    public void setFilter(String filter) {
        this.filter = filter;
        this.updateMatcher(filter);
    }

    public void setTextFilter(String textFilter) {
        this.textFilter = textFilter;
    }

    public String getFilter() {
        return this.filter;
    }

    public Object getInput() {
        return this.currentInput;
    }

    public void setStatusUpdater(StatusUpdater status) {
        this.status = status;
    }

    public void setAfterFilter(TypedRunnable<List<IZRL>, Void> afterFilter) {
        this.afterFilter = afterFilter;
    }

    protected IPDHost getSystem() {
        return this.systemProvider;
    }

    public String toString() {
        return String.valueOf(this.currentInput) + "-" + this.filter + " with " + this.viewerData.size() + " items";
    }

    public boolean equals(Object o) {
        return o != null && this.getClass().equals(o.getClass()) && this.viewerData.equals(((LookupContentProvider)o).viewerData);
    }

    public int hashCode() {
        return this.getClass().hashCode() * this.viewerData.hashCode();
    }

    public abstract boolean canUseLastViewerData();

    public abstract Object getUpLevelInput();

    public abstract void onInputChange(Object var1);

    public abstract void updateMatcher(String var1);

    public abstract String getJobName();

    public abstract String getResultStatusInfo();

    public abstract List<? extends IZRL> reloadData(IHowIsGoing var1) throws InterruptedException;

    public abstract boolean matches(IZRL var1);

    public abstract boolean isValidFor(Object var1);

    public abstract Class<?> getType();

    public boolean canCreateNewResource() {
        return false;
    }

    public boolean createNewResource(IPDHost host, List<IZRL> selection, String filter) {
        return false;
    }

    public Object codepageTranslator(Object input) {
        if (input instanceof String && !this.systemProvider.getCodePage().equals(HostType.ZOS.getCommunicationEncoding())) {
            StringBuilder sb = new StringBuilder((String)input);
            int i = 0;
            while (i < sb.length()) {
                if (!sb.substring(i, i + 1).matches("[_%:\\/\\.\\*\\^&={}\\+]")) {
                    sb.setCharAt(i, EncodingUtils.codepageConverter((char)sb.charAt(i), (String)this.systemProvider.getCodePage(), (String)HostType.ZOS.getCommunicationEncoding()));
                }
                ++i;
            }
            input = sb.toString();
        }
        return input;
    }

    public static interface StatusUpdater {
        public void updateStatus(String var1);
    }
}

