/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.dialog;

import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class PDScrollableWizardDialog
extends WizardDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private int minWidth = 100;
    private int minHeight = 100;

    private PDScrollableWizardDialog(Shell parentShell, IWizard newWizard) {
        super(parentShell, Objects.requireNonNull(newWizard));
    }

    protected Control createContents(Composite parent) {
        this.getShell().setMinimumSize(this.minWidth, this.minHeight);
        return BaseTitleAreaDialog.createScrolledComposite((Composite)parent, (Composite)((Composite)super.createContents(parent)));
    }

    public static int openWizard(final IWizard wizard) {
        final AtomicInteger rc = new AtomicInteger();
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow[] workbenchWindows;
                Shell activeShell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                if (activeShell == null && (workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows()) != null && workbenchWindows.length > 0) {
                    activeShell = workbenchWindows[0].getShell();
                }
                rc.set(new PDScrollableWizardDialog(activeShell, wizard).open());
            }
        });
        return rc.get();
    }
}

