/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.dialog;

import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.util.PDPlatformUIUtils;
import com.ibm.pdtools.common.component.ui.util.PDSafeUIRunner;
import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PDDialogWithText
extends MessageDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(PDDialogWithText.class);
    private String longMessage = null;
    private Text textArea = null;
    private String[] additionalButtonLabels = new String[0];
    private ITextDialogRunnable[] additionalActions = new ITextDialogRunnable[0];

    protected PDDialogWithText(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, String longMessage, String[] additionalButtonLabels, ITextDialogRunnable[] additionalActions) {
        super(parentShell, dialogTitle == null ? null : dialogTitle.trim(), dialogTitleImage, dialogMessage == null ? null : dialogMessage.trim(), dialogImageType, dialogButtonLabels, defaultIndex);
        String filteredTrace;
        PDDialogWithText.checkAdditionalLabelsActionsNonNull(additionalButtonLabels, additionalActions);
        this.longMessage = longMessage;
        this.additionalButtonLabels = additionalButtonLabels;
        this.additionalActions = additionalActions;
        if (PDLogger.isTraceEnabled() && !(filteredTrace = PDDialogs.getTrace()).trim().isEmpty()) {
            logger.trace(new Object[]{MessageFormat.format("{0} : {1} : {2}", dialogTitle, dialogMessage, longMessage == null ? "null" : longMessage.trim()), filteredTrace});
        }
    }

    protected Control createCustomArea(Composite parent) {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 480;
        gridData.minimumHeight = 100;
        this.textArea = GUI.text((Composite)parent, (Object)gridData, (int)2826);
        this.textArea.setFont(JFaceResources.getTextFont());
        this.textArea.setBackground(parent.getDisplay().getSystemColor(1));
        this.textArea.setText(this.longMessage);
        return parent;
    }

    protected Point getInitialSize() {
        Point initialSize = super.getInitialSize();
        initialSize.x = Math.min(initialSize.x, 800);
        return initialSize;
    }

    public static boolean open(int kind, Shell parent, String title, String message, String longMessage, int style) {
        return PDDialogWithText.open(kind, parent, title, message, longMessage, style, new String[0], new ITextDialogRunnable[0]);
    }

    public static boolean open(int kind, Shell parent, String title, String message, String longMessage, int style, String[] additionalButtonLabels, ITextDialogRunnable[] actions) {
        PDDialogWithText.checkAdditionalLabelsActionsNonNull(additionalButtonLabels, actions);
        if (longMessage == null) {
            longMessage = "";
        }
        if (!(longMessage = longMessage.trim()).isEmpty()) {
            actions = PDDialogWithText.insertExtraButtons(actions);
            additionalButtonLabels = PDDialogWithText.insertExtraLabels(additionalButtonLabels);
        }
        PDDialogWithText dialog = new PDDialogWithText(parent, title, null, message, kind, PDDialogWithText.getButtonLabels(kind, additionalButtonLabels), 0, longMessage, additionalButtonLabels, actions);
        dialog.setShellStyle(dialog.getShellStyle() | style | 0x4F0);
        int open = dialog.open();
        boolean rc = open == 0;
        logger.trace(new Object[]{"User clicked: ", rc ? "Yes/Ok" : "No/Cancel", PDDialogs.getTrace()});
        return rc;
    }

    public static void checkAdditionalLabelsActionsNonNull(String[] additionalButtonLabels, ITextDialogRunnable[] actions) {
        Objects.requireNonNull(additionalButtonLabels, "Must specify non-null additionalLabels.");
        Objects.requireNonNull(actions, "Must specify non-null actions.");
        if (additionalButtonLabels.length != actions.length || additionalButtonLabels.length > 1000 || actions.length > 1000) {
            throw new IllegalArgumentException(additionalButtonLabels.length + " " + actions.length);
        }
        int i = 0;
        while (i < additionalButtonLabels.length) {
            if (additionalButtonLabels[i] == null) {
                throw new IllegalArgumentException(i + ": An additional button label is null.");
            }
            ++i;
        }
    }

    private static ITextDialogRunnable[] insertExtraButtons(ITextDialogRunnable[] buttons) {
        ITextDialogRunnable[] newActions = new ITextDialogRunnable[buttons.length + 1];
        System.arraycopy(buttons, 0, newActions, 0, buttons.length);
        newActions[newActions.length - 1] = new DisplayEditorRunnable();
        return newActions;
    }

    private static String[] insertExtraLabels(String[] labels) {
        String[] newLabels = new String[labels.length + 1];
        System.arraycopy(labels, 0, newLabels, 0, labels.length);
        newLabels[newLabels.length - 1] = Messages.PDDialogWithText_EDITOR_DISPLAY;
        return newLabels;
    }

    public static boolean openError(Shell parent, String title, String message, String longMessage) {
        return PDDialogWithText.open(1, parent, title, message, longMessage, 0);
    }

    public static void openErrorThreadSafe(final String title, final String message, final String longMessage) {
        PDSafeUIRunner.asyncExec(new Runnable(){

            @Override
            public void run() {
                PDDialogWithText.open(1, PDPlatformUIUtils.getActiveShell(), title, message, longMessage, 0);
            }
        });
    }

    public static boolean openError(Shell parent, String title, String message, String longMessage, String[] additionalButtonLabels, ITextDialogRunnable[] actions) {
        PDDialogWithText.checkAdditionalLabelsActionsNonNull(additionalButtonLabels, actions);
        return PDDialogWithText.open(1, parent, title, message, longMessage, 0, additionalButtonLabels, actions);
    }

    public static void openErrorThreadSafe(final String title, final String message, final String longMessage, final String[] additionalButtonLabels, final ITextDialogRunnable[] actions) {
        PDSafeUIRunner.asyncExec(new Runnable(){

            @Override
            public void run() {
                PDDialogWithText.openError(PDPlatformUIUtils.getActiveShell(), title, message, longMessage, additionalButtonLabels, actions);
            }
        });
    }

    public static boolean openInformation(Shell parent, String title, String message, String longMessage) {
        return PDDialogWithText.open(2, parent, title, message, longMessage, 0);
    }

    public static boolean openInformation(Shell parent, String title, String message, String longMessage, String[] additionalButtonLabels, ITextDialogRunnable[] actions) {
        PDDialogWithText.checkAdditionalLabelsActionsNonNull(additionalButtonLabels, actions);
        return PDDialogWithText.open(2, parent, title, message, longMessage, 0, additionalButtonLabels, actions);
    }

    public static boolean openQuestion(Shell parent, String title, String message, String longMessage) {
        return PDDialogWithText.open(3, parent, title, message, longMessage, 0);
    }

    public static boolean openQuestion(Shell parent, String title, String message, String longMessage, String[] additionalButtonLabels, ITextDialogRunnable[] actions) {
        PDDialogWithText.checkAdditionalLabelsActionsNonNull(additionalButtonLabels, actions);
        return PDDialogWithText.open(3, parent, title, message, longMessage, 0, additionalButtonLabels, actions);
    }

    public static boolean openWarning(Shell parent, String title, String message, String longMessage) {
        return PDDialogWithText.open(4, parent, title, message, longMessage, 0);
    }

    public static boolean openWarning(Shell parent, String title, String message, String longMessage, String[] additionalButtonLabels, ITextDialogRunnable[] actions) {
        PDDialogWithText.checkAdditionalLabelsActionsNonNull(additionalButtonLabels, actions);
        return PDDialogWithText.open(4, parent, title, message, longMessage, 0, additionalButtonLabels, actions);
    }

    private static String[] getButtonLabels(int kind, String[] additionalButtons) {
        String[] dialogButtonLabels;
        Objects.requireNonNull(additionalButtons);
        switch (kind) {
            case 1: 
            case 2: 
            case 4: {
                dialogButtonLabels = new String[1 + additionalButtons.length];
                dialogButtonLabels[0] = JFaceResources.getString((String)"ok");
                int i = 0;
                while (i < additionalButtons.length) {
                    dialogButtonLabels[i + 1] = additionalButtons[i];
                    ++i;
                }
                break;
            }
            case 3: {
                dialogButtonLabels = new String[2 + additionalButtons.length];
                dialogButtonLabels[0] = JFaceResources.getString((String)"yes");
                dialogButtonLabels[1] = JFaceResources.getString((String)"no");
                int i = 0;
                while (i < additionalButtons.length) {
                    dialogButtonLabels[i + 2] = additionalButtons[i];
                    ++i;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal value for kind in MessageDialog.open()");
            }
        }
        return dialogButtonLabels;
    }

    protected void buttonPressed(int buttonId) {
        if (this.additionalButtonLabels == null || this.additionalButtonLabels.length == 0) {
            super.buttonPressed(buttonId);
            return;
        }
        int actionIndex = this.getAdditionalButtonActionIndex(buttonId);
        if (actionIndex != -1) {
            try {
                this.additionalActions[actionIndex].run(this);
            }
            catch (Exception e) {
                PDDialogs.openErrorThreadSafe(MessageFormat.format(Messages.PDDialogWithText_USER_ACTION_ERR_MSG, this.additionalButtonLabels[actionIndex]));
                return;
            }
        } else {
            super.buttonPressed(buttonId);
        }
    }

    private int getAdditionalButtonActionIndex(int buttonID) {
        String buttonText = this.getButton(buttonID).getText();
        int i = 0;
        while (i < this.additionalButtonLabels.length) {
            if (this.additionalButtonLabels[i].equals(buttonText)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static class DisplayEditorRunnable
    implements ITextDialogRunnable {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        private DisplayEditorRunnable() {
        }

        @Override
        public void run(PDDialogWithText context) {
            PDPlatformUIUtils.editor.openEditorOnActivePage(context.message, context.longMessage, "org.eclipse.ui.DefaultTextEditor", true);
        }
    }

    public static interface ITextDialogRunnable {
        public void run(PDDialogWithText var1);
    }
}

