/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.check.agent.update;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.dialogs.ViewLogErrorDialog;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.ISelectionExpression;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.utils.MultiStatus;
import com.ibm.cic.common.ui.internal.dialogs.YesNoErrorDialog;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Version;

public class CheckAgentUpdateSelectionExpressionRunnable
implements IPlatformRunnable {
    private final VersionRange AGENT_GA_RANGE = new VersionRange("[1.0.0.I20061116_2314,1.0.0.I20061206_1641]");
    private Agent agent;
    private IOffering runningAgentOffering;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public Object run(Object args) throws Exception {
        ISelectionExpression.EvaluationContext context = (ISelectionExpression.EvaluationContext)args;
        this.agent = Agent.getInstance();
        this.runningAgentOffering = this.agent.getAgentOffering();
        Version runningAgentVersion = this.runningAgentOffering.getVersion();
        boolean isGAagent = this.AGENT_GA_RANGE.isIncluded(runningAgentVersion);
        if (!isGAagent) {
            return Status.OK_STATUS;
        }
        AgentUI agentUI = AgentUI.getDefault();
        if (agentUI.getMode() == 1 && agentUI.getWizardSubMode() == 0 && this.isPrereqCheck()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    CheckAgentUpdateSelectionExpressionRunnable.this.checkForAgentUpdate(AgentUI.getActiveWorkbenchShell());
                }
            });
        }
        IOffering offering = this.getOffering(context);
        VersionRange agentTolerance = new VersionRange(offering.getProperties().getProperty("agent.tolerance", "1.0.0.I20061210_0600"));
        return new Status(4, "com.ibm.cic.agent.ui", 0, NLS.bind((String)com.ibm.cic.agent.internal.core.Messages.Agent_agentNotTolerated, (Object[])new Object[]{String.valueOf(offering.getName()) + ' ' + offering.getVersion().toString(), agentTolerance.toString(), runningAgentVersion.toString()}), null);
    }

    private IStatus checkForAgentUpdate(Shell shell) {
        IRepositoryGroup repoGroup = this.agent.getRepositoryGroup();
        RepositoryUtils.loadServiceRepositoriesIfPrefIsSet((IRepositoryGroup)repoGroup, (IOffering[])new IOffering[]{this.runningAgentOffering}, null);
        MultiStatus status = new MultiStatus(Messages.AgentUIAction_agentUpdateAvailable);
        final IOffering offering = this.agent.checkForAgentUpdate(status);
        if (offering == null) {
            return status;
        }
        YesNoErrorDialog dialog = new YesNoErrorDialog(shell, Messages.AgentUIWorkbenchWindowAdvisor_windowTitle, null, (IStatus)status, 2);
        if (dialog.open() != 2) {
            return Status.CANCEL_STATUS;
        }
        IStatus agentRequirementStatus = this.agent.checkAgentRequirement(offering);
        if (!agentRequirementStatus.isOK()) {
            status = new MultiStatus(agentRequirementStatus.getSeverity(), agentRequirementStatus.getPlugin(), agentRequirementStatus.getCode(), agentRequirementStatus.getMessage(), null, null);
            status.add((IStatus)new Status(4, "com.ibm.cic.agent.ui", 0, Messages.AgentUIAction_agentUpdateNotPossible, null));
            dialog = new ErrorDialog(shell, Messages.AgentUIWorkbenchWindowAdvisor_windowTitle, null, (IStatus)status, 4);
            dialog.open();
            return Status.CANCEL_STATUS;
        }
        final IStatus[] updateStatus = new IStatus[]{Status.OK_STATUS};
        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(shell);
        try {
            progressDialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.AgentUIAction_agentUpdateDialogMessage, 1);
                    updateStatus[0] = CheckAgentUpdateSelectionExpressionRunnable.this.agent.updateAgent(offering, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            AgentUI.logException((Throwable)e.getCause());
        }
        catch (InterruptedException e) {
            AgentUI.logException((Throwable)e);
        }
        if (updateStatus[0].isOK()) {
            PlatformUI.getWorkbench().restart();
        } else {
            new ViewLogErrorDialog(shell).open();
        }
        return Status.CANCEL_STATUS;
    }

    private IOffering getOffering(ISelectionExpression.EvaluationContext context) {
        Object adapter;
        if (!(context instanceof IAdaptable)) {
            return null;
        }
        IAdaptable adaptable = (IAdaptable)context;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.cic.common.core.model.IOffering");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!((adapter = adaptable.getAdapter((Class)clazz)) instanceof IOffering)) {
            return null;
        }
        return (IOffering)adapter;
    }

    private boolean isPrereqCheck() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.ibm.cic.agent.internal.ui.wizards.ConditionalInstallPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String className = clazz.getName();
        Exception e = new Exception();
        StackTraceElement[] stackTrace = e.getStackTrace();
        int count = Math.min(16, stackTrace.length);
        int i = 0;
        while (i < count) {
            StackTraceElement element = stackTrace[i];
            if (element.getClassName().equals(className) && element.getMethodName().equals("validateFeatures")) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

