/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.bidi;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.ArabicShaping;
import com.ibm.icu.text.ArabicShapingException;
import com.ibm.icu.text.Bidi;
import java.util.Objects;

public class BidiUtils {
    public static boolean isBidiVisualSupportRequired(String bidiformat) {
        return BidiUtils.isBidiSpecificSupportRequired(bidiformat, "visual");
    }

    public static boolean isBidiRTLSupportRequired(String bidiformat) {
        return BidiUtils.isBidiSpecificSupportRequired(bidiformat, "rtl");
    }

    private static boolean isBidiSpecificSupportRequired(String bidiformat, String requiredPropName) {
        String propStr = "";
        if (requiredPropName.equals("visual")) {
            propStr = "Visual";
        } else if (requiredPropName.equals("rtl")) {
            propStr = "RightToLeft";
        } else {
            return false;
        }
        if (bidiformat == null) {
            return false;
        }
        String defaultBidiFormat = bidiformat;
        return defaultBidiFormat != null && defaultBidiFormat.toLowerCase().contains(propStr.toLowerCase());
    }

    public static String addMarkersToStr(String str, boolean isVisual, boolean isRtl) {
        if (isVisual) {
            str = ((String)str).replaceAll("\n", "\n" + (isRtl ? (char)'\u202e' : '\u202d'));
            str = (isRtl ? (char)'\u202e' : '\u202d') + (String)str;
        }
        return str;
    }

    public static boolean startsWithMarker(String str) {
        return str.charAt(0) == '\u202d' || str.charAt(0) == '\u202e';
    }

    public static String bidiTransform(String text, String formatIn, String formatOut) {
        if (formatIn.equals("") && formatOut.equals("") || text.equals("")) {
            return text;
        }
        String validFormat = "^[(I|V)][(L|R|C|D)][(Y|N)][(S|N)][(N|H|C|A)]$";
        if (!formatIn.matches(validFormat) || !formatOut.matches(validFormat)) {
            throw new Error("The bidi layout string is wrong!");
        }
        if (formatIn.equals(formatOut)) {
            return text;
        }
        short swap = formatIn.charAt(2) != formatOut.charAt(2) ? (short)2 : 0;
        String stage1_text = BidiUtils._doBidiReorder(text, formatIn.substring(0, 2), formatOut.substring(0, 2), swap);
        stage1_text = BidiUtils._doShape(formatIn.substring(3), formatOut.substring(3), stage1_text);
        return stage1_text;
    }

    private static String _doBidiReorder(String text, String formatIn, String formatOut, short swap) {
        int dir;
        Bidi ubidi1 = new Bidi();
        Bidi ubidi2 = new Bidi();
        String inOrdering = formatIn.substring(0, 1);
        String outOrdering = formatOut.substring(0, 1);
        String inOrientation = formatIn.substring(1, 2);
        String outOrientation = formatOut.substring(1, 2);
        Object inFormat = new String(inOrdering + inOrientation);
        Object outFormat = new String(outOrdering + outOrientation);
        if (inOrientation.equals("C") || inOrientation.equals("D")) {
            dir = -1;
            dir = BidiUtils._firstStrongDir(text);
            if (outOrientation.equals("C") || outOrientation.equals("D")) {
                if (dir == 0 || dir == 1) {
                    return text;
                }
                inOrientation = inOrientation.equals("C") ? "L" : "R";
                outOrientation = outOrientation.equals("C") ? "L" : "R";
                inFormat = inOrdering + inOrientation;
                outFormat = outOrdering + outOrientation;
            } else {
                inOrientation = dir == 0 || dir == 1 ? (dir == 0 ? "L" : "R") : (inOrientation.equals("C") ? "L" : "R");
                inFormat = inOrdering + inOrientation;
            }
        }
        if (outOrientation.equals("C") || outOrientation.equals("D")) {
            dir = BidiUtils._firstStrongDir(text);
            outOrientation = dir == 1 ? "R" : (dir == 0 ? ((dir = (int)BidiUtils._lastStrongDir(text)) == 0 ? "L" : "R") : (outOrientation.equals("C") ? "L" : "R"));
            outFormat = outOrdering + outOrientation;
        }
        if (((String)inFormat).equals(outFormat)) {
            return text;
        }
        byte bdLevel = 0;
        if (inOrdering.equals("I") && ((String)outFormat).equals("VL")) {
            if (inOrientation.equals("L")) {
                bdLevel = 0;
            }
            if (inOrientation.equals("R")) {
                bdLevel = 1;
            }
            ubidi1.setReorderingMode(6);
            ubidi1.setPara(text, bdLevel, null);
            return ubidi1.writeReordered((int)swap);
        }
        if (inOrdering.equals("V") && outOrdering.equals("V")) {
            return new StringBuffer(text).reverse().toString();
        }
        if (inOrdering.equals("I") && ((String)outFormat).equals("VR")) {
            bdLevel = inOrientation.equals("L") ? (byte)0 : 1;
            ubidi1.setPara(text, bdLevel, null);
            text = ubidi1.writeReordered(swap | 0x10);
            return text;
        }
        if (((String)inFormat).equals("VL") && ((String)outFormat).equals("IL")) {
            ubidi1.setPara(text, bdLevel, null);
            return ubidi1.writeReordered((int)swap);
        }
        if (inOrdering.equals("V") && outOrdering.equals("I") && !inOrientation.equals(outOrientation)) {
            text = new StringBuffer(text).reverse().toString();
            String string = text = inOrientation.equals("R") ? BidiUtils._doBidiReorder(text, "IL", "VL", swap) : BidiUtils._doBidiReorder(text, "IR", "VR", swap);
        }
        if (((String)inFormat).equals("VR") && ((String)outFormat).equals("IR")) {
            text = BidiUtils._doBidiReorder(text, "IR", "VR", swap);
        }
        if (inOrdering.equals("I") && outOrdering.equals("I")) {
            if (inOrientation.equals("R")) {
                bdLevel = 1;
                ubidi1.setPara(text, bdLevel, null);
                text = ubidi1.writeReordered(0);
                bdLevel = 0;
                ubidi2.setPara(text, bdLevel, null);
                text = ubidi2.writeReordered((int)swap);
            } else {
                bdLevel = 0;
                ubidi1.setPara(text, bdLevel, null);
                text = ubidi1.writeReordered(0);
                text = BidiUtils._doBidiReorder(text, "VL", "IR", swap);
            }
            return text;
        }
        return text;
    }

    private static byte _firstStrongDir(String text) {
        int dir = -1;
        int i = 0;
        while (i < text.length()) {
            dir = UCharacter.getDirection((int)text.charAt(i));
            if (dir == 0 || dir == 1) {
                return dir == 0 ? (byte)0 : 1;
            }
            ++i;
        }
        return -1;
    }

    private static byte _lastStrongDir(String text) {
        return BidiUtils._firstStrongDir(new StringBuffer(text).reverse().toString());
    }

    private static String _doShape(String inFormat, String outFormat, String text) {
        if (inFormat.equals(outFormat)) {
            return text;
        }
        int flags = 0;
        if (inFormat.charAt(0) != outFormat.charAt(0)) {
            int n = flags = outFormat.charAt(0) == 'N' ? 16 : 8;
        }
        if (inFormat.charAt(1) != outFormat.charAt(1)) {
            switch (outFormat.charAt(1)) {
                case 'N': {
                    flags |= 0x40;
                    break;
                }
                case 'H': {
                    flags |= 0x20;
                    break;
                }
                case 'C': {
                    flags |= 0x60;
                    break;
                }
                default: {
                    flags |= 0;
                }
            }
        }
        ArabicShaping araShape = new ArabicShaping(flags);
        try {
            return araShape.shape(text);
        }
        catch (ArabicShapingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String SQL_statement_reordering(String value_, String inFormat, String outFormat) {
        boolean into = false;
        int i = 0;
        int start = 0;
        int end = 0;
        while (i < ((String)value_).length()) {
            String str;
            if (into && (((String)value_).charAt(i) == '\n' || ((String)value_).charAt(i) == '\r')) {
                end = i;
                str = ((String)value_).substring(start, end);
                str = BidiUtils.bidiTransform(str, inFormat, outFormat);
                value_ = ((String)value_).substring(0, start) + str + ((String)value_).substring(end);
                start = i + 1;
            }
            if (((String)value_).charAt(i) == '\'') {
                if (into) {
                    if (i + 1 < ((String)value_).length() && ((String)value_).charAt(i + 1) == '\'') {
                        i += 2;
                        continue;
                    }
                    end = i;
                    str = ((String)value_).substring(start, end);
                    str = BidiUtils.bidiTransform(str, inFormat, outFormat);
                    value_ = ((String)value_).substring(0, start) + str + ((String)value_).substring(end);
                    end = 0;
                    start = 0;
                    into = false;
                } else {
                    into = true;
                    start = i + 1;
                }
            }
            ++i;
        }
        return value_;
    }

    public static String getInputFormat(String bidiFormat, boolean sendToHost) {
        Objects.requireNonNull(bidiFormat, "Must provide a non-null bidiFormat.");
        String defaultBidiFormat = bidiFormat;
        Object inputFormat = "";
        String orderingScheme = "I";
        if (defaultBidiFormat.toLowerCase().contains("Visual".toLowerCase())) {
            orderingScheme = "V";
        }
        String orientation = "L";
        if (defaultBidiFormat.toLowerCase().toString().contains("RightToLeft".toLowerCase())) {
            orientation = "R";
        }
        inputFormat = sendToHost ? "ILYNN" : orderingScheme + orientation + "YNN";
        return inputFormat;
    }

    public static String getOutputFormat(String bidiFormat, boolean sendToHost) {
        String defaultBidiFormat = bidiFormat;
        Object outputFormat = "";
        String orderingScheme = "I";
        if (defaultBidiFormat.toLowerCase().contains("Visual".toLowerCase())) {
            orderingScheme = "V";
        }
        String orientation = "L";
        if (defaultBidiFormat.toLowerCase().toString().contains("RightToLeft".toLowerCase())) {
            orientation = "R";
        }
        outputFormat = sendToHost ? orderingScheme + orientation + "YNN" : "ILYNN";
        return outputFormat;
    }

    public static String bidiTransformText(String input, String inputFormat, String outputFormat) {
        Object output = input;
        output = BidiUtils.bidiTransform(input, inputFormat, outputFormat) + "\u200e";
        return output;
    }

    public static String reverseHexaRepresentation(String input) {
        if (input != null) {
            StringBuffer sb = new StringBuffer(input);
            return sb.reverse().toString();
        }
        return input;
    }
}

