/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.core.util;

import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.comms.NonBlockingSocketIOJhost;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;

public abstract class ReadChunckJob
extends Job {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private NonBlockingSocketIOJhost nonBlockingSocketIOJhost;
    private int msgType;
    private String msgStr;
    private boolean chunked = false;
    private boolean complete = false;
    private boolean overflow = false;
    private StringBuilder stringBuilder;
    private int maxAllowedLength = 0;

    public ReadChunckJob(NonBlockingSocketIOJhost nonBlockingSocketIOJhost, int msgType, String msgStr) {
        this("Read Chunk Job", nonBlockingSocketIOJhost, msgType, msgStr);
    }

    public ReadChunckJob(String name, NonBlockingSocketIOJhost nonBlockingSocketIOJhost, int msgType, String msgStr) {
        super(name);
        this.setThread(new Thread());
        this.nonBlockingSocketIOJhost = nonBlockingSocketIOJhost;
        this.msgType = msgType;
        this.msgStr = msgStr;
        this.setMaxAllowedLength();
        this.resetStringBuilder();
    }

    private StringBuilder resetStringBuilder() {
        this.stringBuilder = new StringBuilder();
        return this.stringBuilder;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.nonBlockingSocketIOJhost.writeMessage(this.msgType, this.msgStr, PDUtils.convertIprogressToIHowIsGoing(monitor));
            while (true) {
                String response;
                if ((response = new String(this.nonBlockingSocketIOJhost.readResponse(PDUtils.convertIprogressToIHowIsGoing(monitor)))).isEmpty()) {
                    if (!this.chunked) {
                        this.chunked = true;
                        continue;
                    }
                    break;
                }
                this.ready(response);
                if (!this.chunked) break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.complete = true;
        this.done();
        return null;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void reschedule() {
        this.resetStringBuilder();
        this.chunked = false;
        this.complete = false;
        this.overflow = false;
        this.schedule();
    }

    public void rescheduleWait4Complete() throws InterruptedException {
        this.reschedule();
        this.join();
        while (!this.isComplete()) {
        }
    }

    private StringBuilder getStringBuilder() {
        return this.stringBuilder;
    }

    public String toString() {
        if (!this.complete) {
            try {
                this.rescheduleWait4Complete();
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        return !this.overflow ? this.getStringBuilder().toString() : null;
    }

    protected void ready(String response) {
        try {
            if (!this.overflow) {
                if (this.maxAllowedLength > 0 && this.stringBuilder.length() + response.length() > this.maxAllowedLength) {
                    this.overflow = true;
                    this.overflow(true);
                    return;
                }
                this.stringBuilder.append(response);
            }
        }
        catch (Exception e) {
            this.resetStringBuilder();
            this.overflow = true;
            this.overflow(false);
        }
    }

    protected void done() {
    }

    protected void overflow(boolean beyondAllowedLength) {
    }

    protected void setMaxAllowedLength() {
        this.setMaxAllowedLength(0);
    }

    protected void setMaxAllowedLength(int maxAllowedLength) {
        this.maxAllowedLength = maxAllowedLength;
    }
}

