/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.core.util;

import com.ibm.pdtools.common.component.core.util.PDFileUtils;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Objects;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class PDXMLMementoUtils {
    public static XMLMemento loadMementoFromFile(File file) throws WorkbenchException, IOException {
        Objects.requireNonNull(file, "Must provide a non-null file.");
        return PDFileUtils.readFile(file, new PDFileUtils.PDUTF8Reader<XMLMemento>(){

            @Override
            public XMLMemento read(Reader r) throws WorkbenchException {
                return XMLMemento.createReadRoot((Reader)r);
            }
        });
    }

    public static void saveMementoToFile(File file, XMLMemento memento) throws IOException {
        Objects.requireNonNull(file, "Please specify a non-null file");
        Objects.requireNonNull(memento, "Please specify a non-null memento");
        StringWriter sw = new StringWriter();
        memento.save((Writer)sw);
        PDFileUtils.writeFile(file, sw);
    }
}

