/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.core.util;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.IResourceUtils;
import com.ibm.pdtools.common.component.core.util.Ipv6Utils;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProviderName;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Base64;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;

public enum PDFileSystemUtil {
    UTIL;

    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger;
    public static final String TEMPORARY_FOLDER_NAME = "TMP";
    public static final String TEMPORARY_FILE_PREFIX = "tmp";

    static {
        logger = PDLogger.get(PDFileSystemUtil.class);
    }

    @Deprecated
    public static IFile getLocalCacheFile(String configProjectName, IHostProviderName aResource, String filePrefix, String extension) throws CoreException {
        return PDFileSystemUtil.getLocalCacheFile(configProjectName, aResource, filePrefix, extension, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IFile getLocalCacheFile(String configProjectName, IHostProviderName aResource, String filePrefix, String extension, IProgressMonitor monitor) throws CoreException {
        String cacheFileName = Base64.getUrlEncoder().encodeToString((filePrefix + aResource.copyName()).getBytes(StandardCharsets.UTF_8)).replace('/', '-') + extension;
        if (aResource.getClass().getTypeName() != null && aResource.getClass().getTypeName().contains("UssFile")) {
            cacheFileName = Base64.getUrlEncoder().encodeToString(String.valueOf(Math.random()).getBytes(StandardCharsets.UTF_8)) + extension;
        }
        logger.debug(MessageFormat.format("Local cache file for {0} at {1} with prefix of {2} is [{3}]", aResource.copyName(), aResource.getSystem().getConnectionName(), filePrefix, cacheFileName));
        IProject configProject = PDFileSystemUtil.getConfigProject(configProjectName, true, monitor);
        String connectionName = Ipv6Utils.encode(aResource.getSystem().getConnectionName());
        String systemFolder = Objects.requireNonNull(connectionName, "Must provide a non-null system connection name.").toUpperCase();
        return IResourceUtils.mkdirsChecked(configProject, systemFolder, monitor, false).getFile(cacheFileName);
    }

    @Deprecated
    public static IProject getConfigProject(String configProjectName, boolean createAndOpen) {
        return PDFileSystemUtil.getConfigProject(configProjectName, createAndOpen, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IProject getConfigProject(String configProjectName, boolean createAndOpen, IProgressMonitor monitor) {
        Objects.requireNonNull(configProjectName, "Must provide a non-null configProjectName.");
        configProjectName = configProjectName.trim();
        if (configProjectName.isEmpty()) {
            throw new IllegalArgumentException("Must provide a non-empty configProjectName.");
        }
        IProject configProject = ResourcesPlugin.getWorkspace().getRoot().getProject(configProjectName);
        configProject.exists();
        if (createAndOpen) {
            IResourceUtils.createAnOpenProjectAsNeeded(configProject, monitor);
            IResourceUtils.setHidden(configProject, true);
            if (!configProject.exists()) {
                logger.trace(MessageFormat.format("Project: {0} does not exist.", configProject));
            }
        }
        return configProject;
    }

    @Deprecated
    public static IFile getTempFile(String configProjectName) throws CoreException {
        return PDFileSystemUtil.getTempFile(configProjectName, (IProgressMonitor)new NullProgressMonitor(), false);
    }

    public static IFile getTempFile(String configProjectName, IProgressMonitor monitor, boolean refresh) throws CoreException {
        IProject configProject = PDFileSystemUtil.getConfigProject(configProjectName, true, monitor);
        IFolder folder = IResourceUtils.mkdirsChecked(configProject, TEMPORARY_FOLDER_NAME, monitor, refresh);
        if (folder != null) {
            return folder.getFile(TEMPORARY_FILE_PREFIX + System.currentTimeMillis() + ".txt");
        }
        throw new CoreException((IStatus)new Status(4, "com.ibm.pdtools.common.component.core", "Could not get / create temporary folder /tmp in the project " + configProjectName));
    }

    @Deprecated
    public static void deleteAllTemporaryFiles(String configProjectName) {
        PDFileSystemUtil.deleteAllTemporaryFiles(configProjectName, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void deleteAllTemporaryFiles(String configProjectName, IProgressMonitor monitor) {
        if (configProjectName != null && !configProjectName.isEmpty()) {
            IFolder folder;
            logger.trace(MessageFormat.format("Attempting to delete {0} temporary files.", configProjectName));
            IProject configProject = PDFileSystemUtil.getConfigProject(configProjectName, true, monitor);
            if (configProject != null && (folder = configProject.getFolder(TEMPORARY_FOLDER_NAME)) != null) {
                Collection<IResource> resources = IResourceUtils.ls(folder, monitor, false);
                for (IResource iResource : resources) {
                    if (!(iResource instanceof IFile)) continue;
                    IResourceUtils.deleteIResource(iResource, true, false, monitor, false);
                }
            }
        }
    }
}

